/*
 * ChartReportElement.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 3 giugno 2003, 23.28
 */

package it.businesslogic.ireport;
import java.awt.*;
import java.io.File;

import it.businesslogic.ireport.util.*;
import it.businesslogic.ireport.chart.*;

import java.util.*;

/**
 *
 * @author  Administrator
 */
public class ChartReportElement extends it.businesslogic.ireport.ImageReportElement {
    

    
    private int chartType = 1;
    private String title = "Sample chart";
    private boolean legend = false;
   
    
    private int chartWidth = 640;
    private int chartHeight = 480;
	private File reportDirectory = null;
	private IReportChartProperties chartProperties = null;
	private boolean chartEmbedded = true;
	private String chartFilename = null;

    
    /** Creates a new instance of ChartReportElement */
   // private JFreeChart chart = null;
    
    public ChartReportElement(int x, int y, int width, int height)
    {
		super(x,y,width,height);
                setGraphicElementPen("Thin");
		this.setBgcolor(Color.WHITE);
		this.setFgcolor(Color.BLACK);
                
        if (getImgDef() == null)
        {
            // Load default image...
            setImgDef(Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif"));
        }
                
        setImg( null );
		setIsUsingCache(false);
		setImageExpression("");
		setImageClass("java.awt.Image");
		setScaleImage("RetainShape");
		setGraphicElementPen("None");
        setHyperlinkType("None");
        setAnchorNameExpression("");
        chartWidth = 640;
        chartHeight = 480;
        
        chartProperties = new IReportChartProperties();
        chartProperties.setWidth(chartWidth);
		chartProperties.setHeight(chartHeight);
        
        this.setImg(null);
	}
    
    
     public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin)
     {

		if (this.getImg() == null) 
		{	
            //
			this.setImg( IReportChartFactory.iReportChart(title, chartWidth, chartHeight , chartType , legend , this.getBgcolor()) );                    
		}
                

        super.drawObject(g,  zoom_factor, x_shift_origin, y_shift_origin);
	}
         
     /** Getter for property chartType.
      * @deprecated Use function getChartProperties().getType().
      * @return Value of property chartType.
      *
      */
     public int getChartType() {
         return chartProperties.getType(0);
     }
     
     /** Setter for property chartType.
      * @deprecated Use function getChartProperties().setType().
      * @param chartType New value of property chartType.
      *
      */
     public void setChartType(int chartType) {
         
         if (this.chartType != chartType)
         {
            this.chartType = chartType;
			chartProperties.setType(0, chartType);
			this.setImg(null);
         }
     }
     
     /** Getter for property legend.
      * @deprecated Use function getChartProperties().isLegendVisible();
      * @return Value of property legend.
      *
      */
     public boolean isLegend() {
         return chartProperties.isLegendVisible(0);
     }
     
     /** Setter for property legend.
      * @deprecated Use function getChartProperties().setLegendVisible();
      * @param legend New value of property legend.
      *
      */
     public void setLegend(boolean legend) {
         this.legend = legend;
		 chartProperties.setLegendVisible(0, legend);

         int tmp = this.chartType;
         this.chartType = -1;
         this.setChartType(tmp);      
     }
     
     /** Getter for property title.
      * @deprecated Use function getChartProperties().getTitle();
      * @return Value of property title.
      *
      */
     public java.lang.String getTitle() {
         return chartProperties.getTitle(0);
     }
     
     /** Setter for property title.
      * @deprecated Use function getChartProperties().setTitle();
      * @param title New value of property title.
      *
      */
     public void setTitle(java.lang.String title) {
         this.title = title;
		 chartProperties.setTitle(0, title);
         this.setImg(null);
     }
     
     /** Getter for property chartWidth.
      * @return Value of property chartWidth.
      *
      */
     public int getChartWidth() {
         return chartWidth;
     }
     
     /** Setter for property chartWidth.
      * @param chartWidth New value of property chartWidth.
      *
      */
     public void setChartWidth(int chartWidth) {
         this.chartWidth = chartWidth;
		 chartProperties.setWidth(chartWidth);
         this.setImg(null);
     }
     
     /** Getter for property chartHeight.
      * @return Value of property chartHeight.
      *
      */
     public int getChartHeight() {
         return chartHeight;
     }
     
     /** Setter for property chartHeight.
      * @param chartHeight New value of property chartHeight.
      *
      */
     public void setChartHeight(int chartHeight) {
         this.chartHeight = chartHeight;
 		 chartProperties.setHeight(chartHeight);
         this.setImg(null);
     }
     
     public void parseExpression(String expression)
     {
         expression = expression.trim();
         expression = Misc.string_replace("","(java.awt.Image)it.businesslogic.ireport.chart.IReportChartFactory.iReportChart(", expression);
         // REmove last )
         if (expression.endsWith(")"))
             expression = expression.substring(0, expression.length() -1);
             
         StringTokenizer st = new StringTokenizer(expression, "\n");    
     }
	/**
	 * It's a important runtime property for find files.
	 * @param file
	 */
	public void setReportDirectory(File file) {
		reportDirectory = file;
	}

	/**
	 * Properties for renderer chart.
	 * @return
	 */
	public IReportChartProperties getChartProperties() {
		return chartProperties;
	}

	/**
	 * Properties for renderer chart.
	 * @param properties
	 */
	public void setChartProperties(IReportChartProperties properties) {
		chartProperties = properties;
	}

	/**
	 * @return
	 */
	public boolean isChartEmbedded() {
		return chartEmbedded;
	}

	/**
	 * @param b
	 */
	public void setChartEmbedded(boolean b) {
		chartEmbedded = b;
	}

	/**
	 * @return
	 */
	public String getChartFilename() {
		return chartFilename;
	}

	/**
	 * @param string
	 */
	public void setChartFilename(String string) {
		chartFilename = string;
	}

}
