/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.util.Misc;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.HashMap;

public class ScriptletCode {
    public static final int GLOBAL_DECLARATIONS = 0;
    public static final int EVENT_AFTER_COLUMN_INIT = 1;
    public static final int EVENT_AFTER_DETAIL_EVAL = 2;
    public static final int EVENT_AFTER_GROUP_INIT = 3;
    public static final int EVENT_AFTER_PAGE_INIT = 4;
    public static final int EVENT_AFTER_REPORT_INIT = 5;
    public static final int EVENT_BEFORE_COLUMN_INIT = 6;
    public static final int EVENT_BEFORE_DETAIL_EVAL = 7;
    public static final int EVENT_BEFORE_GROUP_INIT = 8;
    public static final int EVENT_BEFORE_PAGE_INIT = 9;
    public static final int EVENT_BEFORE_REPORT_INIT = 10;
    public static final int LAST_PORTION = 10;
    public String[] portion_keywords = null;
    protected HashMap code_portions = new HashMap();

    public ScriptletCode() {
        this.portion_keywords = new String[11];
        this.portion_keywords[0] = "GLOBAL_DECLARATIONS";
        this.portion_keywords[1] = "EVENT_AFTER_COLUMN_INIT";
        this.portion_keywords[2] = "EVENT_AFTER_DETAIL_EVAL";
        this.portion_keywords[3] = "EVENT_AFTER_GROUP_INIT";
        this.portion_keywords[4] = "EVENT_AFTER_PAGE_INIT";
        this.portion_keywords[5] = "EVENT_AFTER_REPORT_INIT";
        this.portion_keywords[6] = "EVENT_BEFORE_COLUMN_INIT";
        this.portion_keywords[7] = "EVENT_BEFORE_DETAIL_EVAL";
        this.portion_keywords[8] = "EVENT_BEFORE_GROUP_INIT";
        this.portion_keywords[9] = "EVENT_BEFORE_PAGE_INIT";
        this.portion_keywords[10] = "EVENT_BEFORE_REPORT_INIT";
    }

    public String getPortion(int portion) {
        if (this.code_portions.get("" + portion) == null) {
            return "";
        }
        return (String)this.code_portions.get("" + portion);
    }

    public void setPortionCode(int portion, String code) {
        this.code_portions.put("" + portion, code);
    }

    public StringBuffer getAll() {
        StringBuffer s = new StringBuffer();
        String global_portion = this.getPortion(0).trim();
        int i = global_portion.lastIndexOf("}");
        global_portion = global_portion.substring(0, i) + global_portion.substring(i + 1);
        s.append(global_portion);
        s.append("\n");
        for (int k = 1; k < 11; ++k) {
            s.append("/** Begin " + this.portion_keywords[k] + " This line is generated by iReport. Don't modify or move please! */\n");
            s.append(this.getPortion(k));
            s.append("/** End " + this.portion_keywords[k] + " This line is generated by iReport. Don't modify or move please! */\n");
        }
        s.append("\n}");
        return s;
    }

    public ScriptletCode(String filename) throws FileNotFoundException, IOException {
        this(new FileReader(filename));
    }

    public ScriptletCode(Reader in) throws IOException {
        this();
        LineNumberReader lin = new LineNumberReader(in);
        String line = "";
        int actualPortion = 0;
        while ((line = lin.readLine()) != null) {
            if (line.trim().startsWith("/** Begin EVENT_AFTER_COLUMN_INIT")) {
                actualPortion = 1;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_AFTER_DETAIL_EVAL")) {
                actualPortion = 2;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_AFTER_GROUP_INIT")) {
                actualPortion = 3;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_AFTER_PAGE_INIT")) {
                actualPortion = 4;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_AFTER_REPORT_INIT")) {
                actualPortion = 5;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_BEFORE_COLUMN_INIT")) {
                actualPortion = 6;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_BEFORE_DETAIL_EVAL")) {
                actualPortion = 7;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_BEFORE_GROUP_INIT")) {
                actualPortion = 8;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_BEFORE_PAGE_INIT")) {
                actualPortion = 9;
                continue;
            }
            if (line.trim().startsWith("/** Begin EVENT_BEFORE_REPORT_INIT")) {
                actualPortion = 10;
                continue;
            }
            if (line.trim().startsWith("/** End EVENT_")) {
                actualPortion = 0;
                continue;
            }
            this.append(line, actualPortion);
        }
    }

    public void append(String line, int portion) {
        String str = Misc.nvl(this.code_portions.get("" + portion), "");
        str = str + line + "\n";
        this.code_portions.put("" + portion, str);
    }
}

