/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JREmptyDataSource;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.connection.DriverPool;
import it.businesslogic.ireport.connection.PasswordDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JOptionPane;

public class JDBCConnection
extends IReportConnection {
    private String JDBCDriver;
    private String username;
    private String password;
    private String url;
    private String database;
    private boolean savePassword;
    private String name;
    private String serverAddress;

    public Connection getConnection() {
        try {
            MainFrame.getMainInstance().getReportClassLoader().rescanLibDirectory();
            DriverPool.registerDriver(this.getJDBCDriver(), MainFrame.getMainInstance().getReportClassLoader());
            Driver driver = DriverPool.getDriver(this.url);
            Properties connectProps = new Properties();
            connectProps.setProperty("user", this.username);
            connectProps.setProperty("password", this.password);
            Connection conn = driver.connect(this.url, connectProps);
            return conn;
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(null, this.getName() + "\nNoClassDefFoundError!!\nCheck your classpath!\n" + ex.getMessage(), "Error", 0);
            return null;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(null, this.getName() + "\nClassNotFoundError!\nMsg:" + ex.getMessage() + "\nPossible not found class:" + this.getJDBCDriver() + "\nCheck your classpath!", "Error", 0);
            return null;
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, this.getName() + "\nSQL problems:\n" + ex.getMessage() + "\n" + this.url, "Error", 0);
            return null;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, this.getName() + "\nGeneral problem:\n" + ex.getMessage() + "\n\nPlease check your username and password. The DBMS is running?!", "Error", 0);
            return null;
        }
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    public boolean isJDBCConnection() {
        return true;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getJDBCDriver() {
        return this.JDBCDriver;
    }

    public void setJDBCDriver(String JDBCDriver) {
        this.JDBCDriver = JDBCDriver;
    }

    public String getPassword() {
        if (this.isSavePassword()) {
            return this.password;
        }
        PasswordDialog pd = new PasswordDialog(null, true);
        pd.show();
        if (pd.getDialogResult() == 0) {
            return pd.getPassword();
        }
        return "";
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("JDBCDriver", Misc.nvl(this.getJDBCDriver(), ""));
        map.put("Url", Misc.nvl(this.getUrl(), ""));
        map.put("Database", Misc.nvl(this.getDatabase(), ""));
        map.put("Username", Misc.nvl(this.getUsername(), ""));
        if (this.isSavePassword()) {
            map.put("Password", Misc.nvl(this.getPassword(), ""));
        } else {
            map.put("Password", "");
        }
        map.put("SavePassword", "" + this.isSavePassword());
        map.put("ServerAddress", Misc.nvl(this.getServerAddress(), ""));
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setJDBCDriver((String)map.get("JDBCDriver"));
        this.setUrl((String)map.get("Url"));
        this.setDatabase((String)map.get("Database"));
        this.setUsername((String)map.get("Username"));
        this.setSavePassword(("" + map.get("SavePassword")).equals("true"));
        if (this.isSavePassword()) {
            this.setPassword(Misc.nvl((String)map.get("Password"), ""));
        }
        this.setServerAddress(Misc.nvl((String)map.get("ServerAddress"), ""));
    }

    public String getDescription() {
        return "Database JDBC Connection (" + this.getUrl() + ")";
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }
}

