/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.Report;
import it.businesslogic.ireport.gui.JRParameterDialog;
import it.businesslogic.ireport.gui.JRTextExpressionArea;
import it.businesslogic.ireport.util.Misc;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class JRVariableDialog
extends JDialog {
    JRVariable tmpVariable = null;
    Report report = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBoxCalculationType;
    private JComboBox jComboBoxClassType;
    private JComboBox jComboBoxResetGroup;
    private JComboBox jComboBoxResetType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JRTextExpressionArea jRTextExpressionAreaExpression;
    private JRTextExpressionArea jRTextExpressionAreaInitialExpression;
    private JTextField jTextFieldName;
    private JTextField jTextFieldNameIncrementerFactoryClass;
    private int dialogResult;

    public JRVariableDialog(Report report, Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.report = report;
        this.updateGroups();
        this.setSize(360, 404);
        this.jRTextExpressionAreaExpression.setText("");
        this.jRTextExpressionAreaInitialExpression.setText("");
        this.setTypes();
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        this.jComboBoxCalculationType.setSelectedItem("Nothing");
        this.jComboBoxResetType.setSelectedItem("Report");
        this.updateGroups();
        Misc.centerFrame(this);
    }

    public void setTypes() {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem("dori.jasper.engine.JREmptyDataSource");
        this.jComboBoxCalculationType.addItem("Nothing");
        this.jComboBoxCalculationType.addItem("Count");
        this.jComboBoxCalculationType.addItem("Sum");
        this.jComboBoxCalculationType.addItem("Average");
        this.jComboBoxCalculationType.addItem("Lowest");
        this.jComboBoxCalculationType.addItem("Highest");
        this.jComboBoxCalculationType.addItem("StandardDeviation");
        this.jComboBoxCalculationType.addItem("Variance");
        this.jComboBoxCalculationType.addItem("System");
        this.jComboBoxResetType.addItem("None");
        this.jComboBoxResetType.addItem("Report");
        this.jComboBoxResetType.addItem("Page");
        this.jComboBoxResetType.addItem("Column");
        this.jComboBoxResetType.addItem("Group");
    }

    public void updateGroups() {
        if (this.getReport() != null) {
            Misc.updateStringComboBox(this.jComboBoxResetGroup, this.getReport().getGroups(), true);
        } else {
            this.jComboBoxResetGroup.removeAllItems();
            this.jComboBoxResetGroup.addItem("");
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel2 = new JLabel();
        this.jComboBoxResetGroup = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel5 = new JLabel();
        this.jComboBoxResetType = new JComboBox();
        this.jComboBoxCalculationType = new JComboBox();
        this.jLabel6 = new JLabel();
        this.jComboBoxClassType = new JComboBox();
        this.jLabel7 = new JLabel();
        this.jRTextExpressionAreaInitialExpression = new JRTextExpressionArea();
        this.jRTextExpressionAreaExpression = new JRTextExpressionArea();
        this.jLabel8 = new JLabel();
        this.jTextFieldNameIncrementerFactoryClass = new JTextField();
        this.getContentPane().setLayout(null);
        this.setTitle("Add/modify variable");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRVariableDialog.this.closeDialog(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 11));
        this.jLabel1.setText("Variable name");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(4, 4, 250, 15);
        this.jTextFieldName.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jTextFieldName);
        this.jTextFieldName.setBounds(4, 20, 340, 22);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("Calculation type");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(194, 46, 150, 15);
        this.jComboBoxResetGroup.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jComboBoxResetGroup);
        this.jComboBoxResetGroup.setBounds(160, 104, 184, 22);
        this.jLabel3.setFont(new Font("Dialog", 0, 11));
        this.jLabel3.setText("Variable expression");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(4, 170, 250, 15);
        this.jLabel4.setFont(new Font("Dialog", 0, 11));
        this.jLabel4.setText("Initial value expression");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(4, 254, 250, 15);
        this.jButtonCancel.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonCancel);
        this.jButtonCancel.setBounds(274, 350, 70, 25);
        this.jButtonOK.setFont(new Font("Dialog", 0, 11));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRVariableDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.getContentPane().add(this.jButtonOK);
        this.jButtonOK.setBounds(198, 350, 70, 25);
        this.jLabel5.setFont(new Font("Dialog", 0, 11));
        this.jLabel5.setText("Variable class type");
        this.getContentPane().add(this.jLabel5);
        this.jLabel5.setBounds(4, 46, 170, 15);
        this.jComboBoxResetType.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jComboBoxResetType);
        this.jComboBoxResetType.setBounds(4, 104, 150, 22);
        this.jComboBoxCalculationType.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jComboBoxCalculationType);
        this.jComboBoxCalculationType.setBounds(194, 62, 150, 22);
        this.jLabel6.setFont(new Font("Dialog", 0, 11));
        this.jLabel6.setText("Reset group");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(160, 88, 190, 15);
        this.jComboBoxClassType.setEditable(true);
        this.jComboBoxClassType.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jComboBoxClassType);
        this.jComboBoxClassType.setBounds(4, 62, 184, 22);
        this.jLabel7.setFont(new Font("Dialog", 0, 11));
        this.jLabel7.setText("Reset type");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(4, 88, 130, 15);
        this.jRTextExpressionAreaInitialExpression.setBorder(new EtchedBorder());
        this.jRTextExpressionAreaInitialExpression.setElectricScroll(0);
        this.jRTextExpressionAreaInitialExpression.setMinimumSize(new Dimension(0, 0));
        this.jRTextExpressionAreaInitialExpression.setPreferredSize(new Dimension(0, 0));
        this.getContentPane().add(this.jRTextExpressionAreaInitialExpression);
        this.jRTextExpressionAreaInitialExpression.setBounds(6, 274, 338, 64);
        this.jRTextExpressionAreaExpression.setBorder(new EtchedBorder());
        this.jRTextExpressionAreaExpression.setElectricScroll(0);
        this.jRTextExpressionAreaExpression.setMinimumSize(new Dimension(0, 0));
        this.jRTextExpressionAreaExpression.setPreferredSize(new Dimension(0, 0));
        this.getContentPane().add(this.jRTextExpressionAreaExpression);
        this.jRTextExpressionAreaExpression.setBounds(4, 188, 338, 64);
        this.jLabel8.setFont(new Font("Dialog", 0, 11));
        this.jLabel8.setText("Custom Incrementer Factory Class");
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(4, 130, 340, 15);
        this.jTextFieldNameIncrementerFactoryClass.setFont(new Font("Dialog", 0, 11));
        this.getContentPane().add(this.jTextFieldNameIncrementerFactoryClass);
        this.jTextFieldNameIncrementerFactoryClass.setBounds(4, 146, 340, 22);
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, "Please insert a valid variable name!", "Invalid variable!", 2);
            return;
        }
        this.tmpVariable = new JRVariable(this.jTextFieldName.getText(), false);
        this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem() + "");
        this.tmpVariable.setCalculation(this.jComboBoxCalculationType.getSelectedItem() + "");
        this.tmpVariable.setResetType(this.jComboBoxResetType.getSelectedItem() + "");
        this.tmpVariable.setIncrementerFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());
        if (this.jComboBoxClassType.getSelectedItem().toString().trim().length() != 0) {
            this.tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem().toString().trim());
        } else {
            this.tmpVariable.setClassType("java.lang.String");
        }
        if (this.tmpVariable.getResetType().equals("Group")) {
            if (this.jComboBoxResetGroup.getSelectedItem() == null || this.jComboBoxResetGroup.getSelectedItem().equals("")) {
                JOptionPane.showMessageDialog(this, "Please choose a valid group for the reset type selected!", "Invalid group!", 2);
                return;
            }
            this.tmpVariable.setResetGroup(this.jComboBoxResetGroup.getSelectedItem() + "");
        }
        this.tmpVariable.setExpression(this.jRTextExpressionAreaExpression.getText());
        this.tmpVariable.setInitialValueExpression(this.jRTextExpressionAreaInitialExpression.getText());
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public static void main(String[] args) {
        new JRParameterDialog((Frame)new JFrame(), true).show();
    }

    public JRVariable getVariable() {
        return this.tmpVariable;
    }

    public void setVariable(JRVariable tmpVariable) {
        this.jTextFieldName.setText(new String(tmpVariable.getName()));
        this.jComboBoxClassType.setSelectedItem(new String(tmpVariable.getClassType()));
        this.jComboBoxResetType.setSelectedItem(new String(tmpVariable.getResetType()));
        this.jComboBoxCalculationType.setSelectedItem(new String(tmpVariable.getCalculation()));
        this.jComboBoxResetGroup.setSelectedItem(tmpVariable.getResetGroup());
        this.jRTextExpressionAreaExpression.setText(new String(tmpVariable.getExpression()));
        this.jRTextExpressionAreaInitialExpression.setText(new String(tmpVariable.getInitialValueExpression()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpVariable.getIncrementerFactoryClass()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
    }
}

