/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import bsh.EvalError;
import bsh.Interpreter;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRExpression;
import dori.jasper.engine.design.JRBshGenerator;
import dori.jasper.engine.design.JRDesignExpression;
import dori.jasper.engine.design.JRDesignParameter;
import dori.jasper.engine.design.JasperDesign;
import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.JRField;
import it.businesslogic.ireport.JRParameter;
import it.businesslogic.ireport.gui.JRSQLExpressionArea;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;

public class ReportQueryDialog
extends JDialog {
    Timer stoppedChanging = new Timer(500, new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (ReportQueryDialog.this.automaticlyReadFieldsCheckBox.isSelected()) {
                ReportQueryDialog.this.processQueryChanged(ReportQueryDialog.this.jRSQLExpressionArea1.getText().trim());
            }
        }
    });
    Map parameterNameToExpressionID = null;
    private JCheckBox automaticlyReadFieldsCheckBox;
    private JButton cancelButton;
    private JLabel columnsErrorMsgLabel;
    private JScrollPane columnsErrorScrollPane;
    private JScrollPane columnsScrollPane;
    private JButton jButtonReadBeanAttributes;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel9;
    private JPanel jPanelSQL;
    private JRSQLExpressionArea jRSQLExpressionArea1;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTable jTableFields;
    private JTextField jTextFieldBeanClass;
    private JButton okButton;
    private JButton readFieldsButton;
    private JReportFrame jReportFrame;
    private boolean isSettingSQLExpression = false;

    public ReportQueryDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(520, 500);
        Misc.centerFrame(this);
        this.stoppedChanging.setRepeats(false);
        this.jRSQLExpressionArea1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.okButton.setEnabled(false);
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void insertUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.okButton.setEnabled(false);
                ReportQueryDialog.this.stoppedChanging.restart();
            }

            public void removeUpdate(DocumentEvent e) {
                if (ReportQueryDialog.this.isSettingSQLExpression) {
                    return;
                }
                ReportQueryDialog.this.okButton.setEnabled(false);
                ReportQueryDialog.this.stoppedChanging.restart();
            }
        });
        this.setColumnsError("Please open a report.");
    }

    private void processQueryChanged(String query) {
        if (this.jReportFrame == null) {
            this.setColumnsError("Please open a report.");
            return;
        }
        if (query.length() == 0) {
            this.setColumnsError("You must insert a valid query first");
            return;
        }
        IReportConnection conn = (IReportConnection)this.getJReportFrame().getMainFrame().getProperties().get("DefaultConnection");
        if (!conn.isJDBCConnection()) {
            this.setColumnsError("The active connection is not of type JDBC. Activate a JDBC connection first.");
            return;
        }
        FieldReader t = new FieldReader(query, conn);
        t.start();
    }

    private void setColumns(List cols) {
        this.columnsErrorMsgLabel.setText("");
        this.jPanel2.remove(this.columnsErrorScrollPane);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel2.revalidate();
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.getDataVector().clear();
        for (int i = 0; i < cols.size(); ++i) {
            Object[] row = (Object[])cols.get(i);
            dtm.addRow(row);
        }
        this.jTableFields.selectAll();
        this.okButton.setEnabled(true);
    }

    private void setColumnsError(String msg) {
        this.columnsErrorMsgLabel.setText(msg);
        this.jPanel2.remove(this.columnsScrollPane);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jPanel2.revalidate();
        this.columnsErrorMsgLabel.repaint();
        this.okButton.setEnabled(false);
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelSQL = new JPanel();
        this.jRSQLExpressionArea1 = new JRSQLExpressionArea();
        this.jPanel7 = new JPanel();
        this.automaticlyReadFieldsCheckBox = new JCheckBox();
        this.readFieldsButton = new JButton();
        this.jPanel5 = new JPanel();
        this.jTextFieldBeanClass = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButtonReadBeanAttributes = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel2 = new JPanel();
        this.columnsScrollPane = new JScrollPane();
        this.jTableFields = new JTable();
        this.jPanel3 = new JPanel();
        this.jPanel4 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel9 = new JPanel();
        this.columnsErrorScrollPane = new JScrollPane();
        this.columnsErrorMsgLabel = new JLabel();
        this.setTitle("Report query");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ReportQueryDialog.this.closeDialog(evt);
            }
        });
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.4);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel1.setMinimumSize(new Dimension(10, 100));
        this.jPanel1.setPreferredSize(new Dimension(10, 350));
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 11));
        this.jTabbedPane1.setMinimumSize(new Dimension(154, 350));
        this.jTabbedPane1.setPreferredSize(new Dimension(154, 350));
        this.jPanelSQL.setLayout(new BorderLayout());
        this.jPanelSQL.setMinimumSize(new Dimension(1, 100));
        this.jPanelSQL.setPreferredSize(new Dimension(1, 350));
        this.jRSQLExpressionArea1.setBorder(new BevelBorder(1));
        this.jRSQLExpressionArea1.setMinimumSize(new Dimension(661, 200));
        this.jRSQLExpressionArea1.setPreferredSize(new Dimension(661, 340));
        this.jPanelSQL.add((Component)this.jRSQLExpressionArea1, "Center");
        this.jPanel7.setLayout(new GridBagLayout());
        this.automaticlyReadFieldsCheckBox.setSelected(true);
        this.automaticlyReadFieldsCheckBox.setText("Automatically Retrieve Fields");
        this.automaticlyReadFieldsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.automaticlyReadFieldsCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 5, 2, 0);
        gridBagConstraints.anchor = 17;
        this.jPanel7.add((Component)this.automaticlyReadFieldsCheckBox, gridBagConstraints);
        this.readFieldsButton.setText("Read Fields");
        this.readFieldsButton.setEnabled(false);
        this.readFieldsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.readFieldsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 10, 2, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel7.add((Component)this.readFieldsButton, gridBagConstraints);
        this.jPanelSQL.add((Component)this.jPanel7, "South");
        this.jTabbedPane1.addTab("Report SQL query ", this.jPanelSQL);
        this.jPanel5.setLayout(null);
        this.jPanel5.add(this.jTextFieldBeanClass);
        this.jTextFieldBeanClass.setBounds(8, 28, 342, 20);
        this.jLabel2.setFont(new Font("Dialog", 0, 11));
        this.jLabel2.setText("Class name");
        this.jLabel2.setVerticalAlignment(3);
        this.jLabel2.setPreferredSize(new Dimension(54, 20));
        this.jPanel5.add(this.jLabel2);
        this.jLabel2.setBounds(8, 6, 240, 20);
        this.jButtonReadBeanAttributes.setFont(new Font("Dialog", 0, 11));
        this.jButtonReadBeanAttributes.setText("Read javabeans attributes");
        this.jButtonReadBeanAttributes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.jButtonReadBeanAttributesActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.jButtonReadBeanAttributes);
        this.jButtonReadBeanAttributes.setBounds(8, 54, 188, 23);
        this.jTabbedPane1.addTab("JavaBean Datasource", this.jPanel5);
        this.jTabbedPane1.addTab("Custom Datasource", this.jPanel6);
        this.jPanel1.add((Component)this.jTabbedPane1, "Center");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setPreferredSize(new Dimension(453, 150));
        this.columnsScrollPane.setPreferredSize(new Dimension(453, 150));
        this.jTableFields.setModel(new DefaultTableModel(new Object[0][], new String[]{"Field name", "Field type"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFields.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                ReportQueryDialog.this.jTableFieldsKeyReleased(evt);
            }
        });
        this.columnsScrollPane.setViewportView(this.jTableFields);
        this.jPanel2.add((Component)this.columnsScrollPane, "Center");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setMinimumSize(new Dimension(10, 34));
        this.jPanel3.setPreferredSize(new Dimension(10, 34));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setPreferredSize(new Dimension(150, 10));
        this.okButton.setText("OK");
        this.okButton.setMaximumSize(new Dimension(65, 23));
        this.okButton.setMinimumSize(new Dimension(65, 23));
        this.okButton.setPreferredSize(new Dimension(65, 23));
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReportQueryDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.cancelButton, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel4, "East");
        this.jPanel9.setLayout(null);
        this.jPanel9.setMinimumSize(new Dimension(100, 20));
        this.jPanel3.add((Component)this.jPanel9, "Center");
        this.jPanel2.add((Component)this.jPanel3, "South");
        this.columnsErrorMsgLabel.setText("jLabel1");
        this.columnsErrorMsgLabel.setVerticalAlignment(1);
        this.columnsErrorMsgLabel.setVerticalTextPosition(1);
        this.columnsErrorScrollPane.setViewportView(this.columnsErrorMsgLabel);
        this.jPanel2.add((Component)this.columnsErrorScrollPane, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel2);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.pack();
    }

    private void automaticlyReadFieldsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.automaticlyReadFieldsCheckBox.isSelected()) {
            this.readFieldsButton.setEnabled(false);
            this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
        } else {
            this.okButton.setEnabled(false);
            this.readFieldsButton.setEnabled(true);
            this.setColumnsError("Enter your query above. Then use the Read Fields button to retrieve the list of fields.");
        }
    }

    private void readFieldsButtonActionPerformed(ActionEvent evt) {
        this.processQueryChanged(this.jRSQLExpressionArea1.getText().trim());
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.getJReportFrame().getReport().setQuery(this.jRSQLExpressionArea1.getText());
        this.getJReportFrame().getReport().getFields().clear();
        int[] selectedRows = this.jTableFields.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            JRField field = (JRField)this.jTableFields.getValueAt(i, 0);
            Enumeration e = this.getJReportFrame().getReport().getFields().elements();
            boolean found = false;
            while (e.hasMoreElements()) {
                JRField f = (JRField)e.nextElement();
                if (!f.getName().equalsIgnoreCase(field.getName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.getJReportFrame().getReport().addField(field);
        }
        this.getJReportFrame().getMainFrame().getValuesDialog().updateFields();
        this.setVisible(false);
    }

    private void jTableFieldsKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 127) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            int[] selectedRows = this.jTableFields.getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                JRField field = (JRField)this.jTableFields.getValueAt(i, 0);
                this.getJReportFrame().getReport().removeField(field);
                this.jTableFields.removeRowSelectionInterval(i, i);
            }
        }
    }

    private void jButtonReadBeanAttributesActionPerformed(ActionEvent evt) {
        String classname = this.jTextFieldBeanClass.getText().trim();
        if (classname.equals("")) {
            JOptionPane.showMessageDialog(this, "No class specified!", "Error", 0);
            return;
        }
        try {
            Method[] methods = Class.forName(classname).getMethods();
            Field[] fields = Class.forName(classname).getFields();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
            dtm.setRowCount(0);
            for (int i = 0; i < methods.length; ++i) {
                if (!Modifier.isPublic(methods[i].getModifiers()) || !methods[i].getDeclaringClass().getName().equals(classname) || Modifier.isNative(methods[i].getModifiers()) || !methods[i].getName().startsWith("get") || methods[i].getReturnType().isPrimitive() || methods[i].getReturnType().isArray()) continue;
                String fieldName = methods[i].getName().substring(3);
                for (int f = 0; f < fields.length; ++f) {
                    if (!fields[f].getName().equalsIgnoreCase(fieldName)) continue;
                    fieldName = fields[f].getName();
                    break;
                }
                String returnType = methods[i].getReturnType().getName();
                JRField field = new JRField(fieldName, returnType);
                field.setDescription("Field returned by " + methods[i].getName() + " method of " + classname);
                Vector<Object> row = new Vector<Object>();
                row.addElement(field);
                row.addElement(field.getClassType());
                dtm.addRow(row);
            }
        }
        catch (ClassNotFoundException cnf) {
            JOptionPane.showMessageDialog(this, "Class not found!\nCheck your classpath and retry.", "Error", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            return;
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ReportQueryDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        DefaultTableModel dtm = (DefaultTableModel)this.jTableFields.getModel();
        dtm.setRowCount(0);
        if (jReportFrame == null) {
            this.jRSQLExpressionArea1.setText("");
        } else {
            this.isSettingSQLExpression = true;
            this.jRSQLExpressionArea1.setText(this.jReportFrame.getReport().getQuery());
            this.isSettingSQLExpression = false;
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            Iterator i = jReportFrame.getReport().getFields().iterator();
            while (i.hasNext()) {
                JRField field = (JRField)i.next();
                columns.add(new Object[]{field, field.getClassType()});
            }
            this.setColumns(columns);
        }
    }

    private Interpreter prepareExpressionEvaluator() throws JRException, EvalError {
        JasperDesign jd = new JasperDesign();
        this.parameterNameToExpressionID = new HashMap();
        Enumeration enumParams = this.getJReportFrame().getReport().getParameters().elements();
        while (enumParams.hasMoreElements()) {
            JRParameter parameter = (JRParameter)enumParams.nextElement();
            if (parameter.getDefaultValueExpression().length() == 0) continue;
            Class c = this.classStringToClass(parameter.getClassType());
            JRDesignParameter p = new JRDesignParameter();
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClass(c);
            exp.setName("parameterDefaultValue_" + parameter.getName());
            exp.setText(parameter.getDefaultValueExpression());
            p.setName(parameter.getName());
            p.setValueClass(c);
            p.setForPrompting(false);
            p.setDefaultValueExpression((JRExpression)exp);
            jd.addParameter((dori.jasper.engine.JRParameter)p);
            this.parameterNameToExpressionID.put(parameter.getName(), new Integer(exp.getId()));
        }
        String bshScript = JRBshGenerator.generateScript((JasperDesign)jd);
        Interpreter interpreter = new Interpreter();
        interpreter.setClassLoader(interpreter.getClass().getClassLoader());
        interpreter.eval((Reader)new StringReader(bshScript));
        interpreter.eval("bshCalculator = createBshCalculator()");
        return interpreter;
    }

    private Class classStringToClass(String classType) {
        Class c = null;
        if (classType.equals("java.lang.String")) {
            c = String.class;
        } else if (classType.equals("java.lang.Integer")) {
            c = Integer.class;
        } else if (classType.equals("java.lang.Boolean")) {
            c = Boolean.class;
        } else if (classType.equals("java.lang.Byte")) {
            c = Byte.class;
        } else if (classType.equals("java.util.Date")) {
            c = Date.class;
        } else if (classType.equals("java.sql.Timestamp")) {
            c = Timestamp.class;
        } else if (classType.equals("java.sql.Time")) {
            c = Time.class;
        } else if (classType.equals("java.lang.Double")) {
            c = Double.class;
        } else if (classType.equals("java.lang.Float")) {
            c = Float.class;
        } else if (classType.equals("java.lang.Long")) {
            c = Long.class;
        } else if (classType.equals("java.lang.Short")) {
            c = Short.class;
        } else if (classType.equals("java.math.BigDecimal")) {
            c = BigDecimal.class;
        }
        return c;
    }

    static /* synthetic */ void access$600(ReportQueryDialog x0, List x1) {
        x0.setColumns(x1);
    }

    static /* synthetic */ void access$700(ReportQueryDialog x0, String x1) {
        x0.setColumnsError(x1);
    }

    class FieldReader
    extends Thread {
        String src_query;
        IReportConnection conn;

        public FieldReader(String query, IReportConnection conn) {
            this.src_query = query;
            this.conn = conn;
        }

        private void setColumnsFromWorker(List columns) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    private final /* synthetic */ List val$columns;
                    private final /* synthetic */ FieldReader this$1;
                    {
                        this.this$1 = fieldReader;
                        this.val$columns = list;
                    }

                    public void run() {
                        String str = ReportQueryDialog.access$300(FieldReader.access$500(this.this$1)).getText().trim();
                        if (str.compareTo(this.this$1.src_query) == 0) {
                            ReportQueryDialog.access$600(FieldReader.access$500(this.this$1), this.val$columns);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void setColumnErrorFromWork(String error_msg) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){
                    private final /* synthetic */ String val$error_msg;
                    private final /* synthetic */ FieldReader this$1;
                    {
                        this.this$1 = fieldReader;
                        this.val$error_msg = string;
                    }

                    public void run() {
                        String str = ReportQueryDialog.access$300(FieldReader.access$500(this.this$1)).getText().trim();
                        if (str.compareTo(this.this$1.src_query) == 0) {
                            ReportQueryDialog.access$700(FieldReader.access$500(this.this$1), this.val$error_msg);
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String error_msg = "";
            Statement ps = null;
            try {
                Interpreter interpreter = ReportQueryDialog.this.prepareExpressionEvaluator();
                String query = this.src_query;
                ArrayList<Object> queryParams = new ArrayList<Object>();
                Enumeration enumParams = ReportQueryDialog.this.getJReportFrame().getReport().getParameters().elements();
                while (enumParams.hasMoreElements()) {
                    JRParameter parameter = (JRParameter)enumParams.nextElement();
                    String p1 = "$P{" + parameter.getName() + "}";
                    String p2 = "$P!{" + parameter.getName() + "}";
                    Integer expID = (Integer)ReportQueryDialog.this.parameterNameToExpressionID.get(parameter.getName());
                    Object defValue = expID != null ? interpreter.eval("bshCalculator.evaluate(" + expID + ")") : null;
                    int ip1 = query.indexOf(p1);
                    while (ip1 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip1);
                        String after = query.substring(ip1 + p1.length());
                        query = before + " ? " + after;
                        queryParams.add(defValue);
                        ip1 = query.indexOf(p1);
                    }
                    int ip2 = query.indexOf(p2);
                    while (ip2 != -1) {
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + parameter.getName() + "'");
                        }
                        String before = query.substring(0, ip2);
                        String after = query.substring(ip2 + p2.length());
                        query = before + " " + defValue.toString() + " " + after;
                        ip2 = query.indexOf(p2);
                    }
                }
                ps = this.conn.getConnection().prepareStatement(query);
                for (int pc = 0; pc < queryParams.size(); ++pc) {
                    ps.setObject(pc + 1, queryParams.get(pc));
                }
                ps.setFetchSize(0);
                ResultSet rs = ps.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                ArrayList<Object[]> columns = new ArrayList<Object[]>();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    JRField field = new JRField(rsmd.getColumnLabel(i), Misc.getJdbcTypeClass(rsmd.getColumnType(i)));
                    columns.add(new Object[]{field, field.getClassType()});
                }
                this.setColumnsFromWorker(columns);
                return;
            }
            catch (IllegalArgumentException ie) {
                error_msg = ie.getMessage();
            }
            catch (NoClassDefFoundError ex) {
                error_msg = "NoClassDefFoundError!!\nCheck your classpath!";
            }
            catch (SQLException ex) {
                error_msg = "SQL problems:\n" + ex.getMessage();
            }
            catch (Exception ex) {
                error_msg = "General problem:\n" + ex.getMessage() + "\n\nCheck username and password; is the DBMS active ?!";
            }
            finally {
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (Exception e) {}
                }
            }
            this.setColumnErrorFromWork(error_msg);
        }

        static /* synthetic */ ReportQueryDialog access$500(FieldReader x0) {
            return x0.ReportQueryDialog.this;
        }
    }
}

