/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.plugin.massivecompiler;

import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.plugin.massivecompiler.CompileThread;
import it.businesslogic.ireport.plugin.massivecompiler.FileDetails;
import it.businesslogic.ireport.plugin.massivecompiler.FileEntry;
import it.businesslogic.ireport.plugin.massivecompiler.FindThread;
import it.businesslogic.ireport.plugin.massivecompiler.ImageCellRenderer;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;

public class MassiveCompilerFrame
extends JFrame {
    private FindThread findThread = null;
    private CompileThread compileThread = null;
    private boolean finding = false;
    private boolean compiling = false;
    private MainFrame iReportMainFrame = null;
    private JButton jButtonBrowse;
    private JButton jButtonCancelCompile;
    private JButton jButtonCancelFind;
    private JButton jButtonClose;
    private JButton jButtonCompile;
    private JButton jButtonCompileAll;
    private JButton jButtonFind;
    private JCheckBox jCheckBoxBackup;
    private JCheckBox jCheckBoxChangeFileExt;
    private JCheckBox jCheckBoxSubDir;
    private JMenuItem jMenuItemDetails;
    private JMenuItem jMenuItemOpen;
    private JMenuItem jMenuItemViewSource;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPopupMenu jPopupMenuFiles;
    private JScrollPane jScrollPane1;
    private JTable jTableFiles;
    private JTextField jTextFieldPath;

    public MassiveCompilerFrame() {
        this.initComponents();
        this.setSize(550, 380);
        Misc.centerFrame(this);
        DefaultTableColumnModel dtcm = (DefaultTableColumnModel)this.jTableFiles.getColumnModel();
        this.jTableFiles.getColumnModel().getColumn(0).setCellRenderer(new ImageCellRenderer());
        this.jTableFiles.setRowHeight(18);
        dtcm.getColumn(0).setWidth(18);
        dtcm.getColumn(1).setWidth(300);
        dtcm.getColumn(2).setWidth(50);
        dtcm.getColumn(0).setPreferredWidth(18);
        dtcm.getColumn(1).setPreferredWidth(300);
        dtcm.getColumn(2).setPreferredWidth(50);
        dtcm.getColumn(0).setMinWidth(18);
        dtcm.getColumn(0).setMaxWidth(18);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableFiles.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                MassiveCompilerFrame.this.jTableFilesListSelectionValueChanged(e);
            }
        });
    }

    private void initComponents() {
        this.jPopupMenuFiles = new JPopupMenu();
        this.jMenuItemDetails = new JMenuItem();
        this.jMenuItemOpen = new JMenuItem();
        this.jMenuItemViewSource = new JMenuItem();
        this.jPanel1 = new JPanel();
        this.jTextFieldPath = new JTextField();
        this.jButtonBrowse = new JButton();
        this.jCheckBoxSubDir = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTableFiles = new JTable();
        this.jPanel2 = new JPanel();
        this.jButtonClose = new JButton();
        this.jPanel4 = new JPanel();
        this.jCheckBoxChangeFileExt = new JCheckBox();
        this.jCheckBoxBackup = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jButtonCompile = new JButton();
        this.jButtonCancelCompile = new JButton();
        this.jButtonCompileAll = new JButton();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jButtonFind = new JButton();
        this.jButtonCancelFind = new JButton();
        this.jMenuItemDetails.setFont(new Font("Dialog", 1, 11));
        this.jMenuItemDetails.setText("Details and error messages");
        this.jMenuItemDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jMenuItemDetailsActionPerformed(evt);
            }
        });
        this.jPopupMenuFiles.add(this.jMenuItemDetails);
        this.jMenuItemOpen.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemOpen.setText("Send to editor");
        this.jMenuItemOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jMenuItemOpenActionPerformed(evt);
            }
        });
        this.jPopupMenuFiles.add(this.jMenuItemOpen);
        this.jMenuItemViewSource.setFont(new Font("Dialog", 0, 11));
        this.jMenuItemViewSource.setText("View source");
        this.jMenuItemViewSource.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jMenuItemViewSourceActionPerformed(evt);
            }
        });
        this.jPopupMenuFiles.add(this.jMenuItemViewSource);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Massive compiler");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                MassiveCompilerFrame.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(new EtchedBorder(), "Directory"));
        this.jPanel1.setMinimumSize(new Dimension(0, 70));
        this.jPanel1.setPreferredSize(new Dimension(0, 70));
        this.jTextFieldPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jTextFieldPathActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.jPanel1.add((Component)this.jTextFieldPath, gridBagConstraints);
        this.jButtonBrowse.setFont(new Font("Dialog", 0, 11));
        this.jButtonBrowse.setText("Browse...");
        this.jButtonBrowse.setMinimumSize(new Dimension(87, 20));
        this.jButtonBrowse.setPreferredSize(new Dimension(87, 20));
        this.jButtonBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 16;
        this.jPanel1.add((Component)this.jButtonBrowse, gridBagConstraints);
        this.jCheckBoxSubDir.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxSubDir.setText("Search Sub Directories");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.jPanel1.add((Component)this.jCheckBoxSubDir, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jTableFiles.setModel(new DefaultTableModel(new Object[0][], new String[]{"", "File", "Status"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableFiles.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MassiveCompilerFrame.this.jTableFilesMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableFiles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(0, 120));
        this.jPanel2.setPreferredSize(new Dimension(0, 120));
        this.jButtonClose.setFont(new Font("Dialog", 0, 11));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel2.add((Component)this.jButtonClose, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setBorder(new TitledBorder(new EtchedBorder(), "Options"));
        this.jPanel4.setMinimumSize(new Dimension(200, 70));
        this.jPanel4.setPreferredSize(new Dimension(200, 70));
        this.jCheckBoxChangeFileExt.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxChangeFileExt.setText("Change file extension to .jrxml");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jCheckBoxChangeFileExt, gridBagConstraints);
        this.jCheckBoxBackup.setFont(new Font("Dialog", 0, 11));
        this.jCheckBoxBackup.setText("Backup old compiled files");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jCheckBoxBackup, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.jPanel2.add((Component)this.jPanel4, gridBagConstraints);
        this.jPanel5.setLayout(new GridBagLayout());
        this.jPanel5.setPreferredSize(new Dimension(100, 10));
        this.jButtonCompile.setFont(new Font("Dialog", 0, 11));
        this.jButtonCompile.setText("Compile selected file(s)");
        this.jButtonCompile.setEnabled(false);
        this.jButtonCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonCompileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel5.add((Component)this.jButtonCompile, gridBagConstraints);
        this.jButtonCancelCompile.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancelCompile.setText("Cancel");
        this.jButtonCancelCompile.setEnabled(false);
        this.jButtonCancelCompile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonCancelCompileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonCancelCompile, gridBagConstraints);
        this.jButtonCompileAll.setFont(new Font("Dialog", 0, 11));
        this.jButtonCompileAll.setText("Compile All");
        this.jButtonCompileAll.setEnabled(false);
        this.jButtonCompileAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonCompileAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel5.add((Component)this.jButtonCompileAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel2.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jPanel3.setMinimumSize(new Dimension(100, 10));
        this.jPanel3.setPreferredSize(new Dimension(100, 10));
        this.jButtonFind.setFont(new Font("Dialog", 0, 11));
        this.jButtonFind.setText("Find");
        this.jButtonFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jButtonFind, gridBagConstraints);
        this.jButtonCancelFind.setFont(new Font("Dialog", 0, 11));
        this.jButtonCancelFind.setText("Cancel");
        this.jButtonCancelFind.setEnabled(false);
        this.jButtonCancelFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MassiveCompilerFrame.this.jButtonCancelFindActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.jPanel3.add((Component)this.jButtonCancelFind, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.pack();
    }

    private void jMenuItemViewSourceActionPerformed(ActionEvent evt) {
        if (this.iReportMainFrame == null) {
            return;
        }
        if (this.jTableFiles.getSelectedRowCount() != 0) {
            Runtime rt = Runtime.getRuntime();
            String editor = "notepad.exe";
            try {
                if (this.iReportMainFrame.getProperties().getProperty("ExternalEditor") != null) {
                    editor = this.iReportMainFrame.getProperties().getProperty("ExternalEditor");
                }
                if (editor == null || editor.equals("")) {
                    this.iReportMainFrame.logOnConsole("Using notepad.exe as default editor!\n", false);
                    editor = "notepad.exe";
                }
                rt.exec(editor + " \"" + ((FileEntry)this.jTableFiles.getValueAt(this.jTableFiles.getSelectedRow(), 0)).getFile().getCanonicalPath() + "\"");
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "An exception is occured executing:\n" + editor + " \"" + ((FileEntry)this.jTableFiles.getValueAt(this.jTableFiles.getSelectedRow(), 0)).getFile() + "\"", "", 0);
            }
        }
    }

    private void jMenuItemOpenActionPerformed(ActionEvent evt) {
        if (this.iReportMainFrame == null) {
            return;
        }
        if (this.jTableFiles.getSelectedRowCount() != 0) {
            this.iReportMainFrame.openFile(((FileEntry)this.jTableFiles.getValueAt(this.jTableFiles.getSelectedRow(), 0)).getFile());
        }
    }

    private void jMenuItemDetailsActionPerformed(ActionEvent evt) {
        if (this.jTableFiles.getSelectedRowCount() != 0) {
            FileDetails fd = new FileDetails((Frame)this, true);
            fd.setFileEntry((FileEntry)this.jTableFiles.getValueAt(this.jTableFiles.getSelectedRow(), 0));
            fd.show();
        }
    }

    private void jTableFilesMouseClicked(MouseEvent evt) {
        if (evt.getButton() == 1 && evt.getClickCount() == 2) {
            if (this.jTableFiles.getSelectedRowCount() != 0) {
                FileDetails fd = new FileDetails((Frame)this, true);
                fd.setFileEntry((FileEntry)this.jTableFiles.getValueAt(this.jTableFiles.getSelectedRow(), 0));
                fd.show();
            }
        } else if (evt.getButton() == 3 && evt.getClickCount() == 1) {
            this.jPopupMenuFiles.show(this.jTableFiles, evt.getPoint().x, evt.getPoint().y);
        }
    }

    private void jButtonCompileAllActionPerformed(ActionEvent evt) {
        this.compileThread = new CompileThread(this);
        this.compileThread.setCompileSelectedOnly(false);
        this.startCompiling();
        this.compileThread.start();
    }

    private void jButtonCancelCompileActionPerformed(ActionEvent evt) {
        this.compileThread.stop();
        this.finishedCompiling();
    }

    private void jButtonCompileActionPerformed(ActionEvent evt) {
        this.compileThread = new CompileThread(this);
        this.compileThread.setCompileSelectedOnly(true);
        this.startCompiling();
        this.compileThread.start();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonCancelFindActionPerformed(ActionEvent evt) {
        this.findThread.stop();
        this.finishedFind();
    }

    private void jButtonFindActionPerformed(ActionEvent evt) {
        if (this.jTextFieldPath.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, "Please select a directory.", "No dir...", 2);
            return;
        }
        this.findThread = new FindThread(this);
        this.startFind();
        this.findThread.start();
    }

    private void jButtonBrowseActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        if (jfc.showOpenDialog(null) == 0) {
            this.jTextFieldPath.setText(jfc.getSelectedFile().getPath());
        }
    }

    private void jTextFieldPathActionPerformed(ActionEvent evt) {
    }

    private void exitForm(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        new MassiveCompilerFrame().show();
    }

    public JTable getFileTable() {
        return this.jTableFiles;
    }

    public String getFindDirectory() {
        return this.jTextFieldPath.getText();
    }

    public boolean isSearchSubDirectory() {
        return this.jCheckBoxSubDir.isSelected();
    }

    public boolean isSelectedChangeFileExt() {
        return this.jCheckBoxChangeFileExt.isSelected();
    }

    public boolean isSelectedBackup() {
        return this.jCheckBoxBackup.isSelected();
    }

    public void finishedFind() {
        this.finding = false;
        this.jButtonCancelFind.setEnabled(false);
        this.jButtonFind.setEnabled(true);
        this.jButtonClose.setEnabled(true);
        this.jCheckBoxSubDir.setEnabled(true);
        this.jTextFieldPath.setEditable(true);
        if (this.jTableFiles.getRowCount() > 0) {
            this.jButtonCompileAll.setEnabled(true);
            this.jTableFilesListSelectionValueChanged(new ListSelectionEvent(this, 0, 0, false));
        } else {
            this.jButtonCompileAll.setEnabled(false);
        }
    }

    public void startFind() {
        this.finding = true;
        this.jButtonCancelFind.setEnabled(true);
        this.jButtonFind.setEnabled(false);
        this.jButtonCompileAll.setEnabled(false);
        this.jButtonCompile.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.jCheckBoxSubDir.setEnabled(false);
        this.jTextFieldPath.setEditable(false);
    }

    public void finishedCompiling() {
        this.compiling = false;
        this.jButtonCancelCompile.setEnabled(false);
        this.jButtonFind.setEnabled(true);
        this.jButtonClose.setEnabled(true);
        this.jCheckBoxBackup.setEnabled(true);
        this.jCheckBoxChangeFileExt.setEnabled(true);
        if (this.jTableFiles.getRowCount() > 0) {
            this.jButtonCompileAll.setEnabled(true);
            this.jTableFilesListSelectionValueChanged(new ListSelectionEvent(this, 0, 0, false));
        } else {
            this.jButtonCompileAll.setEnabled(false);
        }
    }

    public void startCompiling() {
        this.compiling = true;
        this.jButtonCancelCompile.setEnabled(false);
        this.jButtonFind.setEnabled(false);
        this.jButtonCompileAll.setEnabled(false);
        this.jButtonCompile.setEnabled(false);
        this.jButtonClose.setEnabled(false);
        this.jCheckBoxBackup.setEnabled(false);
        this.jCheckBoxChangeFileExt.setEnabled(false);
    }

    public void jTableFilesListSelectionValueChanged(ListSelectionEvent e) {
        if (this.finding) {
            return;
        }
        if (this.jTableFiles.getSelectedRowCount() > 0) {
            this.jButtonCompile.setEnabled(true);
        } else {
            this.jButtonCompile.setEnabled(false);
        }
    }

    public MainFrame getIReportMainFrame() {
        return this.iReportMainFrame;
    }

    public void setIReportMainFrame(MainFrame iReportMainFrame) {
        this.iReportMainFrame = iReportMainFrame;
    }
}

