/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.ImageReportElement;
import it.businesslogic.ireport.chart.IReportChartFactory;
import it.businesslogic.ireport.chart.IReportChartProperties;
import it.businesslogic.ireport.util.Misc;
import java.awt.Color;
import java.awt.Graphics2D;
import java.io.File;
import java.util.StringTokenizer;

public class ChartReportElement
extends ImageReportElement {
    private int chartType = 1;
    private String title = "Sample chart";
    private boolean legend = false;
    private int chartWidth = 640;
    private int chartHeight = 480;
    private File reportDirectory = null;
    private IReportChartProperties chartProperties = null;
    private boolean chartEmbedded = true;
    private String chartFilename = null;

    public ChartReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setGraphicElementPen("Thin");
        this.setBgcolor(Color.WHITE);
        this.setFgcolor(Color.BLACK);
        this.setKey("chart");
        if (this.getImgDef() == null) {
            ChartReportElement.setImgDef(Misc.loadImageFromResources("it/businesslogic/ireport/icons/layout/img.gif"));
        }
        this.setImg(null);
        this.setIsUsingCache(false);
        this.setImageExpression("");
        this.setImageClass("java.awt.Image");
        this.setScaleImage("RetainShape");
        this.setGraphicElementPen("None");
        this.setHyperlinkType("None");
        this.setAnchorNameExpression("");
        this.chartWidth = 640;
        this.chartHeight = 480;
        this.chartProperties = new IReportChartProperties();
        this.chartProperties.setWidth(this.chartWidth);
        this.chartProperties.setHeight(this.chartHeight);
        this.setImg(null);
    }

    public void drawObject(Graphics2D g, double zoom_factor, int x_shift_origin, int y_shift_origin) {
        if (this.getImg() == null) {
            this.setImg(IReportChartFactory.iReportChart(this.title, this.chartWidth, this.chartHeight, this.chartType, this.legend, this.getBgcolor()));
        }
        super.drawObject(g, zoom_factor, x_shift_origin, y_shift_origin);
    }

    public int getChartType() {
        return this.chartProperties.getType(0);
    }

    public void setChartType(int chartType) {
        if (this.chartType != chartType) {
            this.chartType = chartType;
            this.chartProperties.setType(0, chartType);
            this.setImg(null);
        }
    }

    public boolean isLegend() {
        return this.chartProperties.isLegendVisible(0);
    }

    public void setLegend(boolean legend) {
        this.legend = legend;
        this.chartProperties.setLegendVisible(0, legend);
        int tmp = this.chartType;
        this.chartType = -1;
        this.setChartType(tmp);
    }

    public String getTitle() {
        return this.chartProperties.getTitle(0);
    }

    public void setTitle(String title) {
        this.title = title;
        this.chartProperties.setTitle(0, title);
        this.setImg(null);
    }

    public int getChartWidth() {
        return this.chartWidth;
    }

    public void setChartWidth(int chartWidth) {
        this.chartWidth = chartWidth;
        this.chartProperties.setWidth(chartWidth);
        this.setImg(null);
    }

    public int getChartHeight() {
        return this.chartHeight;
    }

    public void setChartHeight(int chartHeight) {
        this.chartHeight = chartHeight;
        this.chartProperties.setHeight(chartHeight);
        this.setImg(null);
    }

    public void parseExpression(String expression) {
        expression = expression.trim();
        if ((expression = Misc.string_replace("", "(java.awt.Image)it.businesslogic.ireport.chart.IReportChartFactory.iReportChart(", expression)).endsWith(")")) {
            expression = expression.substring(0, expression.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(expression, "\n");
    }

    public void setReportDirectory(File file) {
        this.reportDirectory = file;
    }

    public IReportChartProperties getChartProperties() {
        return this.chartProperties;
    }

    public void setChartProperties(IReportChartProperties properties) {
        this.chartProperties = properties;
    }

    public boolean isChartEmbedded() {
        return this.chartEmbedded;
    }

    public void setChartEmbedded(boolean b) {
        this.chartEmbedded = b;
    }

    public String getChartFilename() {
        return this.chartFilename;
    }

    public void setChartFilename(String string) {
        this.chartFilename = string;
    }
}

