/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRField;
import dori.jasper.engine.data.JRMapArrayDataSource;
import it.businesslogic.ireport.chart.IReportChartProperties;
import it.businesslogic.ireport.chart.JRDefaultField;
import java.awt.Image;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class IReportAbstractChartFactory {
    public static final int XY_AXIS_CHART_DATASET_TYPE = 1;
    public static final int X_AXIS_CHART_DATASET_TYPE = 2;
    public static final int Y_AXIS_CHART_DATASET_TYPE = 3;
    private static Hashtable CHART_FACTORY_COLLECTION = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Double;

    protected IReportAbstractChartFactory() {
    }

    protected abstract Image engineGenerateChartImage(IReportChartProperties var1, Hashtable var2) throws Exception;

    protected abstract int engineGetChartTypeCount();

    protected abstract boolean allowMultipleChart();

    public static Image generateChartImage(String xmlFile, boolean isFilename, JRDataSource dataSource) {
        Hashtable<String, JRDataSource> datasources = new Hashtable<String, JRDataSource>();
        datasources.put("datasource", dataSource);
        return IReportAbstractChartFactory.generateChartImage(xmlFile, isFilename, datasources);
    }

    public static Image generateChartImage(IReportChartProperties chartProperties, JRDataSource dataSource) {
        Hashtable<String, JRDataSource> datasources = new Hashtable<String, JRDataSource>();
        datasources.put("datasource", dataSource);
        return IReportAbstractChartFactory.generateChartImage(chartProperties, datasources);
    }

    public static Image generateChartImage(String xmlFile, boolean isFilename, Hashtable dataSources) {
        if (isFilename) {
            return IReportAbstractChartFactory.generateChartImage(IReportChartProperties.getInstanceFromXMLFile(xmlFile), dataSources);
        }
        return IReportAbstractChartFactory.generateChartImage(IReportChartProperties.getInstanceFromXMLPCData(xmlFile), dataSources);
    }

    public static Image generateChartImage(IReportChartProperties chartProperties, Hashtable dataSources) {
        try {
            String className = chartProperties.getFactory();
            IReportAbstractChartFactory chartFactoryInstance = IReportAbstractChartFactory.getChartFactoryInstance(className);
            return chartFactoryInstance.engineGenerateChartImage(chartProperties, dataSources);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static IReportAbstractChartFactory getChartFactoryInstance(String className) {
        IReportAbstractChartFactory chartFactoryInstance;
        if (CHART_FACTORY_COLLECTION.containsKey(className)) {
            chartFactoryInstance = (IReportAbstractChartFactory)CHART_FACTORY_COLLECTION.get(className);
        } else {
            try {
                chartFactoryInstance = (IReportAbstractChartFactory)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getClass().getName() + ": " + e.getMessage());
            }
            CHART_FACTORY_COLLECTION.put(className, chartFactoryInstance);
        }
        return chartFactoryInstance;
    }

    public static int getChartTypeCount(String chartFactory) {
        return IReportAbstractChartFactory.getChartFactoryInstance(chartFactory).engineGetChartTypeCount();
    }

    public static JRDataSource getSampleDataSource(int dataSetType) {
        Object[] array = null;
        JRField[] fields = IReportAbstractChartFactory.getSampleDataSourceFields(dataSetType);
        switch (dataSetType) {
            case 1: {
                array = new HashMap[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
                ((HashMap)array[0]).put(fields[0].getName(), "Apple");
                ((HashMap)array[1]).put(fields[0].getName(), "Cereal");
                ((HashMap)array[2]).put(fields[0].getName(), "Milk");
                ((HashMap)array[3]).put(fields[0].getName(), "Rice");
                ((HashMap)array[4]).put(fields[0].getName(), "Cookies");
                ((HashMap)array[5]).put(fields[0].getName(), "Sugar");
                ((HashMap)array[0]).put(fields[1].getName(), new Double(5.1));
                ((HashMap)array[0]).put(fields[2].getName(), new Double(4.6));
                ((HashMap)array[0]).put(fields[3].getName(), new Double(7.2));
                ((HashMap)array[0]).put(fields[4].getName(), new Double(8.1));
                ((HashMap)array[0]).put(fields[5].getName(), new Double(4.8));
                ((HashMap)array[1]).put(fields[1].getName(), new Double(6.2));
                ((HashMap)array[1]).put(fields[2].getName(), new Double(4.5));
                ((HashMap)array[1]).put(fields[3].getName(), new Double(6.4));
                ((HashMap)array[1]).put(fields[4].getName(), new Double(7.0));
                ((HashMap)array[1]).put(fields[5].getName(), new Double(5.7));
                ((HashMap)array[2]).put(fields[1].getName(), new Double(6.0));
                ((HashMap)array[2]).put(fields[2].getName(), new Double(4.7));
                ((HashMap)array[2]).put(fields[3].getName(), new Double(8.2));
                ((HashMap)array[2]).put(fields[4].getName(), new Double(5.8));
                ((HashMap)array[2]).put(fields[5].getName(), new Double(6.3));
                ((HashMap)array[3]).put(fields[1].getName(), new Double(6.7));
                ((HashMap)array[3]).put(fields[2].getName(), new Double(4.8));
                ((HashMap)array[3]).put(fields[3].getName(), new Double(4.6));
                ((HashMap)array[3]).put(fields[4].getName(), new Double(8.2));
                ((HashMap)array[3]).put(fields[5].getName(), new Double(7.8));
                ((HashMap)array[4]).put(fields[1].getName(), new Double(5.2));
                ((HashMap)array[4]).put(fields[2].getName(), new Double(4.8));
                ((HashMap)array[4]).put(fields[3].getName(), new Double(6.2));
                ((HashMap)array[4]).put(fields[4].getName(), new Double(9.5));
                ((HashMap)array[4]).put(fields[5].getName(), new Double(8.1));
                ((HashMap)array[5]).put(fields[1].getName(), new Double(2.5));
                ((HashMap)array[5]).put(fields[2].getName(), new Double(9.3));
                ((HashMap)array[5]).put(fields[3].getName(), new Double(10.0));
                ((HashMap)array[5]).put(fields[4].getName(), new Double(4.9));
                ((HashMap)array[5]).put(fields[5].getName(), new Double(1.8));
                break;
            }
            case 2: {
                array = new HashMap[]{new HashMap()};
                ((HashMap)array[0]).put(fields[0].getName(), new Double(45.1));
                ((HashMap)array[0]).put(fields[1].getName(), new Double(25.1));
                ((HashMap)array[0]).put(fields[2].getName(), new Double(10.6));
                ((HashMap)array[0]).put(fields[3].getName(), new Double(7.2));
                ((HashMap)array[0]).put(fields[4].getName(), new Double(4.1));
                ((HashMap)array[0]).put(fields[5].getName(), new Double(1.8));
                break;
            }
            case 3: {
                array = new HashMap[]{new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
                ((HashMap)array[0]).put(fields[0].getName(), new Double(0.25));
                ((HashMap)array[1]).put(fields[0].getName(), new Double(0.12));
                ((HashMap)array[2]).put(fields[0].getName(), new Double(0.22));
                ((HashMap)array[3]).put(fields[0].getName(), new Double(0.08));
                ((HashMap)array[4]).put(fields[0].getName(), new Double(0.16));
                ((HashMap)array[5]).put(fields[0].getName(), new Double(0.17));
            }
        }
        return new JRMapArrayDataSource(array);
    }

    public static JRField[] getSampleDataSourceFields(int dataSetType) {
        JRField[] fields = null;
        switch (dataSetType) {
            case 1: {
                fields = new JRField[]{new JRDefaultField("Product", class$java$lang$String == null ? (class$java$lang$String = IReportAbstractChartFactory.class$("java.lang.String")) : class$java$lang$String), new JRDefaultField("Jan", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Feb", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Mar", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("May", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Jul", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double)};
                break;
            }
            case 2: {
                fields = new JRField[]{new JRDefaultField("AT 486", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Pentium", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Pentium II", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Pentium III", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Pentium IV", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double), new JRDefaultField("Pentium V", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double)};
                break;
            }
            case 3: {
                fields = new JRField[]{new JRDefaultField("Percent", class$java$lang$Double == null ? (class$java$lang$Double = IReportAbstractChartFactory.class$("java.lang.Double")) : class$java$lang$Double)};
            }
        }
        return fields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

