/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.chart;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DatasetUtilities;
import org.jfree.data.PieDataset;

public class IReportChartFactory {
    public static final int VERTICAL_BAR_CHART = 0;
    public static final int VERTICAL_BAR_CHART_3D = 1;
    public static final int PIE_CHART = 2;
    public static final int PIE_CHART_3D = 3;

    public static BufferedImage iReportChart(String title, int chartWidth, int chartHeight, int chartType, boolean legend, Color bgcolor) {
        CategoryDataset dataset = null;
        PieDataset pieDataset = null;
        JFreeChart chart = null;
        double[][] data = new double[][]{{10.0, 4.0, 15.0, 14.0}, {-5.0, -7.0, 14.0, -3.0}, {6.0, 17.0, -12.0, 7.0}, {7.0, 15.0, 11.0, 0.0}, {-8.0, -6.0, 10.0, -9.0}, {9.0, 8.0, 0.0, 6.0}, {-10.0, 9.0, 7.0, 7.0}, {11.0, 13.0, 9.0, 9.0}, {-3.0, 7.0, 11.0, -10.0}};
        dataset = DatasetUtilities.createCategoryDataset((String)"Series ", (String)"Category ", (double[][])data);
        pieDataset = DatasetUtilities.createPieDatasetForColumn((CategoryDataset)dataset, (int)0);
        if (chartType == 0) {
            chart = ChartFactory.createBarChart((String)title, (String)"Category", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)false, (boolean)false);
        } else if (chartType == 1) {
            chart = ChartFactory.createBarChart3D((String)title, (String)"Category", (String)"Value", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)legend, (boolean)false, (boolean)false);
        } else if (chartType == 2) {
            chart = ChartFactory.createPieChart((String)title, (PieDataset)pieDataset, (boolean)legend, (boolean)false, (boolean)false);
        } else if (chartType == 3) {
            chart = ChartFactory.createPieChart3D((String)title, (PieDataset)pieDataset, (boolean)legend, (boolean)false, (boolean)false);
        }
        chart.setBackgroundPaint((Paint)bgcolor);
        return chart.createBufferedImage(chartWidth, chartHeight);
    }
}

