/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.connection;

import dori.jasper.engine.JRDataSource;
import dori.jasper.engine.JRException;
import dori.jasper.engine.JRField;
import java.lang.reflect.Method;
import java.util.Vector;

public class JRExtendedBeanDataSource
implements JRDataSource {
    private Object[] beans = null;
    private int index = -1;

    public JRExtendedBeanDataSource(Vector beans) {
        this.beans = beans.toArray();
    }

    public JRExtendedBeanDataSource(Object[] beans) {
        this.beans = beans;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String path = jRField.getDescription();
        Object val = this.getPathValue(this.beans[this.index], path);
        if (val == null) {
            return null;
        }
        if (val.getClass().isAssignableFrom(jRField.getValueClass())) {
            return val;
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.beans.length;
    }

    private Object getPathValue(Object bean, String path) {
        if (path == null || bean == null || path.trim().length() == 0) {
            return bean;
        }
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        if (path.trim().length() == 0) {
            return bean;
        }
        path = path.trim();
        String attr_name = JRExtendedBeanDataSource.getNextNodeName(path);
        Method m = null;
        try {
            m = bean.getClass().getMethod("get" + attr_name, new Class[0]);
        }
        catch (Exception ex) {
            return null;
        }
        if (m.getReturnType().isArray()) {
            if (path.equals(attr_name)) {
                try {
                    return new JRExtendedBeanDataSource((Object[])m.invoke(bean, new Object[0]));
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
        if (path.equals(attr_name)) {
            try {
                return m.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }
        Object child_bean = null;
        try {
            child_bean = m.invoke(bean, new Object[0]);
        }
        catch (Exception ex) {
            return null;
        }
        path = path.substring(attr_name.length());
        return this.getPathValue(child_bean, path);
    }

    private static String getNextNodeName(String path) {
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.startsWith(".")) {
            path = path.substring(1);
        }
        String childToTake = path;
        if (path.indexOf(".") >= 0) {
            childToTake = path.substring(0, path.indexOf("."));
        }
        return childToTake;
    }
}

