/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Misc {
    static /* synthetic */ Class class$java$awt$Frame;

    public static Image loadImageFromResources(String filename) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            InputStream in = cl.getResourceAsStream(filename);
            byte[] data = Misc.getBytesFromInputStream(in, in.available());
            return Toolkit.getDefaultToolkit().createImage(data);
        }
        catch (Exception ex) {
            System.out.println("Exception loading resource: " + filename);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytesFromInputStream(InputStream in, int length) throws IOException {
        DataInputStream din = new DataInputStream(in);
        byte[] bytecodes = new byte[length];
        try {
            din.readFully(bytecodes);
        }
        finally {
            if (din != null) {
                din.close();
            }
        }
        return bytecodes;
    }

    public static BufferedImage loadBufferedImageFromResources(Component c, String filename) {
        try {
            Misc m = new Misc();
            Image img = Misc.loadImageFromResources(filename);
            MediaTracker mt = new MediaTracker(c);
            mt.addImage(img, 0);
            mt.waitForID(0);
            int width = img.getWidth(null);
            int height = img.getHeight(null);
            BufferedImage bi = new BufferedImage(width, height, 1);
            Graphics gg = bi.getGraphics();
            gg.drawImage(img, 0, 0, null);
            gg.dispose();
            return bi;
        }
        catch (Exception ex) {
            System.out.println(ex.toString());
            return null;
        }
    }

    public static void updateComboBox(JComboBox comboBox, Vector newItems) {
        Misc.updateComboBox(comboBox, newItems, false);
    }

    public static void updateComboBox(JComboBox comboBox, Vector newItems, boolean addNullEntry) {
        Object itemSelected = null;
        if (comboBox.getSelectedIndex() >= 0) {
            itemSelected = comboBox.getSelectedItem();
        }
        comboBox.removeAllItems();
        boolean selected = false;
        boolean foundNullItem = false;
        Enumeration e = newItems.elements();
        while (e.hasMoreElements()) {
            Object item = e.nextElement();
            comboBox.addItem(item);
            if (item == itemSelected) {
                selected = true;
                comboBox.setSelectedItem(itemSelected);
            }
            if (!item.equals("")) continue;
            foundNullItem = true;
        }
        if (addNullEntry) {
            if (!foundNullItem) {
                comboBox.insertItemAt("", 0);
            }
            if (!selected) {
                comboBox.setSelectedItem("");
            }
        }
    }

    public static void updateStringComboBox(JComboBox comboBox, Vector newItems, boolean addNullEntry) {
        String itemSelected = null;
        if (comboBox.getSelectedIndex() >= 0) {
            itemSelected = comboBox.getSelectedItem() + "";
        }
        comboBox.removeAllItems();
        boolean selected = false;
        boolean foundNullItem = false;
        Enumeration e = newItems.elements();
        while (e.hasMoreElements()) {
            String item = "" + e.nextElement();
            comboBox.addItem(item);
            if (item.equals(itemSelected)) {
                selected = true;
                comboBox.setSelectedItem(itemSelected);
            }
            if (!item.equals("")) continue;
            foundNullItem = true;
        }
        if (addNullEntry) {
            if (!foundNullItem) {
                comboBox.insertItemAt("", 0);
            }
            if (!selected) {
                comboBox.setSelectedItem("");
            }
        }
    }

    public static String nvl(Object obj, String def) {
        return obj == null ? def : obj.toString();
    }

    public static void centerFrame(Component c) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        c.setLocation((int)((tk.getScreenSize().getWidth() - (double)c.getWidth()) / 2.0), (int)((tk.getScreenSize().getHeight() - (double)c.getHeight()) / 2.0));
    }

    public static String string_replace(String s1, String s2, String s3) {
        String string = "";
        string = "";
        if (s2 == null || s3 == null || s2.length() == 0) {
            return s3;
        }
        int pos_i = 0;
        int pos_f = 0;
        int len = s2.length();
        while ((pos_f = s3.indexOf(s2, pos_i)) >= 0) {
            string = string + s3.substring(pos_i, pos_f) + s1;
            pos_f = pos_i = pos_f + len;
        }
        string = string + s3.substring(pos_i);
        return string;
    }

    public static Image loadImageFromFile(String path) {
        File file = new File(path);
        if (file.exists()) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Image img = tk.createImage(path);
            try {
                MediaTracker mt = new MediaTracker(new JPanel());
                mt.addImage(img, 0);
                mt.waitForID(0);
            }
            catch (Exception ex) {
                return null;
            }
            return img;
        }
        return null;
    }

    public static String treatNewLineChars(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = source.length() - 1;
            int pos = source.lastIndexOf("\n\n", offset);
            while (pos >= 0 && offset > 0) {
                sbuffer = sbuffer.insert(pos + 1, " ");
                offset = pos - 1;
                pos = source.lastIndexOf("\n\n", offset);
            }
            if (sbuffer.charAt(sbuffer.length() - 1) == '\n') {
                sbuffer.append(' ');
            }
            if (sbuffer.charAt(0) == '\n') {
                sbuffer.insert(0, ' ');
            }
            result = sbuffer.toString();
        }
        result = Misc.replaceTabWithBlank(result);
        return result;
    }

    public static String replaceTabWithBlank(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = 0;
            int pos = source.indexOf("\t", offset);
            while (pos >= 0) {
                sbuffer.setCharAt(pos, ' ');
                offset = pos + 1;
                pos = source.indexOf("\t", offset);
            }
            result = sbuffer.toString();
        }
        return result;
    }

    public static String toHTML(String s) {
        s = Misc.string_replace("&gt;", ">", s);
        s = Misc.string_replace("&lt;", "<", s);
        s = Misc.string_replace("&nbsp;", " ", s);
        s = Misc.string_replace("&nbsp;&nbsp;&nbsp;&nbsp;", "\t", s);
        s = Misc.string_replace("<br>", "\n", s);
        return s;
    }

    public static String getShortFileName(String filename) {
        File f;
        if (filename.length() > 50 && Misc.nvl((f = new File(filename)).getParentFile(), "").length() > 10) {
            String dir = f.getParentFile().getPath() + File.separatorChar;
            String shortDir = dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            if ((dir = dir.substring(dir.indexOf(File.separatorChar) + 1)).indexOf(File.separatorChar) > 0) {
                shortDir = shortDir + dir.substring(0, dir.indexOf(File.separatorChar) + 1);
            }
            return shortDir + "..." + File.separatorChar + f.getName();
        }
        return filename;
    }

    public static String getJdbcTypeClass(int t) {
        String cls = "java.lang.String";
        switch (t) {
            case -7: 
            case -6: {
                cls = "java.lang.Byte";
                break;
            }
            case 5: {
                cls = "java.lang.Short";
                break;
            }
            case 4: {
                cls = "java.lang.Integer";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                cls = "java.lang.Double";
                break;
            }
            case 1: 
            case 12: {
                cls = "java.lang.String";
                break;
            }
            case -5: {
                cls = "java.lang.Long";
                break;
            }
            case 91: 
            case 92: {
                cls = "java.util.Date";
                break;
            }
            case 93: {
                cls = "java.sql.Timestamp";
            }
        }
        return cls;
    }

    public static long getLastWriteTime(String filename) {
        try {
            File f = new File(filename);
            return f.lastModified();
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static Frame frameFromComponent(Component parent) {
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = Misc.class$("java.awt.Frame")) : class$java$awt$Frame, parent);
        return f;
    }

    public static List getAvailablePLAF() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("System");
        l.add("TinyLAF");
        l.add("JGoodiesLAF-PlasticXP");
        l.add("JGoodiesLAF-Plastic");
        l.add("JGoodiesLAF-Plastic3D");
        l.add("JGoodiesLAF-ExtWindows");
        UIManager.LookAndFeelInfo[] lfinfo = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lfinfo.length; ++i) {
            l.add(lfinfo[i].getName());
        }
        return l;
    }

    public static void setPLAF(String s) {
        try {
            if (s.equals("TinyLAF")) {
                UIManager.setLookAndFeel("de.muntjak.tinylookandfeel.TinyLookAndFeel");
            } else if (s.equals("JGoodiesLAF-PlasticXP")) {
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
            } else if (s.equals("JGoodiesLAF-Plastic")) {
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.PlasticLookAndFeel");
            } else if (s.equals("JGoodiesLAF-Plastic3D")) {
                UIManager.setLookAndFeel("com.jgoodies.plaf.plastic.Plastic3DLookAndFeel");
            } else if (s.equals("JGoodiesLAF-ExtWindows")) {
                UIManager.setLookAndFeel("com.jgoodies.plaf.windows.ExtWindowsLookAndFeel");
            } else if (s.equals("System")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.LookAndFeelInfo[] lfinfo = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < lfinfo.length; ++i) {
                    if (!lfinfo[i].getName().equalsIgnoreCase(s)) continue;
                    UIManager.setLookAndFeel(lfinfo[i].getClassName());
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public static Set getResoucesInPackage(String packageName) throws IOException {
        String localPackageName = packageName.endsWith("/") ? packageName : packageName + '/';
        Enumeration<URL> dirEnum = ClassLoader.getSystemResources(localPackageName);
        HashSet<String> names = new HashSet<String>();
        while (dirEnum.hasMoreElements()) {
            URL resUrl = dirEnum.nextElement();
            if (resUrl.getProtocol().equals("file")) {
                File dir = new File(resUrl.getFile());
                File[] files = dir.listFiles();
                if (files == null) continue;
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isDirectory()) continue;
                    names.add(localPackageName + file.getName());
                }
                continue;
            }
            if (!resUrl.getProtocol().equals("jar")) continue;
            JarURLConnection jconn = (JarURLConnection)resUrl.openConnection();
            JarFile jfile = jconn.getJarFile();
            Enumeration<JarEntry> entryEnum = jfile.entries();
            while (entryEnum.hasMoreElements()) {
                String parentDirName;
                JarEntry entry = entryEnum.nextElement();
                String entryName = entry.getName();
                if (entryName.equals(localPackageName) || !(parentDirName = entryName.substring(0, entryName.lastIndexOf(47) + 1)).equals(localPackageName)) continue;
                names.add(entryName);
            }
        }
        return names;
    }

    public static String changeFileExtension(String filename, String newExtension) {
        if (!newExtension.startsWith(".")) {
            newExtension = "." + newExtension;
        }
        if (filename == null || filename.length() == 0) {
            return newExtension;
        }
        int index = filename.lastIndexOf(".");
        if (index >= 0) {
            filename = filename.substring(0, index);
        }
        filename = filename + newExtension;
        return filename;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

