/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SingleByteCharsetConverter;
import com.mysql.jdbc.StringUtils;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

class Buffer {
    static final int NO_LENGTH_LIMIT = -1;
    static final long NULL_LENGTH = -1L;
    private byte[] byteBuffer;
    private boolean wasMultiPacket = false;
    private int bufLength = 0;
    private int position = 0;
    private int sendLength = 0;

    Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    Buffer(int size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
    }

    public void setByteBuffer(byte[] byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setWasMultiPacket(boolean flag) {
        this.wasMultiPacket = flag;
    }

    public int fastSkipLenString() {
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        return (int)len;
    }

    public boolean wasMultiPacket() {
        return this.wasMultiPacket;
    }

    protected final byte[] getBufferSource() {
        return this.byteBuffer;
    }

    final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, len);
        this.position += len;
        return b;
    }

    final boolean isLastDataPacket() {
        return this.getBufLength() < 9 && (this.byteBuffer[0] & 0xFF) == 254;
    }

    final void clear() {
        this.position = 4;
    }

    final void dump() {
        int p = 0;
        int rows = this.getBufLength() / 8;
        int i = 0;
        while (i < rows) {
            int ptemp = p;
            int j = 0;
            while (j < 8) {
                String hexVal = Integer.toHexString(this.byteBuffer[ptemp] & 0xFF);
                if (hexVal.length() == 1) {
                    hexVal = "0" + hexVal;
                }
                System.out.print(hexVal + " ");
                ++ptemp;
                ++j;
            }
            System.out.print("    ");
            int j2 = 0;
            while (j2 < 8) {
                if (this.byteBuffer[p] > 32 && this.byteBuffer[p] < 127) {
                    System.out.print((char)this.byteBuffer[p] + " ");
                } else {
                    System.out.print(". ");
                }
                ++p;
                ++j2;
            }
            System.out.println();
            ++i;
        }
        int n = 0;
        int i2 = p;
        while (i2 < this.getBufLength()) {
            String hexVal = Integer.toHexString(this.byteBuffer[i2] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            ++n;
            ++i2;
        }
        int i3 = n;
        while (i3 < 8) {
            System.out.print("   ");
            ++i3;
        }
        System.out.print("    ");
        int i4 = p;
        while (i4 < this.getBufLength()) {
            if (this.byteBuffer[i4] > 32 && this.byteBuffer[i4] < 127) {
                System.out.print((char)this.byteBuffer[i4] + " ");
            } else {
                System.out.print(". ");
            }
            ++i4;
        }
        System.out.println();
    }

    final void dumpHeader() {
        int i = 0;
        while (i < 4) {
            String hexVal = Integer.toHexString(this.byteBuffer[i] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            ++i;
        }
    }

    final void dumpNBytes(int start, int nBytes) {
        StringBuffer asciiBuf = new StringBuffer();
        int i = start;
        while (i < start + nBytes && i < this.byteBuffer.length) {
            String hexVal = Integer.toHexString(this.byteBuffer[i] & 0xFF);
            if (hexVal.length() == 1) {
                hexVal = "0" + hexVal;
            }
            System.out.print(hexVal + " ");
            if (this.byteBuffer[i] > 32 && this.byteBuffer[i] < 127) {
                asciiBuf.append((char)this.byteBuffer[i]);
            } else {
                asciiBuf.append(".");
            }
            asciiBuf.append(" ");
            ++i;
        }
        System.out.println("    " + asciiBuf.toString());
    }

    final void ensureCapacity(int additionalData) throws SQLException {
        if (this.position + additionalData > this.getBufLength()) {
            if (this.position + additionalData < this.byteBuffer.length) {
                this.setBufLength(this.byteBuffer.length);
            } else {
                int newLength = (int)((double)this.byteBuffer.length * 1.25);
                if (newLength < this.byteBuffer.length + additionalData) {
                    newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
                }
                if (newLength < this.byteBuffer.length) {
                    newLength = this.byteBuffer.length + additionalData;
                }
                byte[] newBytes = new byte[newLength];
                System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
                this.byteBuffer = newBytes;
                this.setBufLength(this.byteBuffer.length);
            }
        }
    }

    final long newReadLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    final byte readByte() {
        return this.byteBuffer[this.position++];
    }

    final long readFieldLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final int readInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
    }

    final byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == -1L) {
            return null;
        }
        if (len == 0L) {
            return new byte[0];
        }
        this.position += offset;
        return this.getBytes((int)len);
    }

    final long readLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLong();
            }
        }
        return sw;
    }

    final long readLong() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16 | (b[this.position++] & 0xFF) << 24;
    }

    final int readLongInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
    }

    final long readLongLong() {
        byte[] b = this.byteBuffer;
        return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
    }

    final String readString() {
        int i = this.position;
        int len = 0;
        while (this.byteBuffer[i] != 0 && i < this.getBufLength()) {
            ++len;
            ++i;
        }
        String s = new String(this.byteBuffer, this.position, len);
        this.position += len + 1;
        return s;
    }

    final String readString(String encoding) throws SQLException {
        int i = this.position;
        int len = 0;
        while (this.byteBuffer[i] != 0 && i < this.getBufLength()) {
            ++len;
            ++i;
        }
        this.position += len + 1;
        try {
            return new String(this.byteBuffer, this.position, len, encoding);
        }
        catch (UnsupportedEncodingException uEE) {
            throw new SQLException("Unsupported character encoding '" + encoding + "'", "S1009");
        }
    }

    final int readnBytes() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.byteBuffer[this.position++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final void writeByte(byte b) throws SQLException {
        this.ensureCapacity(1);
        this.byteBuffer[this.position++] = b;
    }

    final void writeBytesNoNull(byte[] bytes) throws SQLException {
        int len = bytes.length;
        this.ensureCapacity(len);
        System.arraycopy(bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeBytesNoNull(byte[] bytes, int offset, int length) throws SQLException {
        this.ensureCapacity(length);
        System.arraycopy(bytes, offset, this.byteBuffer, this.position, length);
        this.position += length;
    }

    final void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeLongLong(l);
    }

    final void writeFloat(float f) {
        int i = Float.floatToIntBits(f);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    final void writeInt(int i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
    }

    final void writeLong(long i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    final void writeLongInt(int i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
    }

    final void writeLongLong(long i) {
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        b[this.position++] = (byte)(i >>> 32);
        b[this.position++] = (byte)(i >>> 40);
        b[this.position++] = (byte)(i >>> 48);
        b[this.position++] = (byte)(i >>> 56);
    }

    final void writeString(String s) throws SQLException {
        this.writeStringNoNull(s);
        this.byteBuffer[this.position++] = 0;
    }

    final void writeStringNoNull(String s) throws SQLException {
        int len = s.length();
        this.ensureCapacity(len);
        System.arraycopy(s.getBytes(), 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    final void writeStringNoNull(String s, String encoding) throws UnsupportedEncodingException, SQLException {
        byte[] b = null;
        SingleByteCharsetConverter converter = SingleByteCharsetConverter.getInstance(encoding);
        b = converter != null ? converter.toBytes(s) : StringUtils.getBytes(s, encoding);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    void setBufLength(int bufLength) {
        this.bufLength = bufLength;
    }

    int getBufLength() {
        return this.bufLength;
    }

    void setSendLength(int sendLength) {
        this.sendLength = sendLength;
    }

    static {
        NO_LENGTH_LIMIT = -1;
        NULL_LENGTH = -1L;
    }
}

