/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyDesktopManager;
import de.muntjak.tinylookandfeel.TinyInternalFrameTitlePane;
import de.muntjak.tinylookandfeel.borders.TinyInternalFrameBorder;
import java.awt.Container;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalInternalFrameUI;

public class TinyInternalFrameUI
extends MetalInternalFrameUI {
    private TinyInternalFrameBorder frameBorder;
    private TinyInternalFrameTitlePane titlePane;
    private static DesktopManager sharedDesktopManager;

    public TinyInternalFrameUI(JInternalFrame frame) {
        super(frame);
    }

    public static ComponentUI createUI(JComponent c) {
        return new TinyInternalFrameUI((JInternalFrame)c);
    }

    JDesktopPane getDesktopPane(JComponent frame) {
        JDesktopPane pane = null;
        Container c = frame.getParent();
        while (pane == null) {
            if (c instanceof JDesktopPane) {
                pane = (JDesktopPane)c;
                continue;
            }
            if (c == null) break;
            c = c.getParent();
        }
        return pane;
    }

    protected DesktopManager getDesktopManager() {
        if (!Theme.frameIsTransparent[Theme.style]) {
            return super.getDesktopManager();
        }
        if (sharedDesktopManager == null) {
            sharedDesktopManager = this.createDesktopManager();
        }
        return sharedDesktopManager;
    }

    protected DesktopManager createDesktopManager() {
        if (!Theme.frameIsTransparent[Theme.style]) {
            return super.createDesktopManager();
        }
        return new TinyDesktopManager();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.frameBorder = new TinyInternalFrameBorder(this.frame);
        this.frame.setBorder(this.frameBorder);
        this.frame.setOpaque(false);
    }

    protected JComponent createNorthPane(JInternalFrame frame) {
        super.createNorthPane(frame);
        this.titlePane = new TinyInternalFrameTitlePane(frame);
        return this.titlePane;
    }

    protected void activateFrame(JInternalFrame f) {
        super.activateFrame(f);
        this.frameBorder.setActive(true);
        this.titlePane.activate();
    }

    protected void deactivateFrame(JInternalFrame f) {
        super.deactivateFrame(f);
        this.frameBorder.setActive(false);
        this.titlePane.deactivate();
    }

    public void setPalette(boolean isPalette) {
        super.setPalette(isPalette);
        this.titlePane.setPalette(isPalette);
        this.frame.setBorder(this.frameBorder);
        this.frame.putClientProperty("isPalette", isPalette ? Boolean.TRUE : Boolean.FALSE);
    }
}

