/*
 * LibraryPanel.java
 *
 * Created on 14 settembre 2004, 23.49
 */

package it.businesslogic.ireport.gui.library;
import it.businesslogic.ireport.gui.library.objects.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.util.*;

/**
 *
 * @author  Administrator
 */
public class LibraryPanel extends javax.swing.JPanel implements it.businesslogic.ireport.util.LanguageChangedListener {
    
    DefaultMutableTreeNode fieldsNode = null;
    DefaultMutableTreeNode variablesNode = null;
    DefaultMutableTreeNode parametersNode = null; 
    DefaultMutableTreeNode systemObjectsNode = null; 

    
    /** Creates new form LibraryPanel */
    public LibraryPanel() {
        
        initComponents();
        
        jLibraryTree.setCellRenderer( new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        
        jLibraryTree.setModel( dtm );
        jLibraryTree.setDragEnabled(true);
        jLibraryTree.setRootVisible( false );
        jLibraryTree.setTransferHandler(new TreeTransfertHandler());
        
        jLibraryTree.expandPath( new TreePath(root));

        fieldsNode = new DefaultMutableTreeNode("Fields",true);
        root.add( fieldsNode );
        
        variablesNode = new DefaultMutableTreeNode("Variables",true);
        root.add( variablesNode );
        
        parametersNode = new DefaultMutableTreeNode("Parameters",true);
        root.add( parametersNode );
/*        
        systemObjectsNode = new DefaultMutableTreeNode("Custom",true);
        root.add( systemObjectsNode );
*/      
        it.businesslogic.ireport.util.I18n.addOnLanguageChangedListener( this );
        
        loadSystemObjects();
        loadCustomObjects();
        
        updateLibraryObjects();
        this.languageChanged(null);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jScrollPane1 = new javax.swing.JScrollPane();
        jLibraryTree = new javax.swing.JTree();

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.setViewportView(jLibraryTree);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    public void languageChanged(it.businesslogic.ireport.util.LanguageChangedEvent evt) {
        
        fieldsNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.fields","Fields"));
        variablesNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.variables","Variables"));
        parametersNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.parameters","Parameters"));
        jLibraryTree.updateUI();
    }
    
    public void setJReportFrame(JReportFrame jrf)
    {
       this.fieldsNode.removeAllChildren();
       this.parametersNode.removeAllChildren();
       this.variablesNode.removeAllChildren();
       
       
       if (jrf == null) {
           
           jLibraryTree.updateUI();
           return;
       }
       
       java.util.Enumeration e = jrf.getReport().getFields().elements();
       while (e.hasMoreElements())
       {
             fieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
        e = jrf.getReport().getParameters().elements();
       while (e.hasMoreElements())
       {
             parametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
       
        e = jrf.getReport().getVariables().elements();
       while (e.hasMoreElements())
       {
             variablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
        
       jLibraryTree.updateUI();
    }
    
    private void loadCustomObjects()
    {
                
    }
    private void loadSystemObjects()
    {
          DefaultMutableTreeNode root = (DefaultMutableTreeNode)jLibraryTree.getModel().getRoot();
          root.add(new DefaultMutableTreeNode(new PageNumberObject() ));
          root.add(new DefaultMutableTreeNode(new TotalPagesObject() ));
          root.add(new DefaultMutableTreeNode(new PageXYObject() ));
          root.add(new DefaultMutableTreeNode(new TotalObject() ));
    }
    
    private void addLibraryObject(String folder, AbstractLibraryObject obj)
    {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)jLibraryTree.getModel().getRoot();
        if (folder == null || folder.length() == 0)
        {
            root.add(new DefaultMutableTreeNode(new PageNumberObject() ));       
        }
        else
        {
            // Look for folder...
            Enumeration enum_childrens = root.children();
            while (enum_childrens.hasMoreElements())
            {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enum_childrens.nextElement();
                if ( (""+dmtn.getUserObject()).equalsIgnoreCase(folder ) )
                {
                    dmtn.add(new DefaultMutableTreeNode( obj ));
                }
            }
        }
    }
    
    public void updateLibraryObjects()
    {
        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTree jLibraryTree;
    private javax.swing.JScrollPane jScrollPane1;
    // End of variables declaration//GEN-END:variables
    
}
