/*
 * SheetProperty.java
 *
 * Created on 4 ottobre 2004, 22.08
 */

package it.businesslogic.ireport.gui.sheet;
import java.util.*;
import javax.swing.*;
/**
 *
 * @author  Administrator
 */
public class SheetProperty  {
    
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int INTEGER = 6;
    public static final int COMBOBOX = 2;
    public static final int COLOR = 3;
    public static final int BOOLEAN = 4;
    public static final int COMBOBOX_NK = 5; // Combobox number key
        
    private String name = "";
    private String keyName = "";
    private int type;
    private java.util.Vector tags = null;
    private String defaultValue = null;
    
    public SheetProperty(String keyName, String name, int type) {
       this(keyName,name,type,null);
    }
    /** Creates a new instance of SheetProperty */
    public SheetProperty(String keyName, String name, int type, String defaultValue) {
        this.setName( name );
        this.setKeyName( keyName );
        this.setDefaultValue( defaultValue );
        setType(type);
        tags =  new Vector();
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public java.util.Vector getTags() {
        return tags;
    }

    public void setTags(java.util.Vector tags) {
        this.tags = tags;
    }
    
    public JComponent getEditor()
    {
        JComponent component = null;
        
        if (this.getType() == NUMBER)
        {
            component = new it.businesslogic.ireport.gui.JNumberField();
            component.setBorder(null);
            
            ((it.businesslogic.ireport.gui.JNumberField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            return  component;
        }
        else if (this.getType() == INTEGER)
        {
            component = new it.businesslogic.ireport.gui.JNumberField();
            component.setBorder(null);
            try {
            ((it.businesslogic.ireport.gui.JNumberField)component).setInteger(true);
            } catch (Exception ex){}
            ((it.businesslogic.ireport.gui.JNumberField)component).setFont( new java.awt.Font("Dialog", 0, 11));
            return  component;
        }
        else if (this.getType() == COMBOBOX || this.getType() == COMBOBOX_NK)
        {
            component = new JComboBox(this.getTags());
            component.setBorder(null);
            ((JComboBox)component).setFont( new java.awt.Font("Dialog", 0, 11));
            return  component;
        }
        else if (this.getType() == BOOLEAN)
        {
            component = new JCheckBox("");
            return  component;
        }
        else if (this.getType() == COLOR)
        {
            component = new ColorSelectorPanel();
            return  component;
        }
        
        // default (STRING)
        component = new JTextField();
        component.setBorder(null);
        ((JTextField)component).setFont( new java.awt.Font("Dialog", 0, 11));
        return  component;
        
    }
    
    public Object getEditorValue(JComponent component)
    {
       if (this.getType() == NUMBER)
        {
            return new Double(((it.businesslogic.ireport.gui.JNumberField)component).getValue());
        }
       else if (this.getType() == INTEGER)
        {
            return new Integer( (int)((it.businesslogic.ireport.gui.JNumberField)component).getValue());
        }
        else if (this.getType() == COMBOBOX)
        {
           Object obj = ((JComboBox)component).getSelectedItem();
           if (obj != null)
           {
               return ((Tag)obj).getName();
           }
           return null;
        }
       else if (this.getType() == COMBOBOX_NK)
        {
           Object obj = ((JComboBox)component).getSelectedItem();
           if (obj != null)
           {
               return new Integer(((Tag)obj).getValue());
           }
           return null;
        }
        else if (this.getType() == BOOLEAN)
        {
            return  new Boolean(((JCheckBox)component).isSelected());
        }
        else if (this.getType() == COLOR)
        {
            return ((ColorSelectorPanel)component).getValue();
        }
        return ((JTextField)component).getText();
    }
    
    public void setEditorValue(JComponent component, String str)
    {
        try {
            if (str == null) return;
       if (this.getType() == NUMBER)
        {
            ((it.businesslogic.ireport.gui.JNumberField)component).setValue(Double.parseDouble(str) );
        }
       else if (this.getType() == INTEGER)
        {
            ((it.businesslogic.ireport.gui.JNumberField)component).setValue(Integer.parseInt(str) );
        }
        else if (this.getType() == COMBOBOX)
        {
            for (int i=0; i<getTags().size(); ++i)
            {
                Tag t = (Tag)getTags().elementAt(i);
                if (t.getName().equals(str))
                {
                    ((JComboBox)component).setSelectedIndex(i);
                    return;
                }
            }
        }
        else if (this.getType() == COMBOBOX_NK)
        {
            for (int i=0; i<getTags().size(); ++i)
            {
                Tag t = (Tag)getTags().elementAt(i);
                if ((t.getValue()+"").equals(str))
                {
                    ((JComboBox)component).setSelectedIndex(i);
                    return;
                }
            }
        }
        else if (this.getType() == BOOLEAN)
        {
            ((JCheckBox)component).setSelected(str.equals("true"));
        }
        else if (this.getType() == COLOR)
        {
            ((ColorSelectorPanel)component).setValue(str);
        }
        else
        {
            ((JTextField)component).setText(str);
        }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getKeyName() {
        return keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}
