/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRBshGenerator;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRBshCalculator;
import net.sf.jasperreports.engine.fill.JRCalculator;

public class JRBshCompiler
implements JRCompiler {
    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        String bshScript = JRBshGenerator.generateScript(jasperDesign);
        jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), bshScript);
        JRBshCalculator bshCalculator = new JRBshCalculator(bshScript);
        bshCalculator.verify(jasperDesign.getExpressions());
        return jasperReport;
    }

    public JRCalculator loadCalculator(JasperReport jasperReport) throws JRException {
        return new JRBshCalculator((String)jasperReport.getCompileData());
    }
}

