/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRBshGenerator {
    private JasperDesign jasperDesign = null;
    private static Map fieldPrefixMap = null;
    private static Map variablePrefixMap = null;
    private static Map methodSuffixMap = null;

    protected JRBshGenerator(JasperDesign jrDesign) {
        this.jasperDesign = jrDesign;
        fieldPrefixMap = new HashMap();
        fieldPrefixMap.put(new Byte(1), "Old");
        fieldPrefixMap.put(new Byte(2), "");
        fieldPrefixMap.put(new Byte(3), "");
        variablePrefixMap = new HashMap();
        variablePrefixMap.put(new Byte(1), "Old");
        variablePrefixMap.put(new Byte(2), "Estimated");
        variablePrefixMap.put(new Byte(3), "");
        methodSuffixMap = new HashMap();
        methodSuffixMap.put(new Byte(1), "Old");
        methodSuffixMap.put(new Byte(2), "Estimated");
        methodSuffixMap.put(new Byte(3), "");
    }

    public static String generateScript(JasperDesign jrDesign) throws JRException {
        JRBshGenerator generator = new JRBshGenerator(jrDesign);
        return generator.generateScript();
    }

    protected String generateScript() throws JRException {
        Iterator it;
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("//\n// Generated by JasperReports - " + new SimpleDateFormat().format(new Date()) + "\n" + "//\n" + "import net.sf.jasperreports.engine.*;\n" + "import net.sf.jasperreports.engine.fill.*;\n" + "\n" + "import java.util.*;\n" + "import java.math.*;\n" + "import java.text.*;\n" + "import java.io.*;\n" + "import java.net.*;\n" + "\n" + "\n" + "createBshCalculator()\n" + "{\n" + "\n" + "\n");
        Map parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            Iterator it2 = parameterNames.iterator();
            while (it2.hasNext()) {
                sbuffer.append("    JRFillParameter parameter_" + it2.next() + " = null;\n");
            }
        }
        sbuffer.append("\n");
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            Iterator it3 = fieldNames.iterator();
            while (it3.hasNext()) {
                sbuffer.append("    JRFillField field_" + it3.next() + " = null;\n");
            }
        }
        sbuffer.append("\n");
        JRVariable[] variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            int i = 0;
            while (i < variables.length) {
                sbuffer.append("    JRFillVariable variable_" + variables[i].getName() + " = null;\n");
                ++i;
            }
        }
        sbuffer.append("\n\n    init(\n        Map parsm,\n        Map fldsm,\n        Map varsm\n        )\n    {\n");
        parametersMap = this.jasperDesign.getParametersMap();
        if (parametersMap != null && parametersMap.size() > 0) {
            Set parameterNames = parametersMap.keySet();
            String parameterName = null;
            it = parameterNames.iterator();
            while (it.hasNext()) {
                parameterName = (String)it.next();
                sbuffer.append("        super.parameter_" + parameterName + " = (JRFillParameter)parsm.get(\"" + parameterName + "\");\n");
            }
        }
        sbuffer.append("\n");
        fieldsMap = this.jasperDesign.getFieldsMap();
        if (fieldsMap != null && fieldsMap.size() > 0) {
            Set fieldNames = fieldsMap.keySet();
            String fieldName = null;
            it = fieldNames.iterator();
            while (it.hasNext()) {
                fieldName = (String)it.next();
                sbuffer.append("        super.field_" + fieldName + " = (JRFillField)fldsm.get(\"" + fieldName + "\");\n");
            }
        }
        sbuffer.append("\n");
        variables = this.jasperDesign.getVariables();
        if (variables != null && variables.length > 0) {
            String variableName = null;
            int i = 0;
            while (i < variables.length) {
                variableName = variables[i].getName();
                sbuffer.append("        super.variable_" + variableName + " = (JRFillVariable)varsm.get(\"" + variableName + "\");\n");
                ++i;
            }
        }
        sbuffer.append("    }\n\n\n");
        sbuffer.append(this.generateMethod((byte)3));
        sbuffer.append(this.generateMethod((byte)1));
        sbuffer.append(this.generateMethod((byte)2));
        sbuffer.append("\n    return this;\n}\n");
        return sbuffer.toString();
    }

    private String generateMethod(byte evaluationType) throws JRException {
        StringBuffer sbuffer = new StringBuffer();
        sbuffer.append("    Object evaluate" + (String)methodSuffixMap.get(new Byte(evaluationType)) + "(int id)\n" + "    {\n" + "        Object value = null;\n" + "\n" + "        switch (id)\n" + "        {\n");
        Collection expressions = this.jasperDesign.getExpressions();
        if (expressions != null && expressions.size() > 0) {
            JRExpression expression = null;
            Iterator it = expressions.iterator();
            while (it.hasNext()) {
                expression = (JRExpression)it.next();
                sbuffer.append("            case " + expression.getId() + " : // " + expression.getName() + "\n" + "            {\n" + "                value = (" + expression.getValueClassName() + ")(");
                sbuffer.append(this.generateExpression(expression, evaluationType));
                sbuffer.append(");\n                break;\n            }\n");
            }
        }
        sbuffer.append("           default :\n           {\n           }\n        }\n        \n        return value;\n    }\n\n\n");
        return sbuffer.toString();
    }

    private String generateExpression(JRExpression expression, byte evaluationType) throws JRException {
        Map parametersMap = this.jasperDesign.getParametersMap();
        Map fieldsMap = this.jasperDesign.getFieldsMap();
        Map variablesMap = this.jasperDesign.getVariablesMap();
        JRParameter jrParameter = null;
        JRField jrField = null;
        JRVariable jrVariable = null;
        StringBuffer sbuffer = new StringBuffer();
        JRExpressionChunk[] chunks = expression.getChunks();
        JRExpressionChunk chunk = null;
        String chunkText = null;
        if (chunks != null && chunks.length > 0) {
            int i = 0;
            while (i < chunks.length) {
                chunk = chunks[i];
                chunkText = chunk.getText();
                if (chunkText == null) {
                    chunkText = "";
                }
                switch (chunk.getType()) {
                    case 1: {
                        sbuffer.append(chunkText);
                        break;
                    }
                    case 2: {
                        jrParameter = (JRParameter)parametersMap.get(chunkText);
                        sbuffer.append("((" + jrParameter.getValueClassName() + ")" + "super.parameter_" + chunkText + ".getValue()" + ")");
                        break;
                    }
                    case 3: {
                        jrField = (JRField)fieldsMap.get(chunkText);
                        sbuffer.append("((" + jrField.getValueClassName() + ")" + "super.field_" + chunkText + ".get" + (String)fieldPrefixMap.get(new Byte(evaluationType)) + "Value()" + ")");
                        break;
                    }
                    case 4: {
                        jrVariable = (JRVariable)variablesMap.get(chunkText);
                        sbuffer.append("((" + jrVariable.getValueClassName() + ")" + "super.variable_" + chunkText + ".get" + (String)variablePrefixMap.get(new Byte(evaluationType)) + "Value()" + ")");
                    }
                }
                ++i;
            }
        }
        if (sbuffer.length() == 0) {
            sbuffer.append("null");
        }
        return sbuffer.toString();
    }
}

