/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRExpressionChunk;
import net.sf.jasperreports.engine.base.JRBaseExpression;
import net.sf.jasperreports.engine.design.JRDesignExpressionChunk;

public class JRDesignExpression
extends JRBaseExpression {
    private static final long serialVersionUID = 601L;
    private static int lastId = 0;
    protected List chunks = new ArrayList();

    public JRDesignExpression() {
        this.id = JRDesignExpression.getNextId();
    }

    private static synchronized int getNextId() {
        return lastId++;
    }

    public void setValueClass(Class clazz) {
        this.setValueClassName(clazz.getName());
    }

    public void setValueClassName(String className) {
        this.valueClassName = className;
        this.valueClass = null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(int id) {
        this.id = id;
    }

    public JRExpressionChunk[] getChunks() {
        JRExpressionChunk[] chunkArray = null;
        if (this.chunks != null && this.chunks.size() > 0) {
            chunkArray = new JRExpressionChunk[this.chunks.size()];
            this.chunks.toArray(chunkArray);
        }
        return chunkArray;
    }

    public void setChunks(List chunks) {
        this.chunks = chunks;
    }

    public void addChunk(JRDesignExpressionChunk chunk) {
        this.chunks.add(chunk);
    }

    public void addTextChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)1);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addParameterChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)2);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addFieldChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)3);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void addVariableChunk(String text) {
        JRDesignExpressionChunk chunk = new JRDesignExpressionChunk();
        chunk.setType((byte)4);
        chunk.setText(text);
        this.chunks.add(chunk);
    }

    public void setText(String text) {
        this.chunks = new ArrayList();
        if (text != null) {
            int end = 0;
            StringBuffer textChunk = new StringBuffer();
            String parameterChunk = null;
            String fieldChunk = null;
            String variableChunk = null;
            StringTokenizer tkzer = new StringTokenizer(text, "$", true);
            String token = null;
            boolean wasDelim = false;
            while (tkzer.hasMoreTokens()) {
                token = tkzer.nextToken();
                if (token.equals("$")) {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    wasDelim = true;
                    continue;
                }
                if (token.startsWith("P{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        parameterChunk = token.substring(2, end);
                        this.addParameterChunk(parameterChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("F{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        fieldChunk = token.substring(2, end);
                        this.addFieldChunk(fieldChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else if (token.startsWith("V{") && wasDelim) {
                    end = token.indexOf(125);
                    if (end > 0) {
                        if (textChunk.length() > 0) {
                            this.addTextChunk(textChunk.toString());
                        }
                        variableChunk = token.substring(2, end);
                        this.addVariableChunk(variableChunk);
                        textChunk = new StringBuffer(token.substring(end + 1));
                    } else {
                        if (wasDelim) {
                            textChunk.append("$");
                        }
                        textChunk.append(token);
                    }
                } else {
                    if (wasDelim) {
                        textChunk.append("$");
                    }
                    textChunk.append(token);
                }
                wasDelim = false;
            }
            if (wasDelim) {
                textChunk.append("$");
            }
            if (textChunk.length() > 0) {
                this.addTextChunk(textChunk.toString());
            }
        }
    }
}

