/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.AbstractValueProvider;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRLongIncrementerFactory;

class JRLongVarianceIncrementer
implements JRIncrementer {
    private static JRLongVarianceIncrementer mainInstance = new JRLongVarianceIncrementer();

    private JRLongVarianceIncrementer() {
    }

    public static JRLongVarianceIncrementer getInstance() {
        return mainInstance;
    }

    public Object increment(JRFillVariable variable, Object expressionValue, AbstractValueProvider valueProvider) throws JRException {
        Number value = (Number)variable.getValue();
        Number newValue = (Number)expressionValue;
        if (newValue == null) {
            if (variable.isInitialized()) {
                return null;
            }
            return value;
        }
        if (value == null || variable.isInitialized()) {
            return JRLongIncrementerFactory.ZERO;
        }
        Number countValue = (Number)valueProvider.getValue((JRFillVariable)variable.getCountVariable());
        Number sumValue = (Number)valueProvider.getValue((JRFillVariable)variable.getSumVariable());
        return new Long((countValue.longValue() - 1L) * value.longValue() / countValue.longValue() + (sumValue.longValue() / countValue.longValue() - newValue.longValue()) * (sumValue.longValue() / countValue.longValue() - newValue.longValue()) / (countValue.longValue() - 1L));
    }
}

