/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RectangularShape;
import java.util.Arrays;

public abstract class ShapeUtils {
    private static final float SQRT2 = (float)Math.pow(2.0, 0.5);

    public static Shape rotateShape(Shape shape, double d, float f, float f2) {
        if (shape == null) {
            return null;
        }
        AffineTransform affineTransform = AffineTransform.getRotateInstance(d, f, f2);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public static Shape clone(Shape shape) {
        Shape shape2 = null;
        if (shape instanceof Line2D) {
            Line2D line2D = (Line2D)shape;
            shape2 = (Shape)line2D.clone();
        } else if (shape instanceof RectangularShape) {
            RectangularShape rectangularShape = (RectangularShape)shape;
            shape2 = (Shape)rectangularShape.clone();
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            shape2 = (Shape)area.clone();
        } else if (shape instanceof GeneralPath) {
            GeneralPath generalPath = (GeneralPath)shape;
            shape2 = (Shape)generalPath.clone();
        }
        return shape2;
    }

    public static boolean equal(Polygon polygon, Polygon polygon2) {
        if (polygon == null) {
            return polygon2 == null;
        }
        if (polygon2 == null) {
            return false;
        }
        if (polygon.npoints != polygon2.npoints) {
            return false;
        }
        if (!Arrays.equals(polygon.xpoints, polygon2.xpoints)) {
            return false;
        }
        return Arrays.equals(polygon.ypoints, polygon2.ypoints);
    }

    public static Shape translateShape(Shape shape, double d, double d2) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public static Shape createDiagonalCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f - f2, -f + f2);
        generalPath.lineTo(-f + f2, -f - f2);
        generalPath.lineTo(0.0f, -f2 * SQRT2);
        generalPath.lineTo(f - f2, -f - f2);
        generalPath.lineTo(f + f2, -f + f2);
        generalPath.lineTo(f2 * SQRT2, 0.0f);
        generalPath.lineTo(f + f2, f - f2);
        generalPath.lineTo(f - f2, f + f2);
        generalPath.lineTo(0.0f, f2 * SQRT2);
        generalPath.lineTo(-f + f2, f + f2);
        generalPath.lineTo(-f - f2, f - f2);
        generalPath.lineTo(-f2 * SQRT2, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createRegularCross(float f, float f2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f, f2);
        generalPath.lineTo(-f2, f2);
        generalPath.lineTo(-f2, f);
        generalPath.lineTo(f2, f);
        generalPath.lineTo(f2, f2);
        generalPath.lineTo(f, f2);
        generalPath.lineTo(f, -f2);
        generalPath.lineTo(f2, -f2);
        generalPath.lineTo(f2, -f);
        generalPath.lineTo(-f2, -f);
        generalPath.lineTo(-f2, -f2);
        generalPath.lineTo(-f, -f2);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDiamond(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, 0.0f);
        generalPath.lineTo(0.0f, f);
        generalPath.lineTo(-f, 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createUpTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, -f);
        generalPath.lineTo(f, f);
        generalPath.lineTo(-f, f);
        generalPath.closePath();
        return generalPath;
    }

    public static Shape createDownTriangle(float f) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, f);
        generalPath.lineTo(f, -f);
        generalPath.lineTo(-f, -f);
        generalPath.closePath();
        return generalPath;
    }
}

