/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Dimension;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.fill.DefaultMaxFontFinder;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.MaxFontSizeFinder;
import net.sf.jasperreports.engine.fill.StyledTextMaxFontFinder;
import net.sf.jasperreports.engine.util.JRStyledText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public abstract class JRFillTextElement
extends JRFillElement
implements JRTextElement {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$fill$JRFillTextElement == null ? (class$net$sf$jasperreports$engine$fill$JRFillTextElement = JRFillTextElement.class$("net.sf.jasperreports.engine.fill.JRFillTextElement")) : class$net$sf$jasperreports$engine$fill$JRFillTextElement));
    private static FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
    private JRFont font = null;
    private Dimension2D dimension = null;
    private float floatLineSpacing = 0.0f;
    private float lineSpacingFactor = 0.0f;
    private float leadingOffset = 0.0f;
    private float textHeight = 0.0f;
    private int textStart = 0;
    private int textEnd = 0;
    private String rawText = null;
    private JRStyledText styledText = null;
    private MaxFontSizeFinder maxFontSizeFinder = null;
    private Map styledTextAttributes = null;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$fill$JRFillTextElement;

    protected JRFillTextElement(JRBaseFiller filler, JRTextElement textElement, JRFillObjectFactory factory) {
        super(filler, textElement, factory);
        this.font = factory.getFont(textElement.getFont());
        this.initializeDimension();
        this.initilizeFloatLineSpacing();
        this.initilizeMaxFontFinder();
    }

    public byte getTextAlignment() {
        return ((JRTextElement)this.parent).getTextAlignment();
    }

    public void setTextAlignment(byte horizontalAlignment) {
    }

    public byte getVerticalAlignment() {
        return ((JRTextElement)this.parent).getVerticalAlignment();
    }

    public void setVerticalAlignment(byte verticalAlignment) {
    }

    public byte getRotation() {
        return ((JRTextElement)this.parent).getRotation();
    }

    public void setRotation(byte rotation) {
    }

    public byte getLineSpacing() {
        return ((JRTextElement)this.parent).getLineSpacing();
    }

    public void setLineSpacing(byte lineSpacing) {
    }

    public boolean isStyledText() {
        return ((JRTextElement)this.parent).isStyledText();
    }

    public void setStyledText(boolean isStyledText) {
    }

    public JRFont getFont() {
        return this.font;
    }

    private void initializeDimension() {
        int width = this.getWidth();
        int height = this.getHeight();
        switch (this.getRotation()) {
            case 1: {
                width = this.getHeight();
                height = this.getWidth();
                break;
            }
            case 2: {
                width = this.getHeight();
                height = this.getWidth();
                break;
            }
        }
        this.dimension = new Dimension(width, height);
    }

    private void initilizeFloatLineSpacing() {
        switch (this.getLineSpacing()) {
            case 0: {
                this.floatLineSpacing = 1.0f;
                break;
            }
            case 1: {
                this.floatLineSpacing = 1.5f;
                break;
            }
            case 2: {
                this.floatLineSpacing = 2.0f;
                break;
            }
            default: {
                this.floatLineSpacing = 1.0f;
            }
        }
    }

    private void initilizeMaxFontFinder() {
        this.maxFontSizeFinder = this.isStyledText() ? new StyledTextMaxFontFinder() : new DefaultMaxFontFinder();
    }

    protected Map getStyledTextAttributes() {
        if (this.styledTextAttributes == null) {
            this.styledTextAttributes = new HashMap();
            this.styledTextAttributes.putAll(this.getFont().getAttributes());
            this.styledTextAttributes.put(TextAttribute.FOREGROUND, this.getForecolor());
            if (this.getMode() == 1) {
                this.styledTextAttributes.put(TextAttribute.BACKGROUND, this.getBackcolor());
            }
        }
        return this.styledTextAttributes;
    }

    protected float getLineSpacingFactor() {
        return this.lineSpacingFactor;
    }

    protected void setLineSpacingFactor(float lineSpacingFactor) {
        this.lineSpacingFactor = lineSpacingFactor;
    }

    protected float getLeadingOffset() {
        return this.leadingOffset;
    }

    protected void setLeadingOffset(float leadingOffset) {
        this.leadingOffset = leadingOffset;
    }

    protected float getTextHeight() {
        return this.textHeight;
    }

    protected void setTextHeight(float textHeight) {
        this.textHeight = textHeight;
    }

    protected int getTextStart() {
        return this.textStart;
    }

    protected void setTextStart(int textStart) {
        this.textStart = textStart;
    }

    protected int getTextEnd() {
        return this.textEnd;
    }

    protected void setTextEnd(int textEnd) {
        this.textEnd = textEnd;
    }

    protected String getRawText() {
        return this.rawText;
    }

    protected void setRawText(String rawText) {
        this.rawText = rawText;
        this.styledText = null;
    }

    protected void reset() {
        super.reset();
        this.lineSpacingFactor = 0.0f;
        this.leadingOffset = 0.0f;
        this.textHeight = 0.0f;
    }

    protected void rewind() throws JRException {
        this.textStart = 0;
        this.textEnd = 0;
    }

    protected JRStyledText getStyledText() {
        String text;
        if (this.styledText == null && (text = this.getRawText()) != null) {
            block5: {
                if (this.isStyledText()) {
                    try {
                        this.styledText = this.filler.getStyledTextParser().parse(this.getStyledTextAttributes(), text);
                    }
                    catch (SAXException e) {
                        if (!log.isWarnEnabled()) break block5;
                        log.warn((Object)"Invalid styled text.", (Throwable)e);
                    }
                }
            }
            if (this.styledText == null) {
                this.styledText = new JRStyledText();
                this.styledText.append(text);
                this.styledText.addRun(new JRStyledText.Run(this.getStyledTextAttributes(), 0, text.length()));
            }
        }
        return this.styledText;
    }

    public String getText() {
        JRStyledText styledText = this.getStyledText();
        if (styledText == null) {
            return null;
        }
        return styledText.getText();
    }

    protected void chopTextElement(int availableStretchHeight) {
        JRStyledText styledText = this.getStyledText();
        if (styledText == null) {
            return;
        }
        String allText = this.getText().substring(this.getTextEnd());
        if (allText.length() == 0) {
            return;
        }
        float formatWidth = (float)this.dimension.getWidth();
        float lineSpacing = this.floatLineSpacing;
        float drawPosY = 0.0f;
        float firstLineLeading = 0.0f;
        int maxHeight = (int)this.dimension.getHeight() + availableStretchHeight;
        int strpos = 0;
        int lastPosition = 0;
        int lines = 0;
        int fontSizeSum = 0;
        int firstLineMaxFontSize = 0;
        int paragraphStart = 0;
        int paragraphEnd = this.getTextEnd();
        boolean isMaxHeightReached = false;
        boolean wasDelim = false;
        AttributedCharacterIterator allParagraphs = styledText.getAttributedString().getIterator();
        StringTokenizer tkzer = new StringTokenizer(allText, "\n", true);
        while (tkzer.hasMoreTokens() && !isMaxHeightReached) {
            String paragraphText = tkzer.nextToken();
            paragraphStart = paragraphEnd;
            paragraphEnd = paragraphStart + paragraphText.length();
            if ("\n".equals(paragraphText)) {
                wasDelim = true;
                continue;
            }
            AttributedCharacterIterator paragraph = new AttributedString(allParagraphs, paragraphStart, paragraphEnd).getIterator();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, fontRenderContext);
            lastPosition = lineMeasurer.getPosition();
            while (lineMeasurer.getPosition() < paragraphText.length() && !isMaxHeightReached) {
                int lineStart = lineMeasurer.getPosition();
                TextLayout layout = lineMeasurer.nextLayout(formatWidth);
                if ((drawPosY += layout.getLeading() + lineSpacing * layout.getAscent()) + layout.getDescent() <= (float)maxHeight) {
                    fontSizeSum += this.maxFontSizeFinder.findMaxFontSize(new AttributedString(paragraph, lineStart, lineStart + layout.getCharacterCount()).getIterator(), this.getFont().getSize());
                    if (++lines == 1) {
                        firstLineLeading = drawPosY;
                        firstLineMaxFontSize = fontSizeSum;
                    }
                    lastPosition = lineMeasurer.getPosition();
                    drawPosY += layout.getDescent();
                    continue;
                }
                drawPosY -= layout.getLeading() + lineSpacing * layout.getAscent();
                isMaxHeightReached = true;
            }
            if (isMaxHeightReached) {
                strpos += lastPosition;
                if (!wasDelim) continue;
                ++strpos;
                continue;
            }
            strpos += paragraphText.length();
            if (!wasDelim) continue;
            ++strpos;
        }
        this.setTextHeight(drawPosY + 1.0f);
        if (this.getRotation() == 0) {
            this.setStretchHeight((int)this.getTextHeight());
        } else {
            this.setStretchHeight(this.getHeight());
        }
        this.setTextStart(this.getTextEnd());
        this.setTextEnd(this.getTextStart() + strpos);
        if (lines > 0) {
            this.setLineSpacingFactor(this.getTextHeight() / (float)fontSizeSum);
            this.setLeadingOffset(firstLineLeading - (float)firstLineMaxFontSize * this.getLineSpacingFactor());
        } else {
            this.setLineSpacingFactor(0.0f);
            this.setLeadingOffset(0.0f);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

