/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;

class BinaryDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryDatabaseRowInput(byte[] byArray, int n) throws IOException {
        super(byArray, n);
    }

    public int readType() throws IOException {
        return this.readInt();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    private String readNumericString() throws IOException {
        return this.readString();
    }

    byte[] readByteArray() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    protected boolean checkNull() throws IOException {
        return this.readInt() == 0;
    }

    protected String readChar(int n) throws IOException {
        return this.readUTF();
    }

    protected Integer readSmallint() throws IOException, SQLException {
        return Integer.valueOf(this.readNumericString());
    }

    protected Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readIntData());
    }

    protected Long readBigint() throws IOException, SQLException {
        return Long.valueOf(this.readNumericString());
    }

    protected Double readReal(int n) throws IOException, SQLException {
        if (n == 7) {
            return Double.valueOf(this.readNumericString());
        }
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    protected BigDecimal readDecimal() throws IOException, SQLException {
        return new BigDecimal(this.readNumericString());
    }

    protected Boolean readBit() throws IOException, SQLException {
        return Boolean.valueOf(this.readString());
    }

    protected Time readTime() throws IOException, SQLException {
        return Time.valueOf(this.readString());
    }

    protected Date readDate() throws IOException, SQLException {
        return Date.valueOf(this.readString());
    }

    protected Timestamp readTimestamp() throws IOException, SQLException {
        return Timestamp.valueOf(this.readString());
    }

    protected Object readOther() throws IOException, SQLException {
        String string = this.readString();
        byte[] byArray = string.equals("**") ? this.readByteArray() : ByteArray.hexToByteArray(string);
        return ByteArray.deserialize(byArray);
    }

    protected byte[] readBinary(int n) throws IOException, SQLException {
        String string = this.readString();
        if (string.equals("**")) {
            return this.readByteArray();
        }
        return ByteArray.hexToByteArray(string);
    }
}

