/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.IReportConnection;
import it.businesslogic.ireport.ReportClassLoader;
import it.businesslogic.ireport.export.JRTxtExporter;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.design.JRJdk13Compiler;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.view.JasperViewer;

public class IReportCompiler
implements Runnable,
JRExportProgressMonitor {
    public static final int CMD_COMPILE = 1;
    public static final int CMD_EXPORT = 2;
    public static final int CMD_COMPILE_SCRIPTLET = 4;
    public static final String OUTPUT_DIRECTORY = "OUTPUT_DIRECTORY";
    public static final String OUTPUT_FORMAT = "OUTPUT_FORMAT";
    public static final String USE_EMPTY_DATASOURCE = "USE_EMPTY_DATASOURCE";
    public static final String USE_CONNECTION = "USE_CONNECTION";
    public static final String CONNECTION = "CONNECTION";
    public static final String SCRIPTLET_OUTPUT_DIRECTORY = "SCRIPTLET_OUTPUT_DIRECTORY";
    private JList threadList = null;
    static PrintStream myPrintStream = null;
    int filledpage = 0;
    private String status = "Staring";
    private IReportConnection iReportConnection;
    private JReportFrame jrf;
    private MainFrame mainFrame;
    private int command = 0;
    private HashMap properties = new HashMap();
    private Thread thread;
    private String javaFile = "";
    private static String outputBuffer = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block77: {
            block78: {
                String viewer_program;
                String format;
                String fileName;
                long start;
                block75: {
                    boolean compilation_ok;
                    block76: {
                        block72: {
                            block73: {
                                StringWriter sw;
                                String oldCompileTemp;
                                String tempDirStr;
                                if (this.threadList != null) {
                                    DefaultListModel dlm = (DefaultListModel)this.threadList.getModel();
                                    dlm.addElement(this);
                                    this.threadList.updateUI();
                                }
                                compilation_ok = true;
                                start = System.currentTimeMillis();
                                PrintStream out = System.out;
                                PrintStream err = System.err;
                                if (myPrintStream == null) {
                                    myPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream()));
                                }
                                if (out != myPrintStream) {
                                    System.setOut(myPrintStream);
                                }
                                if (err != myPrintStream) {
                                    System.setErr(myPrintStream);
                                }
                                outputBuffer = "";
                                fileName = this.jrf.getReport().getFilename();
                                String srcFileName = this.jrf.getReport().getFilename();
                                fileName = Misc.changeFileExtension(fileName, "jasper");
                                File f = new File(fileName);
                                if (this.properties.get(OUTPUT_DIRECTORY) != null) {
                                    fileName = (String)this.properties.get(OUTPUT_DIRECTORY) + File.separatorChar + f.getName();
                                }
                                String scriptletFileName = this.jrf.getReport().getFilename();
                                String srcScriptletFileName = this.jrf.getReport().getFilename();
                                srcScriptletFileName = scriptletFileName = srcScriptletFileName.substring(0, scriptletFileName.length() - 1) + "Scriptlet.java";
                                File f2 = new File(scriptletFileName);
                                if (this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) != null) {
                                    scriptletFileName = (String)this.properties.get(SCRIPTLET_OUTPUT_DIRECTORY) + File.separatorChar + f2.getName();
                                }
                                String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
                                String classpath = System.getProperty("jasper.reports.compile.class.path");
                                if (classpath != null) {
                                    classpath = classpath + File.pathSeparator + reportDirectory;
                                    System.setProperty("jasper.reports.compile.class.path", classpath);
                                } else if (System.getProperty("java.class.path") != null) {
                                    classpath = System.getProperty("java.class.path");
                                    classpath = classpath + File.pathSeparator + reportDirectory;
                                    System.setProperty("java.class.path", classpath);
                                }
                                reportDirectory = reportDirectory.replace('\\', '/');
                                if (!reportDirectory.endsWith("/")) {
                                    reportDirectory = reportDirectory + "/";
                                }
                                if (!reportDirectory.startsWith("/")) {
                                    reportDirectory = "/" + reportDirectory;
                                }
                                ReportClassLoader reportClassLoader = new ReportClassLoader();
                                reportClassLoader.setRelodablePaths(reportDirectory);
                                reportClassLoader.rescanLibDirectory();
                                try {
                                    Thread.currentThread().setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}, (ClassLoader)reportClassLoader));
                                }
                                catch (MalformedURLException mue) {
                                    mue.printStackTrace();
                                }
                                if ((this.command & 4) != 0) {
                                    this.status = "compiling scriptlet";
                                    this.updateThreadList();
                                    start = System.currentTimeMillis();
                                    oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
                                    if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                        tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                    }
                                    File file = new File(tempDirStr);
                                    this.javaFile = srcScriptletFileName;
                                    this.javaFile = new File(file, this.javaFile).getPath();
                                    this.javaFile = this.jrf.getReport().getScriptletFileName();
                                    this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling file... " + scriptletFileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
                                    try {
                                        JRJdk13Compiler compiler = new JRJdk13Compiler();
                                        compiler.compileClass(new File(this.javaFile), Misc.getClassPath());
                                    }
                                    catch (Exception ex) {
                                        this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the Scriptlet java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                                        sw = new StringWriter(0);
                                        ex.printStackTrace(new PrintWriter(sw));
                                        myPrintStream.flush();
                                        this.parseException(outputBuffer + sw.getBuffer() + "", null);
                                        compilation_ok = false;
                                    }
                                    finally {
                                        if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                            // empty if block
                                        }
                                    }
                                    this.mainFrame.logOnConsole(outputBuffer);
                                    outputBuffer = "";
                                    this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
                                }
                                if (!compilation_ok) {
                                    this.removeThread();
                                    return;
                                }
                                if ((this.command & 1) == 0) break block76;
                                this.status = "compiling report";
                                this.updateThreadList();
                                System.setProperty("jasper.reports.compile.keep.java.file", "true");
                                this.javaFile = this.jrf.getReport().getName() + ".java";
                                oldCompileTemp = tempDirStr = System.getProperty("jasper.reports.compile.temp");
                                if (tempDirStr == null || tempDirStr.length() == 0 || this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                    tempDirStr = this.mainFrame.getTranslatedCompileDirectory();
                                }
                                File file = new File(tempDirStr);
                                this.javaFile = new File(file, this.javaFile).getPath();
                                this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Compiling to file... " + fileName + " -> " + this.javaFile + "</font><br><font face=\"Courier New\" size=\"3\">", true);
                                try {
                                    try {
                                        if (this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) {
                                            System.setProperty("jasper.reports.compile.temp", tempDirStr);
                                        }
                                        String old_jr_classpath = Misc.nvl(System.getProperty("jasper.reports.compile.class.path"), "");
                                        System.setProperty("jasper.reports.compile.class.path", Misc.nvl(new File(fileName).getParent(), ".") + File.pathSeparator + System.getProperty("java.class.path") + File.pathSeparator + System.getProperty("java.class.path"));
                                        JasperCompileManager.compileReportToFile((String)srcFileName, (String)fileName);
                                        System.setProperty("jasper.reports.compile.class.path", old_jr_classpath);
                                    }
                                    catch (JRException jrex) {
                                        compilation_ok = false;
                                        this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Errors compiling " + fileName + "!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                                        Vector<String> source = new Vector<String>();
                                        try {
                                            BufferedReader is = new BufferedReader(new FileReader(this.javaFile));
                                            while (true) {
                                                String line;
                                                if ((line = is.readLine()) == null) {
                                                    is.close();
                                                    break;
                                                }
                                                source.addElement(line);
                                            }
                                        }
                                        catch (Exception ioex) {
                                            // empty catch block
                                        }
                                        StringWriter sw2 = new StringWriter(0);
                                        jrex.printStackTrace(new PrintWriter(sw2));
                                        System.out.println("\n\n\n");
                                        myPrintStream.flush();
                                        this.parseException(outputBuffer + sw2.getBuffer() + "", source);
                                        Object var23_44 = null;
                                        if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block72;
                                        if (oldCompileTemp != null) {
                                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                            break block72;
                                        } else {
                                            System.setProperty("jasper.reports.compile.temp", "");
                                        }
                                        break block72;
                                    }
                                    catch (Exception ex) {
                                        this.mainFrame.logOnConsole("</font><font face=\"SansSerif\"  size=\"3\" color=\"#CC0000\"><b>Error compiling the report java source!</b></font><br><font face=\"Courier New\" size=\"3\">", true);
                                        sw = new StringWriter(0);
                                        ex.printStackTrace(new PrintWriter(sw));
                                        myPrintStream.flush();
                                        this.parseException(outputBuffer + sw.getBuffer() + "", null);
                                        compilation_ok = false;
                                        Object var23_45 = null;
                                        if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block72;
                                        if (oldCompileTemp != null) {
                                            System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                            break block72;
                                        } else {
                                            System.setProperty("jasper.reports.compile.temp", "");
                                        }
                                        break block72;
                                    }
                                    Object var23_43 = null;
                                    if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) break block72;
                                    if (oldCompileTemp == null) break block73;
                                }
                                catch (Throwable throwable) {
                                    Object var23_46 = null;
                                    if (!this.mainFrame.isUsingCurrentFilesDirectoryForCompiles()) throw throwable;
                                    if (oldCompileTemp != null) {
                                        System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                        throw throwable;
                                    }
                                    System.setProperty("jasper.reports.compile.temp", "");
                                    throw throwable;
                                }
                                System.setProperty("jasper.reports.compile.temp", oldCompileTemp);
                                break block72;
                            }
                            System.setProperty("jasper.reports.compile.temp", "");
                        }
                        this.mainFrame.logOnConsole(outputBuffer);
                        outputBuffer = "";
                        this.mainFrame.logOnConsole("</font><hr><font face=\"SansSerif\"  size=\"3\" color=\"#0000CC\"><b>Compilation running time : " + (System.currentTimeMillis() - start) + "</b></font><br><hr><font face=\"Courier New\" size=\"3\">", true);
                    }
                    if (!compilation_ok) {
                        this.removeThread();
                        return;
                    }
                    if ((this.command & 2) == 0) break block77;
                    this.status = "generating report";
                    this.updateThreadList();
                    JasperPrint print = null;
                    this.mainFrame.logOnConsole("</font><font face=\"SansSerif\" size=\"3\" color=\"#000000\">Filling report... </font><br><font face=\"Courier New\" size=\"3\">", true);
                    if (this.properties.get(USE_EMPTY_DATASOURCE) != null && this.properties.get(USE_EMPTY_DATASOURCE).equals("true")) {
                        try {
                            print = JasperFillManager.fillReport((String)fileName, new HashMap(), (JRDataSource)new JREmptyDataSource());
                        }
                        catch (Exception ex) {
                            this.mainFrame.logOnConsole("Error filling print...\n");
                            ex.printStackTrace();
                            this.mainFrame.logOnConsole(outputBuffer);
                            outputBuffer = "";
                        }
                    } else if (this.properties.get(USE_CONNECTION) != null && this.properties.get(USE_CONNECTION).equals("true")) {
                        try {
                            IReportConnection connection = (IReportConnection)this.properties.get(CONNECTION);
                            HashMap hashMap = new HashMap();
                            if (connection.isJDBCConnection()) {
                                print = JasperFillManager.fillReport((String)fileName, hashMap, (Connection)connection.getConnection());
                            } else {
                                JRDataSource ds = connection.getJRDataSource();
                                print = JasperFillManager.fillReport((String)fileName, hashMap, (JRDataSource)ds);
                            }
                        }
                        catch (Exception ex) {
                            this.mainFrame.logOnConsole("Error filling print...\n");
                            ex.printStackTrace();
                            this.mainFrame.logOnConsole(outputBuffer);
                            outputBuffer = "";
                        }
                    }
                    Object jrv = null;
                    Object var17_25 = null;
                    if (print == null) break block78;
                    this.status = "exporting report";
                    this.updateThreadList();
                    format = Misc.nvl(this.properties.get(OUTPUT_FORMAT), "pdf");
                    viewer_program = "";
                    this.mainFrame.logOnConsole(this.properties.get(OUTPUT_FORMAT) + "Exporting\n");
                    try {
                        void var17_33;
                        if (format.equalsIgnoreCase("pdf")) {
                            JRPdfExporter jRPdfExporter = new JRPdfExporter();
                            fileName = Misc.changeFileExtension(fileName, "pdf");
                            this.mainFrame.logOnConsole("Exporting pdf to file... \"" + fileName + "\"\n");
                            viewer_program = this.mainFrame.getProperties().getProperty("ExternalPDFViewer");
                        } else if (format.equalsIgnoreCase("csv")) {
                            JRCsvExporter jRCsvExporter = new JRCsvExporter();
                            fileName = Misc.changeFileExtension(fileName, "csv");
                            this.mainFrame.logOnConsole("Exporting CSV to file... " + fileName + "\n");
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalCSVViewer"), "");
                        } else if (format.equalsIgnoreCase("html")) {
                            JRHtmlExporter jRHtmlExporter = new JRHtmlExporter();
                            fileName = Misc.changeFileExtension(fileName, "html");
                            this.mainFrame.logOnConsole("Exporting HTML to file... " + fileName + "\n");
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalHTMLViewer"), "");
                        } else if (format.equalsIgnoreCase("xls")) {
                            JRXlsExporter jRXlsExporter = new JRXlsExporter();
                            fileName = Misc.changeFileExtension(fileName, "xls");
                            this.mainFrame.logOnConsole("Exporting xls to file... " + fileName + "\n");
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalXLSViewer"), "");
                        } else if (format.equalsIgnoreCase("java2D")) {
                            JRGraphics2DExporter jRGraphics2DExporter = new JRGraphics2DExporter();
                            this.mainFrame.logOnConsole("Exporting to Java2D \n");
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("jrviewer")) {
                            this.mainFrame.logOnConsole("Viewing with JasperReports Viewer\n");
                            Object var17_31 = null;
                            viewer_program = null;
                        } else if (format.equalsIgnoreCase("txt")) {
                            JRTxtExporter jRTxtExporter = new JRTxtExporter();
                            fileName = Misc.changeFileExtension(fileName, "txt");
                            this.mainFrame.logOnConsole("Exporting txt (experimental) to file... " + fileName + "\n");
                            viewer_program = Misc.nvl(this.mainFrame.getProperties().getProperty("ExternalEditor"), "");
                        }
                        if (var17_33 != null) {
                            var17_33.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)fileName);
                            var17_33.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                            var17_33.setParameter(JRExporterParameter.PROGRESS_MONITOR, (Object)this);
                            var17_33.exportReport();
                            break block75;
                        }
                        if (format.equalsIgnoreCase("jrviewer")) {
                            JasperViewer jasperViewer = new JasperViewer(print, false);
                            jasperViewer.setTitle("iReport JasperViewer");
                            jasperViewer.show();
                        }
                    }
                    catch (Exception ex2) {
                        this.mainFrame.logOnConsole("Error exporting print...\n");
                        ex2.printStackTrace();
                        this.mainFrame.logOnConsole(outputBuffer);
                        outputBuffer = "";
                    }
                }
                this.mainFrame.logOnConsole("Running time : " + (System.currentTimeMillis() - start) + "\n");
                Runtime rt = Runtime.getRuntime();
                if (viewer_program == null || viewer_program.equals("")) {
                    if (!format.equalsIgnoreCase("jrviewer")) {
                        this.mainFrame.logOnConsole("No external viewer specified for this type of print. Set it in the options frame!\n");
                    }
                    break block77;
                } else {
                    try {
                        String execute_string = viewer_program + " " + fileName + "";
                        this.mainFrame.logOnConsole("Executing: " + execute_string + "\n");
                        rt.exec(execute_string);
                    }
                    catch (Exception ex) {
                        this.mainFrame.logOnConsole("Error viewing report...\n");
                        ex.printStackTrace();
                        this.mainFrame.logOnConsole(outputBuffer + "\n");
                        outputBuffer = "";
                    }
                    this.mainFrame.logOnConsole("Finished...\n");
                }
                break block77;
            }
            this.mainFrame.logOnConsole("Print not filled. Try to use an EmptyDataSource...!\n");
        }
        this.removeThread();
    }

    public void removeThread() {
        if (this.threadList != null) {
            DefaultListModel dlm = (DefaultListModel)this.threadList.getModel();
            dlm.removeElement(this);
            this.threadList.updateUI();
        }
    }

    public int getCommand() {
        return this.command;
    }

    public void setCommand(int command) {
        this.command = command;
    }

    public IReportConnection getIReportConnection() {
        return this.iReportConnection;
    }

    public void setIReportConnection(IReportConnection iReportConnection) {
        this.iReportConnection = iReportConnection;
    }

    public JReportFrame getJrf() {
        return this.jrf;
    }

    public void setJrf(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public String toString() {
        return this.status;
    }

    public void start() {
        this.thread = new Thread(this);
        try {
            String reportDirectory = new File(this.jrf.getReport().getFilename()).getParent();
            String classpath = System.getProperty("jasper.reports.compile.class.path");
            if (classpath != null) {
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("jasper.reports.compile.class.path", classpath);
            } else if (System.getProperty("java.class.path") != null) {
                classpath = System.getProperty("java.class.path");
                classpath = classpath + File.pathSeparator + reportDirectory;
                System.setProperty("java.class.path", classpath);
            }
            reportDirectory = reportDirectory.replace('\\', '/');
            if (!reportDirectory.endsWith("/")) {
                reportDirectory = reportDirectory + "/";
            }
            if (!reportDirectory.startsWith("/")) {
                reportDirectory = "/" + reportDirectory;
            }
            this.thread.setContextClassLoader(new URLClassLoader(new URL[]{new URL("file://" + reportDirectory)}));
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        this.thread.start();
    }

    public void parseException(String exception, Vector sourceLines) {
        String outString = "";
        StringTokenizer st = new StringTokenizer(exception, "\n");
        while (st.hasMoreElements()) {
            String line = st.nextToken();
            if (line.startsWith(this.javaFile)) {
                String lineCode;
                outString = outString + Misc.toHTML(line + "\n");
                String lineNumber = line.substring(this.javaFile.length() + 1);
                int ln = Integer.parseInt(lineNumber = lineNumber.substring(0, lineNumber.indexOf(58)));
                if (ln >= 3) {
                    ln -= 3;
                }
                String reference = "";
                if (sourceLines.size() >= ln && (lineCode = (String)sourceLines.elementAt(ln)).indexOf("            case") == 0 && lineCode.indexOf(" : // ") > 0) {
                    reference = lineCode.substring(lineCode.indexOf(" : // ") + 6).trim();
                }
                if (!st.hasMoreElements()) continue;
                try {
                    String error_line = st.nextToken();
                    if (error_line.startsWith("found")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("required")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("symbol")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    if (error_line.startsWith("location")) {
                        outString = outString + Misc.toHTML(error_line + "\n");
                        error_line = st.nextToken();
                    }
                    String html = "";
                    for (int i = 0; i < error_line.length() && error_line.charAt(i) == ' '; ++i) {
                        html = html + "&nbsp;";
                    }
                    error_line = error_line.trim();
                    html = html + "<a href=\"http://error:" + this.jrf.getWindowID() + "/" + reference + "\">" + Misc.toHTML(error_line) + "</a><br>";
                    outString = outString + html;
                }
                catch (Exception ex) {
                    outString = outString + Misc.toHTML("Error parsing\n!");
                }
                continue;
            }
            if (line.startsWith("Warning :") && line.indexOf("y=") > 0 && line.indexOf("height=") > 0 && line.indexOf("band-height=") > 0) {
                outString = outString + "<a href=\"http://warning:" + this.jrf.getWindowID() + "\">" + Misc.toHTML(line) + "</a><br>";
                continue;
            }
            outString = outString + Misc.toHTML(line + "\n");
        }
        this.mainFrame.logOnConsole(outString, true);
        outputBuffer = "";
    }

    public JComponent searchButton(JComponent root, String text) {
        if (root instanceof JButton && ((JButton)root).getText() != null && ((JButton)root).getText().equals(text)) {
            return root;
        }
        for (int i = 0; i < root.getComponentCount(); ++i) {
            if (!(root.getComponent(i) instanceof JComponent)) continue;
            this.mainFrame.logOnConsole("" + (JComponent)root.getComponent(i) + "\n");
            JComponent res = this.searchButton((JComponent)root.getComponent(i), text);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void afterPageExport() {
        ++this.filledpage;
    }

    public JList getThreadList() {
        return this.threadList;
    }

    public void setThreadList(JList threadList) {
        this.threadList = threadList;
    }

    public void updateThreadList() {
        try {
            if (this.threadList != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        IReportCompiler.this.threadList.updateUI();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class FilteredStream
    extends FilterOutputStream {
        public FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        public void write(byte[] b) throws IOException {
            String aString = new String(b);
            outputBuffer = outputBuffer + aString;
        }

        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            outputBuffer = outputBuffer + aString;
        }
    }
}

