/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.gui.JNumberField;
import it.businesslogic.ireport.gui.sheet.ColorSelectorPanel;
import it.businesslogic.ireport.gui.sheet.Tag;
import java.awt.Font;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class SheetProperty {
    public static final int STRING = 0;
    public static final int NUMBER = 1;
    public static final int INTEGER = 6;
    public static final int COMBOBOX = 2;
    public static final int COLOR = 3;
    public static final int BOOLEAN = 4;
    public static final int COMBOBOX_NK = 5;
    private String name = "";
    private String keyName = "";
    private int type;
    private Vector tags = null;
    private String defaultValue = null;

    public SheetProperty(String keyName, String name, int type) {
        this(keyName, name, type, null);
    }

    public SheetProperty(String keyName, String name, int type, String defaultValue) {
        this.setName(name);
        this.setKeyName(keyName);
        this.setDefaultValue(defaultValue);
        this.setType(type);
        this.tags = new Vector();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public Vector getTags() {
        return this.tags;
    }

    public void setTags(Vector tags) {
        this.tags = tags;
    }

    public JComponent getEditor() {
        JComponent component = null;
        if (this.getType() == 1) {
            component = new JNumberField();
            component.setBorder(null);
            ((JTextField)component).setFont(new Font("Dialog", 0, 11));
            return component;
        }
        if (this.getType() == 6) {
            component = new JNumberField();
            component.setBorder(null);
            try {
                ((JNumberField)component).setInteger(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((JTextField)component).setFont(new Font("Dialog", 0, 11));
            return component;
        }
        if (this.getType() == 2 || this.getType() == 5) {
            component = new JComboBox(this.getTags());
            component.setBorder(null);
            ((JComboBox)component).setFont(new Font("Dialog", 0, 11));
            return component;
        }
        if (this.getType() == 4) {
            component = new JCheckBox("");
            return component;
        }
        if (this.getType() == 3) {
            component = new ColorSelectorPanel();
            return component;
        }
        component = new JTextField();
        component.setBorder(null);
        ((JTextField)component).setFont(new Font("Dialog", 0, 11));
        return component;
    }

    public Object getEditorValue(JComponent component) {
        if (this.getType() == 1) {
            return new Double(((JNumberField)component).getValue());
        }
        if (this.getType() == 6) {
            return new Integer((int)((JNumberField)component).getValue());
        }
        if (this.getType() == 2) {
            Object obj = ((JComboBox)component).getSelectedItem();
            if (obj != null) {
                return ((Tag)obj).getName();
            }
            return null;
        }
        if (this.getType() == 5) {
            Object obj = ((JComboBox)component).getSelectedItem();
            if (obj != null) {
                return new Integer(((Tag)obj).getValue());
            }
            return null;
        }
        if (this.getType() == 4) {
            return new Boolean(((JCheckBox)component).isSelected());
        }
        if (this.getType() == 3) {
            return ((ColorSelectorPanel)component).getValue();
        }
        return ((JTextField)component).getText();
    }

    public void setEditorValue(JComponent component, String str) {
        try {
            if (str == null) {
                return;
            }
            if (this.getType() == 1) {
                ((JNumberField)component).setValue(Double.parseDouble(str));
            } else if (this.getType() == 6) {
                ((JNumberField)component).setValue(Integer.parseInt(str));
            } else if (this.getType() == 2) {
                for (int i = 0; i < this.getTags().size(); ++i) {
                    Tag t = (Tag)this.getTags().elementAt(i);
                    if (!t.getName().equals(str)) continue;
                    ((JComboBox)component).setSelectedIndex(i);
                    return;
                }
            } else if (this.getType() == 5) {
                for (int i = 0; i < this.getTags().size(); ++i) {
                    Tag t = (Tag)this.getTags().elementAt(i);
                    if (!(t.getValue() + "").equals(str)) continue;
                    ((JComboBox)component).setSelectedIndex(i);
                    return;
                }
            } else if (this.getType() == 4) {
                ((JCheckBox)component).setSelected(str.equals("true"));
            } else if (this.getType() == 3) {
                ((ColorSelectorPanel)component).setValue(str);
            } else {
                ((JTextField)component).setText(str);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

