/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;

public class InsertElementOperation
implements UndoOperation {
    private ReportElement element = null;
    private JReportFrame jrf = null;

    public InsertElementOperation(JReportFrame jrf, ReportElement element) {
        this.element = element;
        this.jrf = jrf;
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getReport().getElements().remove(this.element);
        this.jrf.getSelectedElements().remove(this.element);
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.element, 1));
        this.jrf.getReportPanel().repaint();
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.getReport().getElements().addElement(this.element);
        this.jrf.setSelectedElement(this.element);
        this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, this.element, 2));
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "insert element";
    }
}

