/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import de.muntjak.tinylookandfeel.TinyCheckBoxIcon;
import de.muntjak.tinylookandfeel.controlpanel.ControlPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalCheckBoxUI;

public class TinyCheckBoxUI
extends MetalCheckBoxUI {
    private static final TinyCheckBoxUI checkBoxUI = new TinyCheckBoxUI();
    static TinyCheckBoxIcon skinnedIcon = new TinyCheckBoxIcon();
    static BasicStroke focusStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 1.0f);

    public static ComponentUI createUI(JComponent c) {
        return checkBoxUI;
    }

    public void installDefaults(AbstractButton button) {
        super.installDefaults(button);
        this.icon = skinnedIcon;
        button.setRolloverEnabled(true);
        if (!ControlPanel.isInstantiated) {
            return;
        }
        button.setForeground(Theme.checkFontColor[Theme.style].getColor());
    }

    protected void paintFocus(Graphics g, Rectangle t, Dimension arg2) {
        if (!Theme.buttonFocus[Theme.style]) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.black);
        g2d.setStroke(focusStroke);
        int x1 = t.x - 1;
        int y1 = t.y - 1;
        int x2 = x1 + t.width + 1;
        int y2 = y1 + t.height + 1;
        g2d.drawLine(x1, y1, x2, y1);
        g2d.drawLine(x1, y1, x1, y2);
        g2d.drawLine(x1, y2, x2, y2);
        g2d.drawLine(x2, y1, x2, y2);
    }
}

