/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JRFileSystemDataSource
implements JRDataSource {
    File[] files = null;
    int index = -1;

    public JRFileSystemDataSource(String path) {
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            this.files = dir.listFiles();
        }
    }

    public JRFileSystemDataSource() {
        this(".");
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.files != null && this.index < this.files.length;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        File f = this.files[this.index];
        if (f == null) {
            return null;
        }
        if (jrField.getName().equals("FILENAME")) {
            return f.getName();
        }
        if (jrField.getName().equals("IS_DIRECTORY")) {
            return new Boolean(f.isDirectory());
        }
        if (jrField.getName().equals("SIZE")) {
            return new Long(f.length());
        }
        return null;
    }
}

