/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.Group;
import it.businesslogic.ireport.JRVariable;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextFieldReportElement;
import it.businesslogic.ireport.gui.JRGroupDialog;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class GroupsDialog
extends JDialog {
    private JReportFrame jReportFrame = null;
    private JButton jButtonDeleteGroup;
    private JButton jButtonModifyGroup;
    private JButton jButtonMoveDownGroup;
    private JButton jButtonMoveUpGroup;
    private JButton jButtonNewGroup;
    private JPanel jPanelButtons;
    private JPanel jPanelFields;
    private JScrollPane jScrollPane3;
    private JTable jTableGroups;

    public GroupsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setSize(420, 250);
        Misc.centerFrame(this);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableGroups.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GroupsDialog.this.jTableGroupsListSelectionValueChanged(e);
            }
        });
    }

    public void jTableGroupsListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableGroups.getSelectedRowCount() == 1 && this.jTableGroups.getRowCount() > 1) {
            int row = this.jTableGroups.getSelectedRows()[0];
            this.jButtonMoveDownGroup.setEnabled(row != this.jTableGroups.getRowCount() - 1);
            this.jButtonMoveUpGroup.setEnabled(row != 0);
        } else {
            this.jButtonMoveDownGroup.setEnabled(false);
            this.jButtonMoveUpGroup.setEnabled(false);
        }
        if (this.jTableGroups.getSelectedRowCount() > 0) {
            this.jButtonModifyGroup.setEnabled(true);
            this.jButtonDeleteGroup.setEnabled(true);
        } else {
            this.jButtonModifyGroup.setEnabled(false);
            this.jButtonDeleteGroup.setEnabled(false);
        }
    }

    public void updateGroups() {
        if (this.jReportFrame == null) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableGroups.getModel();
        dtm.setRowCount(0);
        Iterator i = this.jReportFrame.getReport().getGroups().iterator();
        while (i.hasNext()) {
            Group group = (Group)i.next();
            Vector<Group> row = new Vector<Group>();
            row.addElement(group);
            dtm.addRow(row);
        }
    }

    private void initComponents() {
        this.jPanelFields = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.jTableGroups = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewGroup = new JButton();
        this.jButtonModifyGroup = new JButton();
        this.jButtonMoveUpGroup = new JButton();
        this.jButtonMoveDownGroup = new JButton();
        this.jButtonDeleteGroup = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                GroupsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelFields.setLayout(new BorderLayout());
        this.jScrollPane3.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setFont(new Font("Dialog", 0, 11));
        this.jTableGroups.setFont(new Font("Dialog", 0, 11));
        this.jTableGroups.setModel(new DefaultTableModel(new Object[0][], new String[]{"Group name"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane3.setViewportView(this.jTableGroups);
        this.jPanelFields.add((Component)this.jScrollPane3, "Center");
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jButtonNewGroup.setFont(new Font("Dialog", 0, 11));
        this.jButtonNewGroup.setText("New");
        this.jButtonNewGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonNewGroupActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonNewGroup, gridBagConstraints);
        this.jButtonModifyGroup.setFont(new Font("Dialog", 0, 11));
        this.jButtonModifyGroup.setText("Modify");
        this.jButtonModifyGroup.setEnabled(false);
        this.jButtonModifyGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonModifyGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModifyGroup, gridBagConstraints);
        this.jButtonMoveUpGroup.setFont(new Font("Dialog", 0, 11));
        this.jButtonMoveUpGroup.setText("Move Up");
        this.jButtonMoveUpGroup.setEnabled(false);
        this.jButtonMoveUpGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonMoveUpGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonMoveUpGroup, gridBagConstraints);
        this.jButtonMoveDownGroup.setFont(new Font("Dialog", 0, 11));
        this.jButtonMoveDownGroup.setText("Move Down");
        this.jButtonMoveDownGroup.setEnabled(false);
        this.jButtonMoveDownGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonMoveDownGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonMoveDownGroup, gridBagConstraints);
        this.jButtonDeleteGroup.setFont(new Font("Dialog", 0, 11));
        this.jButtonDeleteGroup.setText("Delete");
        this.jButtonDeleteGroup.setEnabled(false);
        this.jButtonDeleteGroup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GroupsDialog.this.jButtonDeleteGroupActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDeleteGroup, gridBagConstraints);
        this.jPanelFields.add((Component)this.jPanelButtons, "East");
        this.getContentPane().add((Component)this.jPanelFields, "Center");
        this.pack();
    }

    private void jButtonMoveDownGroupActionPerformed(ActionEvent evt) {
        if (this.jTableGroups.getSelectedRows().length == 1) {
            int[] rows = this.jTableGroups.getSelectedRows();
            Group grp = (Group)this.jTableGroups.getValueAt(rows[0], 0);
            this.getJReportFrame().getReport().moveGroup(grp, 1);
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
            for (int i = 0; i <= this.jTableGroups.getRowCount() - 1; ++i) {
                if (grp != (Group)this.jTableGroups.getValueAt(i, 0)) continue;
                this.jTableGroups.changeSelection(i, 0, true, false);
                break;
            }
        }
    }

    private void jButtonMoveUpGroupActionPerformed(ActionEvent evt) {
        if (this.jTableGroups.getSelectedRows().length == 1) {
            int[] rows = this.jTableGroups.getSelectedRows();
            Group grp = (Group)this.jTableGroups.getValueAt(rows[0], 0);
            this.getJReportFrame().getReport().moveGroup(grp, -1);
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
            for (int i = 0; i <= this.jTableGroups.getRowCount() - 1; ++i) {
                if (grp != (Group)this.jTableGroups.getValueAt(i, 0)) continue;
                this.jTableGroups.changeSelection(i, 0, true, false);
                break;
            }
        }
    }

    private void jButtonDeleteGroupActionPerformed(ActionEvent evt) {
        int[] rows = this.jTableGroups.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            Enumeration e = this.getJReportFrame().getReport().getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (!re.printWhenGroupChanges.equals("" + (Group)this.jTableGroups.getValueAt(rows[i], 0))) continue;
                re.printWhenGroupChanges = "";
            }
            e = this.getJReportFrame().getReport().getVariables().elements();
            while (e.hasMoreElements()) {
                JRVariable var = (JRVariable)e.nextElement();
                if (!var.getResetType().equals("Group") || !var.getResetGroup().equals("" + (Group)this.jTableGroups.getValueAt(rows[i], 0))) continue;
                var.setResetType("Report");
                var.setResetGroup("");
            }
            this.getJReportFrame().getReport().delGroup((Group)this.jTableGroups.getValueAt(rows[i], 0));
        }
        this.updateGroups();
        this.getJReportFrame().checkSelection(false);
        ((MainFrame)this.getParent()).getBandsDialog().updateBands();
        ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
        this.getJReportFrame().setIsDocDirty(true);
        this.getJReportFrame().repaint();
    }

    private void jButtonModifyGroupActionPerformed(ActionEvent evt) {
        Group group = (Group)this.jTableGroups.getValueAt(this.jTableGroups.getSelectedRow(), 0);
        JRGroupDialog jrpd = new JRGroupDialog(this.getJReportFrame(), true);
        jrpd.setGroup(group);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            String oldName = group.getName();
            group.setName(jrpd.getGroupName());
            group.setGroupExpression(jrpd.getExpression());
            group.setIsReprintHeaderOnEachPage(jrpd.isPrintHeaderEachPage());
            group.setIsResetPageNumber(jrpd.isResetPageNumber());
            group.setIsStartNewColumn(jrpd.isStartNewColumn());
            group.setIsStartNewPage(jrpd.isStartNewPage());
            group.setMinHeightToStartNewPage(jrpd.getMinHeightStartNewPage());
            group.getGroupHeader().setName(group.getName() + "Header");
            group.getGroupFooter().setName(group.getName() + "Footer");
            group.getGroupHeader().setHeight(jrpd.getHeaderBandHeight());
            group.getGroupFooter().setHeight(jrpd.getFooterBandHeight());
            Enumeration e = this.getJReportFrame().getReport().getVariables().elements();
            while (e.hasMoreElements()) {
                JRVariable var = (JRVariable)e.nextElement();
                if (var.getResetGroup() == null || !var.getResetGroup().equals(oldName)) continue;
                var.setResetGroup(group.getName());
            }
            e = this.getJReportFrame().getReport().getElements().elements();
            while (e.hasMoreElements()) {
                ReportElement re = (ReportElement)e.nextElement();
                if (re.printWhenGroupChanges.equals(oldName)) {
                    re.printWhenGroupChanges = group.getName();
                }
                if (!(re instanceof TextFieldReportElement) || !((TextFieldReportElement)re).getGroup().equals(oldName)) continue;
                ((TextFieldReportElement)re).setGroup(group.getName());
            }
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateSelection();
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
        }
    }

    private void jButtonNewGroupActionPerformed(ActionEvent evt) {
        JRGroupDialog jrpd = new JRGroupDialog(this.getJReportFrame(), true);
        jrpd.show();
        if (jrpd.getDialogResult() == 0) {
            Group g = new Group(this.getJReportFrame().getReport(), jrpd.getGroupName());
            g.setGroupExpression(jrpd.getExpression());
            g.setIsReprintHeaderOnEachPage(jrpd.isPrintHeaderEachPage());
            g.setIsResetPageNumber(jrpd.isResetPageNumber());
            g.setIsStartNewColumn(jrpd.isStartNewColumn());
            g.setIsStartNewPage(jrpd.isStartNewPage());
            g.setMinHeightToStartNewPage(jrpd.getMinHeightStartNewPage());
            g.getGroupHeader().setHeight(jrpd.getHeaderBandHeight());
            g.getGroupFooter().setHeight(jrpd.getFooterBandHeight());
            this.getJReportFrame().getReport().addGroup(g);
            this.getJReportFrame().setIsDocDirty(true);
            this.getJReportFrame().repaint();
            this.updateGroups();
            ((MainFrame)this.getParent()).getBandsDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateBands();
            ((MainFrame)this.getParent()).getElementPropertiesDialog().updateGroups();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new GroupsDialog((Frame)new JFrame(), true).show();
    }

    public JReportFrame getJReportFrame() {
        return this.jReportFrame;
    }

    public void setJReportFrame(JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        if (jReportFrame == null) {
            this.setVisible(false);
            return;
        }
        this.setTitle(jReportFrame.getReport().getName() + " groups...");
        if (this.isVisible()) {
            this.updateGroups();
        }
    }

    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        super.setVisible(visible);
        if (visible) {
            this.setJReportFrame(this.jReportFrame);
        }
    }
}

