/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.undo;

import it.businesslogic.ireport.Band;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.UndoOperation;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.undo.ElementTransformation;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TransformElementsOperation
implements UndoOperation {
    private Vector transformations = new Vector();
    private JReportFrame jrf = null;

    public TransformElementsOperation(JReportFrame jrf) {
        this.jrf = jrf;
    }

    public void redo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        Enumeration e = this.getTransformations().elements();
        while (e.hasMoreElements()) {
            ElementTransformation pe = (ElementTransformation)e.nextElement();
            ReportElement element = pe.element;
            this.jrf.addSelectedElement(element);
            element.getPosition().x = pe.newBounds.x;
            element.getPosition().y = pe.newBounds.y;
            element.setWidth(pe.newBounds.width);
            element.setHeight(pe.newBounds.height);
            element.updateBounds();
            if (pe.newBand != null) {
                element.setBand(pe.newBand);
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
            this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        }
        this.jrf.getReportPanel().repaint();
    }

    public void undo() {
        if (this.jrf == null) {
            return;
        }
        this.jrf.setSelectedElement(null);
        for (int i = this.getTransformations().size() - 1; i >= 0; --i) {
            ElementTransformation pe = (ElementTransformation)this.getTransformations().get(i);
            ReportElement element = pe.element;
            this.jrf.addSelectedElement(element);
            element.getPosition().x = pe.oldBounds.x;
            element.getPosition().y = pe.oldBounds.y;
            element.setWidth(pe.oldBounds.width);
            element.setHeight(pe.oldBounds.height);
            element.updateBounds();
            if (pe.oldBand != null) {
                element.setBand(pe.oldBand);
            }
            this.jrf.fireReportListenerReportElementsChanged(new ReportElementChangedEvent(this.jrf, element, 3));
            this.jrf.getMainFrame().getElementPropertiesDialog().updateSelection();
        }
        this.jrf.getReportPanel().repaint();
    }

    public String toString() {
        return "transformation";
    }

    public Vector getTransformations() {
        return this.transformations;
    }

    public void setTransformations(Vector transformations) {
        this.transformations = transformations;
    }

    public void addElement(ReportElement element, Rectangle oldBounds, Rectangle newBounds) {
        this.addElement(element, oldBounds, newBounds, null, null);
    }

    public void addElement(ReportElement element, Rectangle oldBounds, Rectangle newBounds, Band oldBand, Band newBand) {
        ElementTransformation et = new ElementTransformation();
        et.element = element;
        et.oldBounds = oldBounds;
        et.newBounds = newBounds;
        et.newBand = newBand;
        et.oldBand = oldBand;
        this.getTransformations().add(et);
    }
}

