/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRClassGenerator;
import net.sf.jasperreports.engine.design.JRCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.util.JRClassLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JRJdtCompiler
implements JRCompiler {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$engine$design$JRJdtCompiler == null ? (class$net$sf$jasperreports$engine$design$JRJdtCompiler = JRJdtCompiler.class$("net.sf.jasperreports.engine.design.JRJdtCompiler")) : class$net$sf$jasperreports$engine$design$JRJdtCompiler));
    private static ThreadLocal classFromBytesRef = new ThreadLocal();
    static /* synthetic */ Class class$net$sf$jasperreports$engine$design$JRJdtCompiler;
    static /* synthetic */ Class class$net$sf$jasperreports$engine$util$JRClassLoader;

    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        JasperReport jasperReport = null;
        Collection brokenRules = JRVerifier.verifyDesign(jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        String sourceCode = JRClassGenerator.generateClass(jasperDesign);
        String classpath = System.getProperty("jasper.reports.compile.class.path");
        if (classpath == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
        }
        try {
            ClassFile[] classFiles = new ClassFile[1];
            String compileErrors = this.compileClass(sourceCode, jasperDesign.getName(), classFiles);
            if (compileErrors != null) {
                throw new JRException("Errors were encountered when compiling report expressions class file:\n" + compileErrors);
            }
            jasperReport = new JasperReport(jasperDesign, this.getClass().getName(), classFiles[0].getBytes());
        }
        catch (JRException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException("Error compiling report design.", e);
        }
        return jasperReport;
    }

    public JRCalculator loadCalculator(JasperReport jasperReport) throws JRException {
        JRCalculator calculator = null;
        try {
            Class clazz = JRClassLoader.loadClassFromBytes(jasperReport.getName(), (byte[])jasperReport.getCompileData());
            classFromBytesRef.set(clazz);
            calculator = (JRCalculator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new JRException("Error loading expression class : " + jasperReport.getName(), e);
        }
        return calculator;
    }

    private String compileClass(final String sourceCode, final String targetClassName, final ClassFile[] classFiles) {
        final ClassLoader classLoader = this.getClassLoader();
        final StringBuffer problemBuffer = new StringBuffer();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < compoundTypeName.length; ++i) {
                    result = result + sep;
                    result = result + new String(compoundTypeName[i]);
                    sep = ".";
                }
                return this.findType(result);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String result = "";
                String sep = "";
                for (int i = 0; i < packageName.length; ++i) {
                    result = result + sep;
                    result = result + new String(packageName[i]);
                    sep = ".";
                }
                result = result + sep;
                result = result + new String(typeName);
                return this.findType(result);
            }

            private NameEnvironmentAnswer findType(String className) {
                try {
                    if (className.equals(targetClassName)) {
                        class CompilationUnit
                        implements ICompilationUnit {
                            private String sourceCode;
                            private String className;

                            public CompilationUnit(String sourceCode, String className) {
                                this.sourceCode = sourceCode;
                                this.className = className;
                            }

                            public char[] getFileName() {
                                return this.className.toCharArray();
                            }

                            public char[] getContents() {
                                return this.sourceCode.toCharArray();
                            }

                            public char[] getMainTypeName() {
                                return this.className.toCharArray();
                            }

                            public char[][] getPackageName() {
                                return new char[0][0];
                            }
                        }
                        CompilationUnit compilationUnit = new CompilationUnit(sourceCode, className);
                        return new NameEnvironmentAnswer((ICompilationUnit)compilationUnit);
                    }
                    String resourceName = className.replace('.', '/') + ".class";
                    InputStream is = classLoader.getResourceAsStream(resourceName);
                    if (is != null) {
                        int count;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        return new NameEnvironmentAnswer((IBinaryType)classFileReader);
                    }
                }
                catch (IOException exc) {
                    log.error((Object)"Compilation error", (Throwable)exc);
                }
                catch (ClassFormatException exc) {
                    log.error((Object)"Compilation error", (Throwable)exc);
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (result.equals(targetClassName)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String str;
                String result = "";
                String sep = "";
                if (parentPackageName != null) {
                    for (int i = 0; i < parentPackageName.length; ++i) {
                        result = result + sep;
                        String str2 = new String(parentPackageName[i]);
                        result = result + str2;
                        sep = ".";
                    }
                }
                if (Character.isUpperCase((str = new String(packageName)).charAt(0)) && !this.isPackage(result)) {
                    return false;
                }
                result = result + sep;
                result = result + str;
                return this.isPackage(result);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                int i;
                if (result.hasErrors()) {
                    IProblem[] problems = result.getErrors();
                    for (i = 0; i < problems.length; ++i) {
                        IProblem problem = problems[i];
                        problemBuffer.append(i + 1);
                        problemBuffer.append(". ");
                        problemBuffer.append(problem.getMessage());
                        if (problem.getSourceStart() >= 0 && problem.getSourceEnd() >= 0) {
                            int j;
                            int problemStartIndex = sourceCode.lastIndexOf("\n", problem.getSourceStart()) + 1;
                            int problemEndIndex = sourceCode.indexOf("\n", problem.getSourceEnd());
                            if (problemEndIndex < 0) {
                                problemEndIndex = sourceCode.length();
                            }
                            problemBuffer.append("\n");
                            problemBuffer.append(sourceCode.substring(problemStartIndex, problemEndIndex));
                            problemBuffer.append("\n");
                            for (j = problemStartIndex; j < problem.getSourceStart(); ++j) {
                                problemBuffer.append(" ");
                            }
                            if (problem.getSourceStart() == problem.getSourceEnd()) {
                                problemBuffer.append("^");
                            } else {
                                problemBuffer.append("<");
                                for (j = problem.getSourceStart() + 1; j < problem.getSourceEnd(); ++j) {
                                    problemBuffer.append("-");
                                }
                                problemBuffer.append(">");
                            }
                        }
                        problemBuffer.append("\n");
                    }
                    problemBuffer.append(problems.length);
                    problemBuffer.append(" errors\n");
                }
                if (problemBuffer.length() == 0) {
                    ClassFile[] resultClassFiles = result.getClassFiles();
                    for (i = 0; i < resultClassFiles.length; ++i) {
                        classFiles[0] = resultClassFiles[i];
                    }
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[]{new CompilationUnit(sourceCode, targetClassName)};
        Compiler compiler = new Compiler(env, policy, settings, requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (problemBuffer.length() > 0) {
            return problemBuffer.toString();
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class.forName((class$net$sf$jasperreports$engine$design$JRJdtCompiler == null ? (class$net$sf$jasperreports$engine$design$JRJdtCompiler = JRJdtCompiler.class$("net.sf.jasperreports.engine.design.JRJdtCompiler")) : class$net$sf$jasperreports$engine$design$JRJdtCompiler).getName(), true, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException e) {
                classLoader = null;
            }
        }
        if (classLoader == null) {
            classLoader = (class$net$sf$jasperreports$engine$util$JRClassLoader == null ? (class$net$sf$jasperreports$engine$util$JRClassLoader = JRJdtCompiler.class$("net.sf.jasperreports.engine.util.JRClassLoader")) : class$net$sf$jasperreports$engine$util$JRClassLoader).getClassLoader();
        }
        return classLoader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

