/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.fill.JRComparableIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRDefaultIncrementerFactory;
import net.sf.jasperreports.engine.fill.JRFloatAverageIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatCountIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatStandardDeviationIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatSumIncrementer;
import net.sf.jasperreports.engine.fill.JRFloatVarianceIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementer;
import net.sf.jasperreports.engine.fill.JRIncrementerFactory;

public class JRFloatIncrementerFactory
implements JRIncrementerFactory {
    protected static final Float ZERO = new Float(0.0f);
    private static JRFloatIncrementerFactory mainInstance = new JRFloatIncrementerFactory();

    private JRFloatIncrementerFactory() {
    }

    public static JRFloatIncrementerFactory getInstance() {
        return mainInstance;
    }

    public JRIncrementer getIncrementer(byte calculation) {
        JRIncrementer incrementer = null;
        switch (calculation) {
            case 1: {
                incrementer = JRFloatCountIncrementer.getInstance();
                break;
            }
            case 2: {
                incrementer = JRFloatSumIncrementer.getInstance();
                break;
            }
            case 3: {
                incrementer = JRFloatAverageIncrementer.getInstance();
                break;
            }
            case 4: 
            case 5: {
                incrementer = JRComparableIncrementerFactory.getInstance().getIncrementer(calculation);
                break;
            }
            case 6: {
                incrementer = JRFloatStandardDeviationIncrementer.getInstance();
                break;
            }
            case 7: {
                incrementer = JRFloatVarianceIncrementer.getInstance();
                break;
            }
            default: {
                incrementer = JRDefaultIncrementerFactory.getInstance().getIncrementer(calculation);
            }
        }
        return incrementer;
    }
}

