/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.xml.JRXmlConstants;

public class JRXmlWriter {
    private JRReport report = null;
    private String encoding = null;
    private StringBuffer sb = null;
    private Map fontsMap = new HashMap();
    private static final int colorMask = Integer.parseInt("FFFFFF", 16);

    protected JRXmlWriter(JRReport report, String encoding) {
        this.report = report;
        this.encoding = encoding;
    }

    public static String writeReport(JRReport report, String encoding) throws JRException {
        JRXmlWriter writer = new JRXmlWriter(report, encoding);
        return writer.writeReport();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeReport(JRReport report, String destFileName, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        FileOutputStream fos = null;
        try {
            try {
                byte[] bytes = xmlString.getBytes(encoding);
                fos = new FileOutputStream(destFileName);
                fos.write(bytes, 0, bytes.length);
                fos.flush();
            }
            catch (IOException e) {
                throw new JRException("Error writing to file : " + destFileName, e);
            }
            Object var7_7 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fos.close();
        return;
    }

    public static void writeReport(JRReport report, OutputStream outputStream, String encoding) throws JRException {
        String xmlString = JRXmlWriter.writeReport(report, encoding);
        try {
            byte[] bytes = xmlString.getBytes(encoding);
            outputStream.write(bytes, 0, bytes.length);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    protected String writeReport() throws JRException {
        JRGroup[] groups;
        JRVariable[] variables;
        JRField[] fields;
        JRParameter[] parameters;
        JRReportFont[] fonts;
        String[] imports;
        this.sb = new StringBuffer();
        this.sb.append("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.sb.append("<!DOCTYPE jasperReport PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"http://jasperreports.sourceforge.net/dtds/jasperreport.dtd\">\n");
        this.sb.append("\n");
        this.sb.append("<jasperReport name=\"");
        this.sb.append(this.report.getName());
        this.sb.append("\"");
        if (this.report.getColumnCount() != 1) {
            this.sb.append(" columnCount=\"");
            this.sb.append(this.report.getColumnCount());
            this.sb.append("\"");
        }
        if (this.report.getPrintOrder() != 1) {
            this.sb.append(" printOrder=\"");
            this.sb.append((String)JRXmlConstants.getPrintOrderMap().get(new Byte(this.report.getPrintOrder())));
            this.sb.append("\"");
        }
        this.sb.append(" pageWidth=\"");
        this.sb.append(this.report.getPageWidth());
        this.sb.append("\"");
        this.sb.append(" pageHeight=\"");
        this.sb.append(this.report.getPageHeight());
        this.sb.append("\"");
        if (this.report.getOrientation() != 1) {
            this.sb.append(" orientation=\"");
            this.sb.append((String)JRXmlConstants.getOrientationMap().get(new Byte(this.report.getOrientation())));
            this.sb.append("\"");
        }
        if (this.report.getWhenNoDataType() != 1) {
            this.sb.append(" whenNoDataType=\"");
            this.sb.append((String)JRXmlConstants.getWhenNoDataTypeMap().get(new Byte(this.report.getWhenNoDataType())));
            this.sb.append("\"");
        }
        this.sb.append(" columnWidth=\"");
        this.sb.append(this.report.getColumnWidth());
        this.sb.append("\"");
        if (this.report.getColumnSpacing() != 0) {
            this.sb.append(" columnSpacing=\"");
            this.sb.append(this.report.getColumnSpacing());
            this.sb.append("\"");
        }
        this.sb.append(" leftMargin=\"");
        this.sb.append(this.report.getLeftMargin());
        this.sb.append("\"");
        this.sb.append(" rightMargin=\"");
        this.sb.append(this.report.getRightMargin());
        this.sb.append("\"");
        this.sb.append(" topMargin=\"");
        this.sb.append(this.report.getTopMargin());
        this.sb.append("\"");
        this.sb.append(" bottomMargin=\"");
        this.sb.append(this.report.getBottomMargin());
        this.sb.append("\"");
        if (this.report.isTitleNewPage()) {
            this.sb.append(" isTitleNewPage=\"");
            this.sb.append(this.report.isTitleNewPage());
            this.sb.append("\"");
        }
        if (this.report.isSummaryNewPage()) {
            this.sb.append(" isSummaryNewPage=\"");
            this.sb.append(this.report.isSummaryNewPage());
            this.sb.append("\"");
        }
        if (this.report.isFloatColumnFooter()) {
            this.sb.append(" isFloatColumnFooter=\"");
            this.sb.append(this.report.isFloatColumnFooter());
            this.sb.append("\"");
        }
        if (this.report.getScriptletClass() != null) {
            this.sb.append(" scriptletClass=\"");
            this.sb.append(this.report.getScriptletClass());
            this.sb.append("\"");
        }
        if (this.report.getResourceBundle() != null) {
            this.sb.append(" resourceBundle=\"");
            this.sb.append(this.report.getResourceBundle());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        String[] propertyNames = this.report.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                String value = this.report.getProperty(propertyNames[i]);
                if (value == null) continue;
                this.sb.append("\t<property name=\"");
                this.sb.append(propertyNames[i]);
                this.sb.append("\" value=\"");
                this.sb.append(JRStringUtil.xmlEncode(value));
                this.sb.append("\"/>\n");
            }
        }
        if ((imports = this.report.getImports()) != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.sb.append("\t<import value=\"");
                this.sb.append(JRStringUtil.xmlEncode(value));
                this.sb.append("\"/>\n");
            }
        }
        if ((fonts = this.report.getFonts()) != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.writeReportFont(fonts[i]);
            }
        }
        if ((parameters = this.report.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i]);
            }
        }
        if (this.report.getQuery() != null) {
            this.writeQuery(this.report.getQuery());
        }
        if ((fields = this.report.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i]);
            }
        }
        if ((variables = this.report.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i]);
            }
        }
        if ((groups = this.report.getGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                this.writeGroup(groups[i]);
            }
        }
        if (this.report.getBackground() != null) {
            this.sb.append("\t<background>\n");
            this.writeBand(this.report.getBackground());
            this.sb.append("\t</background>\n");
        }
        if (this.report.getTitle() != null) {
            this.sb.append("\t<title>\n");
            this.writeBand(this.report.getTitle());
            this.sb.append("\t</title>\n");
        }
        if (this.report.getPageHeader() != null) {
            this.sb.append("\t<pageHeader>\n");
            this.writeBand(this.report.getPageHeader());
            this.sb.append("\t</pageHeader>\n");
        }
        if (this.report.getColumnHeader() != null) {
            this.sb.append("\t<columnHeader>\n");
            this.writeBand(this.report.getColumnHeader());
            this.sb.append("\t</columnHeader>\n");
        }
        if (this.report.getDetail() != null) {
            this.sb.append("\t<detail>\n");
            this.writeBand(this.report.getDetail());
            this.sb.append("\t</detail>\n");
        }
        if (this.report.getColumnFooter() != null) {
            this.sb.append("\t<columnFooter>\n");
            this.writeBand(this.report.getColumnFooter());
            this.sb.append("\t</columnFooter>\n");
        }
        if (this.report.getPageFooter() != null) {
            this.sb.append("\t<pageFooter>\n");
            this.writeBand(this.report.getPageFooter());
            this.sb.append("\t</pageFooter>\n");
        }
        if (this.report.getLastPageFooter() != null) {
            this.sb.append("\t<lastPageFooter>\n");
            this.writeBand(this.report.getLastPageFooter());
            this.sb.append("\t</lastPageFooter>\n");
        }
        if (this.report.getSummary() != null) {
            this.sb.append("\t<summary>\n");
            this.writeBand(this.report.getSummary());
            this.sb.append("\t</summary>\n");
        }
        this.sb.append("</jasperReport>\n");
        return this.sb.toString();
    }

    private void writeReportFont(JRReportFont font) {
        this.sb.append("\t<reportFont");
        this.sb.append(" name=\"");
        this.sb.append(font.getName());
        this.sb.append("\"");
        this.sb.append(" isDefault=\"");
        this.sb.append(font.isDefault());
        this.sb.append("\"");
        this.sb.append(" fontName=\"");
        this.sb.append(font.getFontName());
        this.sb.append("\"");
        this.sb.append(" size=\"");
        this.sb.append(font.getSize());
        this.sb.append("\"");
        this.sb.append(" isBold=\"");
        this.sb.append(font.isBold());
        this.sb.append("\"");
        this.sb.append(" isItalic=\"");
        this.sb.append(font.isItalic());
        this.sb.append("\"");
        this.sb.append(" isUnderline=\"");
        this.sb.append(font.isUnderline());
        this.sb.append("\"");
        this.sb.append(" isStrikeThrough=\"");
        this.sb.append(font.isStrikeThrough());
        this.sb.append("\"");
        this.sb.append(" pdfFontName=\"");
        this.sb.append(font.getPdfFontName());
        this.sb.append("\"");
        this.sb.append(" pdfEncoding=\"");
        this.sb.append(font.getPdfEncoding());
        this.sb.append("\"");
        this.sb.append(" isPdfEmbedded=\"");
        this.sb.append(font.isPdfEmbedded());
        this.sb.append("\"");
        this.sb.append("/>\n");
    }

    private void writeParameter(JRParameter parameter) {
        this.sb.append("\t<parameter");
        this.sb.append(" name=\"");
        this.sb.append(parameter.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(parameter.getValueClassName());
        this.sb.append("\"");
        if (!parameter.isForPrompting()) {
            this.sb.append(" isForPrompting=\"");
            this.sb.append(parameter.isForPrompting());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (parameter.getDescription() != null) {
            this.sb.append("\t\t<parameterDescription><![CDATA[");
            this.sb.append(parameter.getDescription());
            this.sb.append("]]></parameterDescription>\n");
        }
        if (parameter.getDefaultValueExpression() != null) {
            this.sb.append("\t\t<defaultValueExpression><![CDATA[");
            this.sb.append(parameter.getDefaultValueExpression().getText());
            this.sb.append("]]></defaultValueExpression>\n");
        }
        this.sb.append("\t</parameter>\n");
    }

    private void writeQuery(JRQuery query) {
        this.sb.append("\t<queryString><![CDATA[");
        this.sb.append(query.getText());
        this.sb.append("]]></queryString>\n");
    }

    private void writeField(JRField field) {
        this.sb.append("\t<field");
        this.sb.append(" name=\"");
        this.sb.append(field.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(field.getValueClassName());
        this.sb.append("\"");
        this.sb.append(">\n");
        if (field.getDescription() != null) {
            this.sb.append("\t\t<fieldDescription><![CDATA[");
            this.sb.append(field.getDescription());
            this.sb.append("]]></fieldDescription>\n");
        }
        this.sb.append("\t</field>\n");
    }

    private void writeVariable(JRVariable variable) {
        this.sb.append("\t<variable");
        this.sb.append(" name=\"");
        this.sb.append(variable.getName());
        this.sb.append("\"");
        this.sb.append(" class=\"");
        this.sb.append(variable.getValueClassName());
        this.sb.append("\"");
        if (variable.getResetType() != 1) {
            this.sb.append(" resetType=\"");
            this.sb.append((String)JRXmlConstants.getResetTypeMap().get(new Byte(variable.getResetType())));
            this.sb.append("\"");
        }
        if (variable.getResetGroup() != null) {
            this.sb.append(" resetGroup=\"");
            this.sb.append(variable.getResetGroup().getName());
            this.sb.append("\"");
        }
        if (variable.getCalculation() != 0) {
            this.sb.append(" calculation=\"");
            this.sb.append((String)JRXmlConstants.getCalculationMap().get(new Byte(variable.getCalculation())));
            this.sb.append("\"");
        }
        if (variable.getIncrementerFactoryClassName() != null) {
            this.sb.append(" incrementerFactoryClass=\"");
            this.sb.append(variable.getIncrementerFactoryClassName());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (variable.getExpression() != null) {
            this.sb.append("\t\t<variableExpression><![CDATA[");
            this.sb.append(variable.getExpression().getText());
            this.sb.append("]]></variableExpression>\n");
        }
        if (variable.getInitialValueExpression() != null) {
            this.sb.append("\t\t<initialValueExpression><![CDATA[");
            this.sb.append(variable.getInitialValueExpression().getText());
            this.sb.append("]]></initialValueExpression>\n");
        }
        this.sb.append("\t</variable>\n");
    }

    private void writeGroup(JRGroup group) {
        this.sb.append("\t<group");
        this.sb.append(" name=\"");
        this.sb.append(group.getName());
        this.sb.append("\"");
        if (group.isStartNewColumn()) {
            this.sb.append(" isStartNewColumn=\"");
            this.sb.append(group.isStartNewColumn());
            this.sb.append("\"");
        }
        if (group.isStartNewPage()) {
            this.sb.append(" isStartNewPage=\"");
            this.sb.append(group.isStartNewPage());
            this.sb.append("\"");
        }
        if (group.isResetPageNumber()) {
            this.sb.append(" isResetPageNumber=\"");
            this.sb.append(group.isResetPageNumber());
            this.sb.append("\"");
        }
        if (group.isReprintHeaderOnEachPage()) {
            this.sb.append(" isReprintHeaderOnEachPage=\"");
            this.sb.append(group.isReprintHeaderOnEachPage());
            this.sb.append("\"");
        }
        if (group.getMinHeightToStartNewPage() > 0) {
            this.sb.append(" minHeightToStartNewPage=\"");
            this.sb.append(group.getMinHeightToStartNewPage());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (group.getExpression() != null) {
            this.sb.append("\t\t<groupExpression><![CDATA[");
            this.sb.append(group.getExpression().getText());
            this.sb.append("]]></groupExpression>\n");
        }
        if (group.getGroupHeader() != null) {
            this.sb.append("\t\t<groupHeader>\n");
            this.writeBand(group.getGroupHeader());
            this.sb.append("\t\t</groupHeader>\n");
        }
        if (group.getGroupFooter() != null) {
            this.sb.append("\t\t<groupFooter>\n");
            this.writeBand(group.getGroupFooter());
            this.sb.append("\t\t</groupFooter>\n");
        }
        this.sb.append("\t</group>\n");
    }

    private void writeBand(JRBand band) {
        List children;
        this.sb.append("\t\t<band");
        if (band.getHeight() > 0) {
            this.sb.append(" height=\"");
            this.sb.append(band.getHeight());
            this.sb.append("\"");
        }
        if (!band.isSplitAllowed()) {
            this.sb.append(" isSplitAllowed=\"");
            this.sb.append(band.isSplitAllowed());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        if (band.getPrintWhenExpression() != null) {
            this.sb.append("\t\t\t<printWhenExpression><![CDATA[");
            this.sb.append(band.getPrintWhenExpression().getText());
            this.sb.append("]]></printWhenExpression>\n");
        }
        if ((children = band.getChildren()) != null && children.size() > 0) {
            Object child = null;
            for (int i = 0; i < children.size(); ++i) {
                child = children.get(i);
                if (child instanceof JRElementGroup) {
                    this.writeElementGroup(child);
                    continue;
                }
                this.writeElement(child);
            }
        }
        this.sb.append("\t\t</band>\n");
    }

    private void writeElementGroup(JRElementGroup elementGroup) {
        this.sb.append("\t\t\t<elementGroup>\n");
        List children = elementGroup.getChildren();
        if (children != null && children.size() > 0) {
            Object child = null;
            for (int i = 0; i < children.size(); ++i) {
                child = children.get(i);
                if (child instanceof JRElementGroup) {
                    this.writeElementGroup(child);
                    continue;
                }
                this.writeElement(child);
            }
        }
        this.sb.append("\t\t\t</elementGroup>\n");
    }

    private void writeElement(JRElement element) {
        if (element instanceof JRLine) {
            this.writeLine((JRLine)element);
        } else if (element instanceof JRRectangle) {
            this.writeRectangle((JRRectangle)element);
        } else if (element instanceof JREllipse) {
            this.writeEllipse((JREllipse)element);
        } else if (element instanceof JRImage) {
            this.writeImage((JRImage)element);
        } else if (element instanceof JRStaticText) {
            this.writeStaticText((JRStaticText)element);
        } else if (element instanceof JRTextField) {
            this.writeTextField((JRTextField)element);
        } else if (element instanceof JRSubreport) {
            this.writeSubreport((JRSubreport)element);
        }
    }

    private void writeLine(JRLine line) {
        this.sb.append("\t\t\t<line");
        if (line.getDirection() != 1) {
            this.sb.append(" direction=\"");
            this.sb.append((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(line);
        this.writeGraphicElement(line);
        this.sb.append("\t\t\t</line>\n");
    }

    private void writeReportElement(JRElement element) {
        this.sb.append("\t\t\t\t<reportElement");
        if (element.getKey() != null) {
            this.sb.append(" key=\"");
            this.sb.append(element.getKey());
            this.sb.append("\"");
        }
        if (element.getPositionType() != 2) {
            this.sb.append(" positionType=\"");
            this.sb.append((String)JRXmlConstants.getPositionTypeMap().get(new Byte(element.getPositionType())));
            this.sb.append("\"");
        }
        if (element.getStretchType() != 0) {
            this.sb.append(" stretchType=\"");
            this.sb.append((String)JRXmlConstants.getStretchTypeMap().get(new Byte(element.getStretchType())));
            this.sb.append("\"");
        }
        if (!element.isPrintRepeatedValues()) {
            this.sb.append(" isPrintRepeatedValues=\"");
            this.sb.append(element.isPrintRepeatedValues());
            this.sb.append("\"");
        }
        if (element instanceof JRLine && element.getMode() != 1 || element instanceof JRRectangle && element.getMode() != 1 || element instanceof JREllipse && element.getMode() != 1 || element instanceof JRImage && element.getMode() != 2 || element instanceof JRTextElement && element.getMode() != 2 || element instanceof JRSubreport && element.getMode() != 2) {
            this.sb.append(" mode=\"");
            this.sb.append((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.sb.append("\"");
        }
        this.sb.append(" x=\"");
        this.sb.append(element.getX());
        this.sb.append("\"");
        this.sb.append(" y=\"");
        this.sb.append(element.getY());
        this.sb.append("\"");
        this.sb.append(" width=\"");
        this.sb.append(element.getWidth());
        this.sb.append("\"");
        this.sb.append(" height=\"");
        this.sb.append(element.getHeight());
        this.sb.append("\"");
        if (element.isRemoveLineWhenBlank()) {
            this.sb.append(" isRemoveLineWhenBlank=\"");
            this.sb.append(element.isRemoveLineWhenBlank());
            this.sb.append("\"");
        }
        if (element.isPrintInFirstWholeBand()) {
            this.sb.append(" isPrintInFirstWholeBand=\"");
            this.sb.append(element.isPrintInFirstWholeBand());
            this.sb.append("\"");
        }
        if (element.isPrintWhenDetailOverflows()) {
            this.sb.append(" isPrintWhenDetailOverflows=\"");
            this.sb.append(element.isPrintWhenDetailOverflows());
            this.sb.append("\"");
        }
        if (element.getPrintWhenGroupChanges() != null) {
            this.sb.append(" printWhenGroupChanges=\"");
            this.sb.append(element.getPrintWhenGroupChanges().getName());
            this.sb.append("\"");
        }
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.sb.append(" forecolor=\"#");
            this.sb.append(Integer.toHexString(element.getForecolor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.sb.append(" backcolor=\"#");
            this.sb.append(Integer.toHexString(element.getBackcolor().getRGB() & colorMask));
            this.sb.append("\"");
        }
        if (element.getPrintWhenExpression() != null) {
            this.sb.append(">\n");
            this.sb.append("\t\t\t\t\t<printWhenExpression><![CDATA[");
            this.sb.append(element.getPrintWhenExpression().getText());
            this.sb.append("]]></printWhenExpression>\n");
            this.sb.append("\t\t\t\t</reportElement>\n");
        } else {
            this.sb.append("/>\n");
        }
    }

    private void writeGraphicElement(JRGraphicElement element) {
        this.sb.append("\t\t\t\t<graphicElement");
        if (element instanceof JRLine && element.getPen() != 1 || element instanceof JRRectangle && element.getPen() != 1 || element instanceof JREllipse && element.getPen() != 1 || element instanceof JRImage && element.getPen() != 0) {
            this.sb.append(" pen=\"");
            this.sb.append((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.sb.append("\"");
        }
        if (element.getFill() != 1) {
            this.sb.append(" fill=\"");
            this.sb.append((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.sb.append("\"");
        }
        this.sb.append("/>\n");
    }

    private void writeRectangle(JRRectangle rectangle) {
        this.sb.append("\t\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.sb.append(" radius=\"");
            this.sb.append(rectangle.getRadius());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(rectangle);
        this.writeGraphicElement(rectangle);
        this.sb.append("\t\t\t</rectangle>\n");
    }

    private void writeEllipse(JREllipse ellipse) {
        this.sb.append("\t\t\t<ellipse>\n");
        this.writeReportElement(ellipse);
        this.writeGraphicElement(ellipse);
        this.sb.append("\t\t\t</ellipse>\n");
    }

    private void writeImage(JRImage image) {
        this.sb.append("\t\t\t<image");
        if (image.getScaleImage() != 3) {
            this.sb.append(" scaleImage=\"");
            this.sb.append((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.sb.append("\"");
        }
        if (image.getHorizontalAlignment() != 1) {
            this.sb.append(" hAlign=\"");
            this.sb.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(image.getHorizontalAlignment())));
            this.sb.append("\"");
        }
        if (image.getVerticalAlignment() != 1) {
            this.sb.append(" vAlign=\"");
            this.sb.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(image.getVerticalAlignment())));
            this.sb.append("\"");
        }
        if (!image.isUsingCache()) {
            this.sb.append(" isUsingCache=\"");
            this.sb.append(image.isUsingCache());
            this.sb.append("\"");
        }
        if (image.getEvaluationTime() != 1) {
            this.sb.append(" evaluationTime=\"");
            this.sb.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(image.getEvaluationTime())));
            this.sb.append("\"");
        }
        if (image.getEvaluationGroup() != null) {
            this.sb.append(" evaluationGroup=\"");
            this.sb.append(image.getEvaluationGroup().getName());
            this.sb.append("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.sb.append(" hyperlinkType=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.sb.append("\"");
        }
        if (image.getHyperlinkTarget() != 1) {
            this.sb.append(" hyperlinkTarget=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(image.getHyperlinkTarget())));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(image);
        this.writeBox(image.getBox());
        this.writeGraphicElement(image);
        if (image.getExpression() != null) {
            this.sb.append("\t\t\t\t<imageExpression");
            this.sb.append(" class=\"");
            this.sb.append(image.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(image.getExpression().getText());
            this.sb.append("]]></imageExpression>\n");
        }
        if (image.getAnchorNameExpression() != null) {
            this.sb.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sb.append(image.getAnchorNameExpression().getText());
            this.sb.append("]]></anchorNameExpression>\n");
        }
        if (image.getHyperlinkReferenceExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sb.append(image.getHyperlinkReferenceExpression().getText());
            this.sb.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (image.getHyperlinkAnchorExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sb.append(image.getHyperlinkAnchorExpression().getText());
            this.sb.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (image.getHyperlinkPageExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sb.append(image.getHyperlinkPageExpression().getText());
            this.sb.append("]]></hyperlinkPageExpression>\n");
        }
        this.sb.append("\t\t\t</image>\n");
    }

    private void writeBox(JRBox box) {
        if (box != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (box.getBorder() != 0) {
                tmpBuffer.append(" border=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getBorderColor() != null) {
                tmpBuffer.append(" borderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getPadding() > 0) {
                tmpBuffer.append(" padding=\"");
                tmpBuffer.append(box.getPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorder() != null) {
                tmpBuffer.append(" topBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnTopBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorderColor() != null) {
                tmpBuffer.append(" topBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnTopBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopPadding() != null) {
                tmpBuffer.append(" topPadding=\"");
                tmpBuffer.append(box.getOwnTopPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorder() != null) {
                tmpBuffer.append(" leftBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnLeftBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorderColor() != null) {
                tmpBuffer.append(" leftBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnLeftBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftPadding() != null) {
                tmpBuffer.append(" leftPadding=\"");
                tmpBuffer.append(box.getOwnLeftPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorder() != null) {
                tmpBuffer.append(" bottomBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnBottomBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorderColor() != null) {
                tmpBuffer.append(" bottomBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnBottomBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomPadding() != null) {
                tmpBuffer.append(" bottomPadding=\"");
                tmpBuffer.append(box.getOwnBottomPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorder() != null) {
                tmpBuffer.append(" rightBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnRightBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorderColor() != null) {
                tmpBuffer.append(" rightBorderColor=\"#");
                tmpBuffer.append(Integer.toHexString(box.getOwnRightBorderColor().getRGB() & colorMask));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightPadding() != null) {
                tmpBuffer.append(" rightPadding=\"");
                tmpBuffer.append(box.getOwnRightPadding());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                this.sb.append("\t\t\t\t<box");
                this.sb.append(tmpBuffer.toString());
                this.sb.append("/>\n");
            }
        }
    }

    private void writeStaticText(JRStaticText staticText) {
        this.sb.append("\t\t\t<staticText>\n");
        this.writeReportElement(staticText);
        this.writeBox(staticText.getBox());
        this.writeTextElement(staticText);
        if (staticText.getText() != null) {
            this.sb.append("\t\t\t\t<text><![CDATA[");
            this.sb.append(staticText.getText());
            this.sb.append("]]></text>\n");
        }
        this.sb.append("\t\t\t</staticText>\n");
    }

    private void writeTextElement(JRTextElement textElement) {
        String font;
        this.sb.append("\t\t\t\t<textElement");
        if (textElement.getTextAlignment() != 1) {
            this.sb.append(" textAlignment=\"");
            this.sb.append((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(textElement.getTextAlignment())));
            this.sb.append("\"");
        }
        if (textElement.getVerticalAlignment() != 1) {
            this.sb.append(" verticalAlignment=\"");
            this.sb.append((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(textElement.getVerticalAlignment())));
            this.sb.append("\"");
        }
        if (textElement.getRotation() != 0) {
            this.sb.append(" rotation=\"");
            this.sb.append((String)JRXmlConstants.getRotationMap().get(new Byte(textElement.getRotation())));
            this.sb.append("\"");
        }
        if (textElement.getLineSpacing() != 0) {
            this.sb.append(" lineSpacing=\"");
            this.sb.append((String)JRXmlConstants.getLineSpacingMap().get(new Byte(textElement.getLineSpacing())));
            this.sb.append("\"");
        }
        if (textElement.isStyledText()) {
            this.sb.append(" isStyledText=\"");
            this.sb.append(textElement.isStyledText());
            this.sb.append("\"");
        }
        if ((font = this.writeFont(textElement.getFont())) != null) {
            this.sb.append(">\n");
            this.sb.append("\t\t\t\t\t" + font + "\n");
            this.sb.append("\t\t\t\t</textElement>\n");
        } else {
            this.sb.append("/>\n");
        }
    }

    private String writeFont(JRFont font) {
        String fontChunk = null;
        if (font != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    tmpBuffer.append(" reportFont=\"");
                    tmpBuffer.append(font.getReportFont().getName());
                    tmpBuffer.append("\"");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            if (font.getOwnFontName() != null) {
                tmpBuffer.append(" fontName=\"");
                tmpBuffer.append(font.getOwnFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnSize() != null) {
                tmpBuffer.append(" size=\"");
                tmpBuffer.append(font.getOwnSize());
                tmpBuffer.append("\"");
            }
            if (font.isOwnBold() != null) {
                tmpBuffer.append(" isBold=\"");
                tmpBuffer.append(font.isOwnBold());
                tmpBuffer.append("\"");
            }
            if (font.isOwnItalic() != null) {
                tmpBuffer.append(" isItalic=\"");
                tmpBuffer.append(font.isOwnItalic());
                tmpBuffer.append("\"");
            }
            if (font.isOwnUnderline() != null) {
                tmpBuffer.append(" isUnderline=\"");
                tmpBuffer.append(font.isOwnUnderline());
                tmpBuffer.append("\"");
            }
            if (font.isOwnStrikeThrough() != null) {
                tmpBuffer.append(" isStrikeThrough=\"");
                tmpBuffer.append(font.isOwnStrikeThrough());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfFontName() != null) {
                tmpBuffer.append(" pdfFontName=\"");
                tmpBuffer.append(font.getOwnPdfFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfEncoding() != null) {
                tmpBuffer.append(" pdfEncoding=\"");
                tmpBuffer.append(font.getOwnPdfEncoding());
                tmpBuffer.append("\"");
            }
            if (font.isOwnPdfEmbedded() != null) {
                tmpBuffer.append(" isPdfEmbedded=\"");
                tmpBuffer.append(font.isOwnPdfEmbedded());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                fontChunk = "<font" + tmpBuffer.toString() + "/>";
            }
        }
        return fontChunk;
    }

    private void writeTextField(JRTextField textField) {
        this.sb.append("\t\t\t<textField");
        if (textField.isStretchWithOverflow()) {
            this.sb.append(" isStretchWithOverflow=\"");
            this.sb.append(textField.isStretchWithOverflow());
            this.sb.append("\"");
        }
        if (textField.getEvaluationTime() != 1) {
            this.sb.append(" evaluationTime=\"");
            this.sb.append((String)JRXmlConstants.getEvaluationTimeMap().get(new Byte(textField.getEvaluationTime())));
            this.sb.append("\"");
        }
        if (textField.getEvaluationGroup() != null) {
            this.sb.append(" evaluationGroup=\"");
            this.sb.append(textField.getEvaluationGroup().getName());
            this.sb.append("\"");
        }
        if (textField.getPattern() != null) {
            this.sb.append(" pattern=\"");
            this.sb.append(textField.getPattern());
            this.sb.append("\"");
        }
        if (textField.isBlankWhenNull()) {
            this.sb.append(" isBlankWhenNull=\"");
            this.sb.append(textField.isBlankWhenNull());
            this.sb.append("\"");
        }
        if (textField.getHyperlinkType() != 1) {
            this.sb.append(" hyperlinkType=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(textField.getHyperlinkType())));
            this.sb.append("\"");
        }
        if (textField.getHyperlinkTarget() != 1) {
            this.sb.append(" hyperlinkTarget=\"");
            this.sb.append((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(textField.getHyperlinkTarget())));
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(textField);
        this.writeBox(textField.getBox());
        this.writeTextElement(textField);
        if (textField.getExpression() != null) {
            this.sb.append("\t\t\t\t<textFieldExpression");
            this.sb.append(" class=\"");
            this.sb.append(textField.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(textField.getExpression().getText());
            this.sb.append("]]></textFieldExpression>\n");
        }
        if (textField.getAnchorNameExpression() != null) {
            this.sb.append("\t\t\t\t<anchorNameExpression><![CDATA[");
            this.sb.append(textField.getAnchorNameExpression().getText());
            this.sb.append("]]></anchorNameExpression>\n");
        }
        if (textField.getHyperlinkReferenceExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkReferenceExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkReferenceExpression().getText());
            this.sb.append("]]></hyperlinkReferenceExpression>\n");
        }
        if (textField.getHyperlinkAnchorExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkAnchorExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkAnchorExpression().getText());
            this.sb.append("]]></hyperlinkAnchorExpression>\n");
        }
        if (textField.getHyperlinkPageExpression() != null) {
            this.sb.append("\t\t\t\t<hyperlinkPageExpression><![CDATA[");
            this.sb.append(textField.getHyperlinkPageExpression().getText());
            this.sb.append("]]></hyperlinkPageExpression>\n");
        }
        this.sb.append("\t\t\t</textField>\n");
    }

    private void writeSubreport(JRSubreport subreport) {
        JRSubreportParameter[] parameters;
        this.sb.append("\t\t\t<subreport");
        if (!subreport.isUsingCache()) {
            this.sb.append(" isUsingCache=\"");
            this.sb.append(subreport.isUsingCache());
            this.sb.append("\"");
        }
        this.sb.append(">\n");
        this.writeReportElement(subreport);
        if (subreport.getParametersMapExpression() != null) {
            this.sb.append("\t\t\t\t<parametersMapExpression><![CDATA[");
            this.sb.append(subreport.getParametersMapExpression().getText());
            this.sb.append("]]></parametersMapExpression>\n");
        }
        if ((parameters = subreport.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                this.writeSubreportParameter(parameters[i]);
            }
        }
        if (subreport.getConnectionExpression() != null) {
            this.sb.append("\t\t\t\t<connectionExpression><![CDATA[");
            this.sb.append(subreport.getConnectionExpression().getText());
            this.sb.append("]]></connectionExpression>\n");
        }
        if (subreport.getDataSourceExpression() != null) {
            this.sb.append("\t\t\t\t<dataSourceExpression><![CDATA[");
            this.sb.append(subreport.getDataSourceExpression().getText());
            this.sb.append("]]></dataSourceExpression>\n");
        }
        if (subreport.getExpression() != null) {
            this.sb.append("\t\t\t\t<subreportExpression");
            this.sb.append(" class=\"");
            this.sb.append(subreport.getExpression().getValueClassName());
            this.sb.append("\"");
            this.sb.append("><![CDATA[");
            this.sb.append(subreport.getExpression().getText());
            this.sb.append("]]></subreportExpression>\n");
        }
        this.sb.append("\t\t\t</subreport>\n");
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter) {
        this.sb.append("\t\t\t\t<subreportParameter");
        this.sb.append(" name=\"");
        this.sb.append(subreportParameter.getName());
        this.sb.append("\"");
        this.sb.append(">\n");
        if (subreportParameter.getExpression() != null) {
            this.sb.append("\t\t\t\t\t<subreportParameterExpression><![CDATA[");
            this.sb.append(subreportParameter.getExpression().getText());
            this.sb.append("]]></subreportParameterExpression>\n");
        }
        this.sb.append("\t\t\t\t</subreportParameter>\n");
    }
}

