/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JRXmlDataSource
implements JRRewindableDataSource {
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private CachedXPathAPI xpathAPI = new CachedXPathAPI();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public JRXmlDataSource(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSource(Document document, String selectExpression) throws JRException {
        this.document = document;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    public JRXmlDataSource(InputStream in) throws JRException {
        this(in, ".");
    }

    public JRXmlDataSource(InputStream in, String selectExpression) throws JRException {
        this(JRXmlDataSource.parse(new InputSource(in)), selectExpression);
    }

    public JRXmlDataSource(String uri) throws JRException {
        this(uri, ".");
    }

    public JRXmlDataSource(String uri, String selectExpression) throws JRException {
        this(JRXmlDataSource.parse(new InputSource(uri)), selectExpression);
    }

    public JRXmlDataSource(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSource(File file, String selectExpression) throws JRException {
        this(JRXmlDataSource.parse(file), selectExpression);
    }

    private static Document parse(InputSource is) throws JRException {
        try {
            return JRXmlDataSource.createDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
    }

    private static Document parse(File file) throws JRException {
        try {
            return JRXmlDataSource.createDocumentBuilder().parse(file);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", e);
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException("Failed to create a document builder factory", e);
        }
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be not null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be not null");
        }
        try {
            this.currentNode = null;
            this.currentNodeIndex = -1;
            this.nodeListLength = 0;
            this.nodeList = this.xpathAPI.selectNodeList((Node)this.document, this.selectExpression);
            this.nodeListLength = this.nodeList.getLength();
        }
        catch (TransformerException e) {
            throw new JRException("XPath selection failed. Expression: " + this.selectExpression, e);
        }
    }

    public boolean next() throws JRException {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        Class valueClass;
        if (this.currentNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        if ((class$java$lang$Object == null ? (class$java$lang$Object = JRXmlDataSource.class$("java.lang.Object")) : class$java$lang$Object) != (valueClass = jrField.getValueClass())) {
            String text;
            Node node = null;
            try {
                node = this.xpathAPI.selectSingleNode(this.currentNode, expression);
            }
            catch (TransformerException e) {
                throw new JRException("XPath selection failed. Expression: " + expression, e);
            }
            if (node != null && (text = this.getText(node)) != null) {
                value = (class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String) == valueClass ? text : ConvertUtils.convert((String)text.trim(), (Class)valueClass);
            }
        }
        return value;
    }

    public JRXmlDataSource subDataSource(String selectExpression) throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document document = JRXmlDataSource.createDocumentBuilder().newDocument();
        Node node = document.importNode(this.currentNode, true);
        document.appendChild(node);
        return new JRXmlDataSource(document, selectExpression);
    }

    public JRXmlDataSource subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public JRXmlDataSource dataSource(String selectExpression) throws JRException {
        return new JRXmlDataSource(this.document, selectExpression);
    }

    public JRXmlDataSource dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        JRXmlDataSource ds = new JRXmlDataSource(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField field = new JRDesignField();
        field.setDescription("CustomerID");
        field.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        ds.next();
        String v = (String)ds.getFieldValue(field);
        System.out.println(field.getDescription() + "=" + v);
        JRXmlDataSource subDs = ds.dataSource("/Northwind/Orders");
        JRDesignField field1 = new JRDesignField();
        field1.setDescription("OrderID");
        field1.setValueClass(class$java$lang$String == null ? (class$java$lang$String = JRXmlDataSource.class$("java.lang.String")) : class$java$lang$String);
        subDs.next();
        String v1 = (String)subDs.getFieldValue(field1);
        System.out.println(field1.getDescription() + "=" + v1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

