/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.util.JRImageLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextParser;
import org.xml.sax.SAXException;

public class JRPdfExporter
extends JRAbstractExporter {
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected Document document = null;
    protected PdfContentByte pdfContentByte = null;
    protected Document imageTesterDocument = null;
    protected PdfContentByte imageTesterPdfContentByte = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected int reportIndex = 0;
    protected boolean isEncrypted = false;
    protected boolean is128BitKey = false;
    protected String userPassword = null;
    protected String ownerPassword = null;
    protected int permissions = 0;
    protected JRFont defaultFont = null;
    protected JRStyledTextParser styledTextParser = new JRStyledTextParser();
    protected Map loadedImagesMap = null;
    protected Image pxImage = null;

    protected JRFont getDefaultFont() {
        if (this.defaultFont == null) {
            this.defaultFont = this.jasperPrint.getDefaultFont();
            if (this.defaultFont == null) {
                this.defaultFont = new JRBaseFont();
            }
        }
        return this.defaultFont;
    }

    protected Image getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = Image.getInstance((byte[])JRImageLoader.loadImageDataFromLocation("net/sf/jasperreports/engine/images/pixel.GIF"));
            }
            catch (Exception e) {
                throw new JRRuntimeException(e);
            }
        }
        return this.pxImage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void exportReport() throws JRException {
        OutputStream os;
        Boolean is128BitKeyParameter;
        Boolean isEncryptedParameter;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        if (!this.isModeBatch) {
            this.setPageRange();
        }
        if ((isEncryptedParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_ENCRYPTED)) != null) {
            this.isEncrypted = isEncryptedParameter;
        }
        if ((is128BitKeyParameter = (Boolean)this.parameters.get(JRPdfExporterParameter.IS_128_BIT_KEY)) != null) {
            this.is128BitKey = is128BitKeyParameter;
        }
        this.userPassword = (String)this.parameters.get(JRPdfExporterParameter.USER_PASSWORD);
        this.ownerPassword = (String)this.parameters.get(JRPdfExporterParameter.OWNER_PASSWORD);
        Integer permissionsParameter = (Integer)this.parameters.get(JRPdfExporterParameter.PERMISSIONS);
        if (permissionsParameter != null) {
            this.permissions = permissionsParameter;
        }
        if ((os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM)) != null) {
            this.exportReportToStream(os);
            return;
        }
        File destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
        if (destFile == null) {
            String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
            if (fileName == null) throw new JRException("No output specified for the exporter.");
            destFile = new File(fileName);
        }
        try {
            try {
                os = new FileOutputStream(destFile);
                this.exportReportToStream(os);
                os.flush();
            }
            catch (IOException e) {
                throw new JRException("Error trying to export to file : " + destFile, e);
            }
            Object var8_8 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        os.close();
        return;
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        this.document = new Document(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
        this.imageTesterDocument = new Document(new Rectangle(10.0f, 10.0f));
        try {
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)this.document, (OutputStream)os);
            pdfWriter.setCloseStream(false);
            if (this.isEncrypted) {
                pdfWriter.setEncryption(this.is128BitKey, this.userPassword, this.ownerPassword, this.permissions);
            }
            this.document.open();
            this.pdfContentByte = pdfWriter.getDirectContent();
            PdfWriter imageTesterPdfWriter = PdfWriter.getInstance((Document)this.imageTesterDocument, (OutputStream)new ByteArrayOutputStream());
            this.imageTesterDocument.open();
            this.imageTesterDocument.newPage();
            this.imageTesterPdfContentByte = imageTesterPdfWriter.getDirectContent();
            this.imageTesterPdfContentByte.setLiteral("\n");
            this.reportIndex = 0;
            while (this.reportIndex < this.jasperPrintList.size()) {
                this.jasperPrint = (JasperPrint)this.jasperPrintList.get(this.reportIndex);
                this.defaultFont = null;
                this.loadedImagesMap = new HashMap();
                this.document.setPageSize(new Rectangle((float)this.jasperPrint.getPageWidth(), (float)this.jasperPrint.getPageHeight()));
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (this.isModeBatch) {
                        this.document.newPage();
                        PdfDestination newReport = new PdfDestination(0, 0.0f, (float)this.jasperPrint.getPageHeight(), 0.0f);
                        this.startPageIndex = 0;
                        this.endPageIndex = pages.size() - 1;
                    }
                    Chunk chunk = null;
                    ColumnText colText = null;
                    JRPrintPage page = null;
                    for (int pageIndex = this.startPageIndex; pageIndex <= this.endPageIndex; ++pageIndex) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new JRException("Current thread interrupted.");
                        }
                        page = (JRPrintPage)pages.get(pageIndex);
                        this.document.newPage();
                        this.pdfContentByte = pdfWriter.getDirectContent();
                        this.pdfContentByte.setLineCap(2);
                        chunk = new Chunk(" ");
                        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
                        colText = new ColumnText(this.pdfContentByte);
                        colText.setSimpleColumn(new Phrase(chunk), 0.0f, (float)this.jasperPrint.getPageHeight(), 1.0f, 1.0f, 0.0f, 0);
                        colText.go();
                        this.exportPage(page);
                    }
                } else {
                    this.document.newPage();
                    this.pdfContentByte = pdfWriter.getDirectContent();
                    this.pdfContentByte.setLiteral("\n");
                }
                ++this.reportIndex;
            }
        }
        catch (DocumentException e) {
            throw new JRException("PDF Document error : " + this.jasperPrint.getName(), e);
        }
        catch (IOException e) {
            throw new JRException("Error generating PDF report : " + this.jasperPrint.getName(), e);
        }
        finally {
            this.document.close();
            this.imageTesterDocument.close();
        }
    }

    protected void exportPage(JRPrintPage page) throws JRException, DocumentException, IOException {
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line) {
        if (line.getPen() != 0) {
            this.pdfContentByte.setRGBColorStroke(line.getForecolor().getRed(), line.getForecolor().getGreen(), line.getForecolor().getBlue());
            float borderCorrection = 0.0f;
            switch (line.getPen()) {
                case 4: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                    break;
                }
                case 3: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(4.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 2: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(2.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                case 0: {
                    break;
                }
                case 5: {
                    borderCorrection = 0.25f;
                    this.pdfContentByte.setLineWidth(0.5f);
                    this.pdfContentByte.setLineDash(0.0f);
                    break;
                }
                default: {
                    borderCorrection = 0.0f;
                    this.pdfContentByte.setLineWidth(1.0f);
                    this.pdfContentByte.setLineDash(0.0f);
                }
            }
            int x1 = 0;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            if (line.getDirection() == 1) {
                if (line.getWidth() > 1) {
                    if (line.getHeight() > 1) {
                        x1 = -1;
                        y1 = 1;
                        x2 = 1;
                        y2 = -1;
                    } else {
                        x1 = -1;
                        y1 = 1;
                        x2 = 1;
                        y2 = 1;
                    }
                } else if (line.getHeight() > 1) {
                    x1 = -1;
                    y1 = 1;
                    x2 = -1;
                    y2 = -1;
                } else {
                    x1 = -1;
                    y1 = 1;
                    x2 = -1;
                    y2 = 1;
                }
                this.pdfContentByte.moveTo((float)(line.getX() + this.globalOffsetX) + (float)x1 * borderCorrection, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.globalOffsetY) + (float)y1 * borderCorrection);
                this.pdfContentByte.lineTo((float)(line.getX() + this.globalOffsetX + line.getWidth()) + (float)x2 * borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.globalOffsetY - line.getHeight()) + (float)y2 * borderCorrection + 1.0f);
            } else {
                if (line.getWidth() > 1) {
                    if (line.getHeight() > 1) {
                        x1 = -1;
                        y1 = -1;
                        x2 = 1;
                        y2 = 1;
                    } else {
                        x1 = -1;
                        y1 = -1;
                        x2 = 1;
                        y2 = -1;
                    }
                } else if (line.getHeight() > 1) {
                    x1 = 1;
                    y1 = -1;
                    x2 = 1;
                    y2 = 1;
                } else {
                    x1 = 1;
                    y1 = -1;
                    x2 = 1;
                    y2 = -1;
                }
                this.pdfContentByte.moveTo((float)(line.getX() + this.globalOffsetX) + (float)x1 * borderCorrection, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.globalOffsetY - line.getHeight()) + (float)y1 * borderCorrection + 1.0f);
                this.pdfContentByte.lineTo((float)(line.getX() + this.globalOffsetX + line.getWidth()) + (float)x2 * borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - line.getY() - this.globalOffsetY) + (float)y2 * borderCorrection);
            }
            this.pdfContentByte.stroke();
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContentByte.setRGBColorStroke(rectangle.getForecolor().getRed(), rectangle.getForecolor().getGreen(), rectangle.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
        float borderCorrection = 0.0f;
        switch (rectangle.getPen()) {
            case 4: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(rectangle.getBackcolor().getRed(), rectangle.getBackcolor().getGreen(), rectangle.getBackcolor().getBlue());
                break;
            }
            default: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        if (rectangle.getMode() == 1) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.globalOffsetY - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getRadius());
            this.pdfContentByte.fillStroke();
        } else if (rectangle.getPen() != 0) {
            this.pdfContentByte.roundRectangle((float)(rectangle.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - rectangle.getY() - this.globalOffsetY - rectangle.getHeight()) - borderCorrection + 1.0f, (float)rectangle.getWidth() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getHeight() + 2.0f * borderCorrection - 1.0f, (float)rectangle.getRadius());
            this.pdfContentByte.stroke();
        }
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContentByte.setRGBColorStroke(ellipse.getForecolor().getRed(), ellipse.getForecolor().getGreen(), ellipse.getForecolor().getBlue());
        this.pdfContentByte.setRGBColorFill(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
        float borderCorrection = 0.0f;
        switch (ellipse.getPen()) {
            case 4: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(4.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(2.0f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                this.pdfContentByte.setLineWidth(0.5f);
                this.pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                this.pdfContentByte.setLineWidth(0.0f);
                this.pdfContentByte.setLineDash(0.0f);
                this.pdfContentByte.setRGBColorStroke(ellipse.getBackcolor().getRed(), ellipse.getBackcolor().getGreen(), ellipse.getBackcolor().getBlue());
                break;
            }
            default: {
                borderCorrection = 0.0f;
                this.pdfContentByte.setLineWidth(1.0f);
                this.pdfContentByte.setLineDash(0.0f);
            }
        }
        if (ellipse.getMode() == 1) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.globalOffsetY - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + this.globalOffsetX + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.fillStroke();
        } else if (ellipse.getPen() != 0) {
            this.pdfContentByte.ellipse((float)(ellipse.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.globalOffsetY - ellipse.getHeight()) - borderCorrection + 1.0f, (float)(ellipse.getX() + this.globalOffsetX + ellipse.getWidth()) + borderCorrection - 1.0f, (float)(this.jasperPrint.getPageHeight() - ellipse.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.stroke();
        }
    }

    protected void exportImage(JRPrintImage printImage) throws DocumentException, IOException, JRException {
        int availableImageWidth;
        this.pdfContentByte.setRGBColorFill(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
        float borderCorrection = 0.0f;
        float lineWidth = 1.0f;
        boolean isLineDotted = false;
        switch (printImage.getPen()) {
            case 4: {
                borderCorrection = 0.0f;
                lineWidth = 1.0f;
                isLineDotted = true;
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                lineWidth = 4.0f;
                isLineDotted = false;
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                lineWidth = 2.0f;
                isLineDotted = false;
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                lineWidth = 0.5f;
                isLineDotted = false;
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                lineWidth = 1.0f;
                isLineDotted = false;
                break;
            }
            default: {
                borderCorrection = 0.0f;
                lineWidth = 1.0f;
                isLineDotted = false;
            }
        }
        if (printImage.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(printImage.getBackcolor().getRed(), printImage.getBackcolor().getGreen(), printImage.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(0.1f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)(printImage.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.globalOffsetY) + borderCorrection, (float)printImage.getWidth() + 2.0f * borderCorrection - 1.0f, (float)(-printImage.getHeight()) - 2.0f * borderCorrection + 1.0f);
            this.pdfContentByte.fillStroke();
        }
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        if (printImage.getBox() != null) {
            topPadding = printImage.getBox().getTopPadding();
            leftPadding = printImage.getBox().getLeftPadding();
            bottomPadding = printImage.getBox().getBottomPadding();
            rightPadding = printImage.getBox().getRightPadding();
        }
        availableImageWidth = (availableImageWidth = printImage.getWidth() - leftPadding - rightPadding) < 0 ? 0 : availableImageWidth;
        int availableImageHeight = printImage.getHeight() - topPadding - bottomPadding;
        availableImageHeight = availableImageHeight < 0 ? 0 : availableImageHeight;
        int xoffset = 0;
        int yoffset = 0;
        JRRenderable renderer = printImage.getRenderer();
        if (renderer != null && availableImageWidth > 0 && availableImageHeight > 0) {
            Chunk chunk = null;
            float scaledWidth = availableImageWidth;
            float scaledHeight = availableImageHeight;
            if (renderer.getType() == 0) {
                Image image = null;
                float xalignFactor = 0.0f;
                switch (printImage.getHorizontalAlignment()) {
                    case 3: {
                        xalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        xalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        xalignFactor = 0.0f;
                    }
                }
                float yalignFactor = 0.0f;
                switch (printImage.getVerticalAlignment()) {
                    case 3: {
                        yalignFactor = 1.0f;
                        break;
                    }
                    case 2: {
                        yalignFactor = 0.5f;
                        break;
                    }
                    default: {
                        yalignFactor = 0.0f;
                    }
                }
                switch (printImage.getScaleImage()) {
                    case 1: {
                        int normalWidth = availableImageWidth;
                        int normalHeight = availableImageHeight;
                        Dimension2D dimension = renderer.getDimension();
                        if (dimension != null) {
                            normalWidth = (int)dimension.getWidth();
                            normalHeight = (int)dimension.getHeight();
                        }
                        xoffset = (int)(xalignFactor * (float)(availableImageWidth - normalWidth));
                        yoffset = (int)(yalignFactor * (float)(availableImageHeight - normalHeight));
                        int minWidth = Math.min(normalWidth, availableImageWidth);
                        int minHeight = Math.min(normalHeight, availableImageHeight);
                        BufferedImage bi = new BufferedImage(minWidth, minHeight, 1);
                        Graphics2D g = bi.createGraphics();
                        g.setColor(printImage.getBackcolor());
                        g.fillRect(0, 0, minWidth, minHeight);
                        renderer.render(g, new java.awt.Rectangle(xoffset > 0 ? 0 : xoffset, yoffset > 0 ? 0 : yoffset, normalWidth, normalHeight));
                        g.dispose();
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                        image = Image.getInstance((java.awt.Image)bi, null);
                        break;
                    }
                    case 2: {
                        if (this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                java.awt.Image awtImage = JRImageRenderer.getInstance(renderer.getImageData(), printImage.getOnErrorType()).getImage();
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            this.loadedImagesMap.put(renderer, image);
                        }
                        image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                        break;
                    }
                    default: {
                        if (this.loadedImagesMap.containsKey(renderer)) {
                            image = (Image)this.loadedImagesMap.get(renderer);
                        } else {
                            try {
                                image = Image.getInstance((byte[])renderer.getImageData());
                                this.imageTesterPdfContentByte.addImage(image, 10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 0.0f);
                            }
                            catch (Exception e) {
                                java.awt.Image awtImage = JRImageLoader.loadImage(renderer.getImageData());
                                image = Image.getInstance((java.awt.Image)awtImage, null);
                            }
                            this.loadedImagesMap.put(renderer, image);
                        }
                        image.scaleToFit((float)availableImageWidth, (float)availableImageHeight);
                        xoffset = (int)(xalignFactor * ((float)availableImageWidth - image.plainWidth()));
                        yoffset = (int)(yalignFactor * ((float)availableImageHeight - image.plainHeight()));
                        xoffset = xoffset < 0 ? 0 : xoffset;
                        yoffset = yoffset < 0 ? 0 : yoffset;
                    }
                }
                chunk = new Chunk(image, -0.5f, 0.5f);
                scaledWidth = image.scaledWidth();
                scaledHeight = image.scaledHeight();
            } else {
                PdfTemplate template = this.pdfContentByte.createTemplate((float)availableImageWidth, (float)availableImageHeight);
                Graphics2D g = template.createGraphicsShapes((float)availableImageWidth, (float)availableImageHeight);
                Rectangle2D.Float rectangle = new Rectangle2D.Float(0.0f, 0.0f, availableImageWidth, availableImageHeight);
                renderer.render(g, rectangle);
                g.dispose();
                this.pdfContentByte.saveState();
                this.pdfContentByte.addTemplate(template, (float)(printImage.getX() + this.globalOffsetX + xoffset), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.globalOffsetY - availableImageHeight - yoffset));
                this.pdfContentByte.restoreState();
                Image image = this.getPxImage();
                image.scaleAbsolute((float)availableImageWidth, (float)availableImageHeight);
                chunk = new Chunk(image, 0.0f, 0.0f);
            }
            if (printImage.getAnchorName() != null) {
                chunk.setLocalDestination(printImage.getAnchorName());
            }
            switch (printImage.getHyperlinkType()) {
                case 2: {
                    if (printImage.getHyperlinkReference() == null) break;
                    chunk.setAnchor(printImage.getHyperlinkReference());
                    break;
                }
                case 3: {
                    if (printImage.getHyperlinkAnchor() == null) break;
                    chunk.setLocalGoto(printImage.getHyperlinkAnchor());
                    break;
                }
                case 4: {
                    if (printImage.getHyperlinkPage() == null) break;
                    chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + printImage.getHyperlinkPage().toString());
                    break;
                }
                case 5: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkAnchor() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkAnchor());
                    break;
                }
                case 6: {
                    if (printImage.getHyperlinkReference() == null || printImage.getHyperlinkPage() == null) break;
                    chunk.setRemoteGoto(printImage.getHyperlinkReference(), printImage.getHyperlinkPage().intValue());
                    break;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(new Phrase(chunk), (float)(printImage.getX() + leftPadding + this.globalOffsetX + xoffset), (float)(this.jasperPrint.getPageHeight() - printImage.getY() - topPadding - this.globalOffsetY) - scaledHeight - (float)yoffset, (float)(printImage.getX() + leftPadding + this.globalOffsetX + xoffset) + scaledWidth, (float)(this.jasperPrint.getPageHeight() - printImage.getY() - topPadding - this.globalOffsetY - yoffset), scaledHeight, 0);
            colText.go();
        }
        if (printImage.getBox() == null) {
            if (printImage.getPen() != 0) {
                this.pdfContentByte.setRGBColorStroke(printImage.getForecolor().getRed(), printImage.getForecolor().getGreen(), printImage.getForecolor().getBlue());
                this.pdfContentByte.setLineWidth(lineWidth);
                if (isLineDotted) {
                    this.pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                } else {
                    this.pdfContentByte.setLineDash(0.0f);
                }
                this.pdfContentByte.rectangle((float)(printImage.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - printImage.getY() - this.globalOffsetY) + borderCorrection, (float)printImage.getWidth() + 2.0f * borderCorrection - 1.0f, (float)(-printImage.getHeight()) - 2.0f * borderCorrection + 1.0f);
                this.pdfContentByte.stroke();
            }
        } else {
            this.exportBox(printImage.getBox(), printImage);
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        JRStyledText styledText = null;
        String text = textElement.getText();
        if (text != null) {
            JRFont font = textElement.getFont();
            if (font == null) {
                font = this.getDefaultFont();
            }
            HashMap<TextAttribute, Color> attributes = new HashMap<TextAttribute, Color>();
            attributes.putAll(font.getAttributes());
            attributes.put(TextAttribute.FOREGROUND, textElement.getForecolor());
            if (textElement.getMode() == 1) {
                attributes.put(TextAttribute.BACKGROUND, textElement.getBackcolor());
            }
            if (textElement.isStyledText()) {
                try {
                    styledText = this.styledTextParser.parse(attributes, text);
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
            if (styledText == null) {
                styledText = new JRStyledText();
                styledText.append(text);
                styledText.addRun(new JRStyledText.Run(attributes, 0, text.length()));
            }
        }
        return styledText;
    }

    protected void setHyperlinkInfo(Chunk chunk, JRPrintText text) {
        if (text.getAnchorName() != null) {
            chunk.setLocalDestination(text.getAnchorName());
        }
        switch (text.getHyperlinkType()) {
            case 2: {
                if (text.getHyperlinkReference() == null) break;
                chunk.setAnchor(text.getHyperlinkReference());
                break;
            }
            case 3: {
                if (text.getHyperlinkAnchor() == null) break;
                chunk.setLocalGoto(text.getHyperlinkAnchor());
                break;
            }
            case 4: {
                if (text.getHyperlinkPage() == null) break;
                chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + text.getHyperlinkPage().toString());
                break;
            }
            case 5: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkAnchor() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkAnchor());
                break;
            }
            case 6: {
                if (text.getHyperlinkReference() == null || text.getHyperlinkPage() == null) break;
                chunk.setRemoteGoto(text.getHyperlinkReference(), text.getHyperlinkPage().intValue());
                break;
            }
        }
    }

    protected Phrase getPhrase(JRStyledText styledText, JRPrintText textElement) throws JRException, DocumentException, IOException {
        Phrase phrase = new Phrase();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            Chunk chunk = this.getChunk(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit));
            this.setHyperlinkInfo(chunk, textElement);
            phrase.add((Object)chunk);
            iterator.setIndex(runLimit);
        }
        return phrase;
    }

    protected Chunk getChunk(Map attributes, String text) throws JRException, DocumentException, IOException {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        BaseFont baseFont = null;
        Exception initialException = null;
        try {
            baseFont = BaseFont.createFont((String)jrFont.getPdfFontName(), (String)jrFont.getPdfEncoding(), (boolean)jrFont.isPdfEmbedded(), (boolean)true, null, null);
        }
        catch (Exception e) {
            initialException = e;
        }
        if (baseFont == null) {
            byte[] bytes = null;
            try {
                bytes = JRLoader.loadBytesFromLocation(jrFont.getPdfFontName());
            }
            catch (JRException e) {
                throw new JRException("Could not load the following font : \npdfFontName   : " + jrFont.getPdfFontName() + "\npdfEncoding   : " + jrFont.getPdfEncoding() + "\nisPdfEmbedded : " + jrFont.isPdfEmbedded(), initialException);
            }
            baseFont = BaseFont.createFont((String)jrFont.getPdfFontName(), (String)jrFont.getPdfEncoding(), (boolean)jrFont.isPdfEmbedded(), (boolean)true, (byte[])bytes, null);
        }
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        Color backcolor = (Color)attributes.get(TextAttribute.BACKGROUND);
        Font font = new Font(baseFont, (float)jrFont.getSize(), (jrFont.isUnderline() ? 4 : 0) | (jrFont.isStrikeThrough() ? 8 : 0), forecolor);
        Chunk chunk = new Chunk(text, font);
        if (backcolor != null) {
            chunk.setBackground(backcolor);
        }
        return chunk;
    }

    protected void exportText(JRPrintText text) throws JRException, DocumentException, IOException {
        JRStyledText styledText = this.getStyledText(text);
        if (styledText == null) {
            return;
        }
        int textLength = styledText.length();
        int x = text.getX() + this.globalOffsetX;
        int y = text.getY() + this.globalOffsetY;
        int width = text.getWidth();
        int height = text.getHeight();
        int topPadding = 0;
        int leftPadding = 0;
        int bottomPadding = 0;
        int rightPadding = 0;
        int xFillCorrection = 0;
        int yFillCorrection = 0;
        if (text.getBox() != null) {
            topPadding = text.getBox().getTopPadding();
            leftPadding = text.getBox().getLeftPadding();
            bottomPadding = text.getBox().getBottomPadding();
            rightPadding = text.getBox().getRightPadding();
        }
        double angle = 0.0;
        switch (text.getRotation()) {
            case 1: {
                y = text.getY() + this.globalOffsetY + text.getHeight();
                xFillCorrection = 1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = leftPadding;
                leftPadding = bottomPadding;
                bottomPadding = rightPadding;
                rightPadding = tmpPadding;
                angle = 1.5707963267948966;
                break;
            }
            case 2: {
                x = text.getX() + this.globalOffsetX + text.getWidth();
                yFillCorrection = -1;
                width = text.getHeight();
                height = text.getWidth();
                int tmpPadding = topPadding;
                topPadding = rightPadding;
                rightPadding = bottomPadding;
                bottomPadding = leftPadding;
                leftPadding = tmpPadding;
                angle = -1.5707963267948966;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        if (text.getMode() == 1) {
            this.pdfContentByte.setRGBColorStroke(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setRGBColorFill(text.getBackcolor().getRed(), text.getBackcolor().getGreen(), text.getBackcolor().getBlue());
            this.pdfContentByte.setLineWidth(1.0f);
            this.pdfContentByte.setLineDash(0.0f);
            this.pdfContentByte.rectangle((float)(x + xFillCorrection), (float)(this.jasperPrint.getPageHeight() - y + yFillCorrection), (float)(width - 1), (float)(-height + 1));
            this.pdfContentByte.fillStroke();
        }
        if (textLength > 0) {
            int horizontalAlignment = 0;
            switch (text.getTextAlignment()) {
                case 1: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 0;
                        break;
                    }
                    horizontalAlignment = 2;
                    break;
                }
                case 2: {
                    horizontalAlignment = 1;
                    break;
                }
                case 3: {
                    if (text.getRunDirection() == 0) {
                        horizontalAlignment = 2;
                        break;
                    }
                    horizontalAlignment = 0;
                    break;
                }
                case 4: {
                    horizontalAlignment = 3;
                    break;
                }
                default: {
                    horizontalAlignment = 0;
                }
            }
            float verticalOffset = 0.0f;
            switch (text.getVerticalAlignment()) {
                case 1: {
                    verticalOffset = 0.0f;
                    break;
                }
                case 2: {
                    verticalOffset = ((float)height - text.getTextHeight()) / 2.0f;
                    break;
                }
                case 3: {
                    verticalOffset = (float)height - text.getTextHeight();
                    break;
                }
                default: {
                    verticalOffset = 0.0f;
                }
            }
            ColumnText colText = new ColumnText(this.pdfContentByte);
            colText.setSimpleColumn(this.getPhrase(styledText, text), (float)(x + leftPadding), (float)(this.jasperPrint.getPageHeight() - y - topPadding) - verticalOffset - text.getLeadingOffset(), (float)(x + width - rightPadding), (float)(this.jasperPrint.getPageHeight() - y - height + bottomPadding), 0.0f, horizontalAlignment);
            colText.setLeading(0.0f, text.getLineSpacingFactor());
            colText.setRunDirection(text.getRunDirection() == 0 ? 2 : 3);
            colText.go();
        }
        atrans = new AffineTransform();
        atrans.rotate(-angle, x, this.jasperPrint.getPageHeight() - y);
        this.pdfContentByte.transform(atrans);
        if (text.getBox() != null) {
            this.exportBox(text.getBox(), text);
        }
    }

    protected void exportBox(JRBox box, JRPrintElement element) throws DocumentException, IOException {
        Color color;
        float borderCorrection;
        if (box.getTopBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getTopBorder());
            color = box.getTopBorderColor() == null ? element.getForecolor() : box.getTopBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.globalOffsetX + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getLeftBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getLeftBorder());
            color = box.getLeftBorderColor() == null ? element.getForecolor() : box.getLeftBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getBottomBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getBottomBorder());
            color = box.getBottomBorderColor() == null ? element.getForecolor() : box.getBottomBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.globalOffsetX) - borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.globalOffsetX + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
        if (box.getRightBorder() != 0) {
            borderCorrection = JRPdfExporter.prepareBorder(this.pdfContentByte, box.getRightBorder());
            color = box.getRightBorderColor() == null ? element.getForecolor() : box.getRightBorderColor();
            this.pdfContentByte.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
            this.pdfContentByte.moveTo((float)(element.getX() + this.globalOffsetX + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY) + borderCorrection);
            this.pdfContentByte.lineTo((float)(element.getX() + this.globalOffsetX + element.getWidth() - 1) + borderCorrection, (float)(this.jasperPrint.getPageHeight() - element.getY() - this.globalOffsetY - element.getHeight() + 1) - borderCorrection);
            this.pdfContentByte.stroke();
        }
    }

    private static float prepareBorder(PdfContentByte pdfContentByte, byte border) {
        float borderCorrection = 0.0f;
        switch (border) {
            case 4: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(5.0f, 3.0f, 0.0f);
                break;
            }
            case 3: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(4.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 2: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(2.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 5: {
                borderCorrection = 0.25f;
                pdfContentByte.setLineWidth(0.5f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            case 0: {
                borderCorrection = 0.5f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
                break;
            }
            default: {
                borderCorrection = 0.0f;
                pdfContentByte.setLineWidth(1.0f);
                pdfContentByte.setLineDash(0.0f);
            }
        }
        return borderCorrection;
    }
}

