/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

public class JRStringUtil {
    public static String replaceTabWithBlank(String source) {
        String result = source;
        if (source != null && source.length() > 0) {
            StringBuffer sbuffer = new StringBuffer(source);
            int offset = 0;
            int pos = source.indexOf("\t", offset);
            while (pos >= 0) {
                sbuffer.setCharAt(pos, ' ');
                offset = pos + 1;
                pos = source.indexOf("\t", offset);
            }
            result = sbuffer.toString();
        }
        return result;
    }

    public static String xmlEncode(String text) {
        if (text != null) {
            StringBuffer ret = new StringBuffer();
            block6: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case '&': {
                        ret.append("&amp;");
                        continue block6;
                    }
                    case '>': {
                        ret.append("&gt;");
                        continue block6;
                    }
                    case '<': {
                        ret.append("&lt;");
                        continue block6;
                    }
                    case '\"': {
                        ret.append("&quot;");
                        continue block6;
                    }
                    default: {
                        ret.append(text.substring(i, i + 1));
                    }
                }
            }
            return ret.toString();
        }
        return null;
    }

    public static String getLiteral(String name) {
        if (JRStringUtil.isValidLiteral(name)) {
            return name;
        }
        StringBuffer buffer = new StringBuffer(name.length() + 5);
        char[] literalChars = new char[name.length()];
        name.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            if (i != 0 && !Character.isJavaIdentifierPart(literalChars[i])) {
                buffer.append((int)literalChars[i]);
                continue;
            }
            buffer.append(literalChars[i]);
        }
        return buffer.toString();
    }

    private static boolean isValidLiteral(String literal) {
        boolean result = true;
        char[] literalChars = new char[literal.length()];
        literal.getChars(0, literalChars.length, literalChars, 0);
        for (int i = 0; i < literalChars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(literalChars[i])) {
                result = false;
            }
            if (i == 0 || Character.isJavaIdentifierPart(literalChars[i])) continue;
            result = false;
        }
        return result;
    }
}

