/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintAnchorIndex;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.xml.JRPrintXmlLoader;
import net.sf.jasperreports.view.JRHyperlinkListener;
import net.sf.jasperreports.view.JRSaveContributor;

public class JRViewer
extends JPanel
implements JRHyperlinkListener {
    private static final int TYPE_FILE_NAME = 1;
    private static final int TYPE_INPUT_STREAM = 2;
    private static final int TYPE_JASPER_PRINT = 3;
    protected float MIN_ZOOM = 0.5f;
    protected float MAX_ZOOM = 2.5f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250};
    protected int defaultZoomIndex = 2;
    private int type = 1;
    private boolean isXML = false;
    private String reportFileName = null;
    private JasperPrint jasperPrint = null;
    private int pageIndex = 0;
    private float zoom = 0.0f;
    private DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private int downX = 0;
    private int downY = 0;
    private List hyperlinkListeners = new ArrayList();
    private Map linksMap = new HashMap();
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent evt) {
            JRViewer.this.hyperlinkClicked(evt);
        }
    };
    protected JToggleButton btnActualSize;
    protected JButton btnFirst;
    protected JToggleButton btnFitPage;
    protected JToggleButton btnFitWidth;
    protected JButton btnLast;
    protected JButton btnNext;
    protected JButton btnPrevious;
    protected JButton btnPrint;
    protected JButton btnReload;
    protected JButton btnSave;
    protected JButton btnZoomIn;
    protected JButton btnZoomOut;
    protected JComboBox cmbZoom;
    private JLabel jLabel1;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JLabel lblPage;
    protected JLabel lblStatus;
    private JPanel pnlInScroll;
    private JPanel pnlLinks;
    private JPanel pnlMain;
    private JPanel pnlPage;
    protected JPanel pnlSep01;
    protected JPanel pnlSep02;
    protected JPanel pnlSep03;
    protected JPanel pnlStatus;
    private JScrollPane scrollPane;
    protected JPanel tlbToolBar;
    protected JTextField txtGoTo;

    public JRViewer(String fileName, boolean isXML) throws JRException {
        this.setZooms();
        this.initComponents();
        this.loadReport(fileName, isXML);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.addHyperlinkListener(this);
    }

    public JRViewer(InputStream is, boolean isXML) throws JRException {
        this.setZooms();
        this.initComponents();
        this.loadReport(is, isXML);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.addHyperlinkListener(this);
    }

    public JRViewer(JasperPrint jrPrint) throws JRException {
        this.setZooms();
        this.initComponents();
        this.loadReport(jrPrint);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
        this.addHyperlinkListener(this);
    }

    public void clear() {
        this.emptyContainer(this);
        this.jasperPrint = null;
    }

    protected void setZooms() {
    }

    public void addHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.add(listener);
    }

    public void removeHyperlinkListener(JRHyperlinkListener listener) {
        this.hyperlinkListeners.remove(listener);
    }

    public JRHyperlinkListener[] getHyperlinkListeners() {
        return this.hyperlinkListeners.toArray(new JRHyperlinkListener[this.hyperlinkListeners.size()]);
    }

    public void gotoHyperlink(JRPrintHyperlink hyperlink) throws JRException {
        switch (hyperlink.getHyperlinkType()) {
            case 2: {
                if (this.hyperlinkListeners == null || this.hyperlinkListeners.size() <= 1) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 3: {
                Container container;
                if (hyperlink.getHyperlinkAnchor() == null) break;
                Map anchorIndexes = this.jasperPrint.getAnchorIndexes();
                JRPrintAnchorIndex anchorIndex = (JRPrintAnchorIndex)anchorIndexes.get(hyperlink.getHyperlinkAnchor());
                if (anchorIndex.getPageIndex() != this.pageIndex) {
                    this.setPageIndex(anchorIndex.getPageIndex());
                    this.refreshPage();
                }
                if (!((container = this.pnlInScroll.getParent()) instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                int newX = (int)((float)anchorIndex.getElement().getX() * this.zoom);
                int newY = (int)((float)anchorIndex.getElement().getY() * this.zoom);
                int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
                int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
                if (newX < 0) {
                    newX = 0;
                }
                if (newX > maxX) {
                    newX = maxX;
                }
                if (newY < 0) {
                    newY = 0;
                }
                if (newY > maxY) {
                    newY = maxY;
                }
                viewport.setViewPosition(new Point(newX, newY));
                break;
            }
            case 4: {
                int page = this.pageIndex + 1;
                if (hyperlink.getHyperlinkPage() != null) {
                    page = hyperlink.getHyperlinkPage();
                }
                if (page < 1 || page > this.jasperPrint.getPages().size() || page == this.pageIndex + 1) break;
                this.setPageIndex(page - 1);
                this.refreshPage();
                Container container = this.pnlInScroll.getParent();
                if (!(container instanceof JViewport)) break;
                JViewport viewport = (JViewport)container;
                viewport.setViewPosition(new Point(0, 0));
                break;
            }
            case 5: {
                if (this.hyperlinkListeners == null || this.hyperlinkListeners.size() <= 1) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink anchor    : " + hyperlink.getHyperlinkAnchor());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
            case 6: {
                if (this.hyperlinkListeners == null || this.hyperlinkListeners.size() <= 1) break;
                System.out.println("Hyperlink reference : " + hyperlink.getHyperlinkReference());
                System.out.println("Hyperlink page      : " + hyperlink.getHyperlinkPage());
                System.out.println("Implement your own JRHyperlinkListener to manage this type of event.");
                break;
            }
        }
    }

    private void initComponents() {
        this.tlbToolBar = new JPanel();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.btnReload = new JButton();
        this.pnlSep01 = new JPanel();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.pnlSep02 = new JPanel();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.pnlSep03 = new JPanel();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            model.addElement("" + this.zooms[i] + "%");
        }
        this.cmbZoom.setModel(model);
        this.pnlMain = new JPanel();
        this.scrollPane = new JScrollPane();
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(5);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.pnlInScroll = new JPanel();
        this.pnlPage = new JPanel();
        this.jPanel4 = new JPanel();
        this.pnlLinks = new JPanel();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel9 = new JPanel();
        this.lblPage = new JLabel();
        this.pnlStatus = new JPanel();
        this.lblStatus = new JLabel();
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(450, 150));
        this.setPreferredSize(new Dimension(450, 150));
        this.tlbToolBar.setLayout(new FlowLayout(0, 0, 2));
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/save.GIF")));
        this.btnSave.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("save"));
        this.btnSave.setMargin(new Insets(2, 2, 2, 2));
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnSaveActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/print.GIF")));
        this.btnPrint.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("print"));
        this.btnPrint.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPrintActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnPrint);
        this.btnReload.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/reload.GIF")));
        this.btnReload.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("reload"));
        this.btnReload.setMargin(new Insets(2, 2, 2, 2));
        this.btnReload.setMaximumSize(new Dimension(23, 23));
        this.btnReload.setMinimumSize(new Dimension(23, 23));
        this.btnReload.setPreferredSize(new Dimension(23, 23));
        this.btnReload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnReloadActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnReload);
        this.pnlSep01.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep01);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/first.GIF")));
        this.btnFirst.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("first.page"));
        this.btnFirst.setMargin(new Insets(2, 2, 2, 2));
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFirstActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/previous.GIF")));
        this.btnPrevious.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("previous.page"));
        this.btnPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnPreviousActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/next.GIF")));
        this.btnNext.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("next.page"));
        this.btnNext.setMargin(new Insets(2, 2, 2, 2));
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnNextActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/last.GIF")));
        this.btnLast.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("last.page"));
        this.btnLast.setMargin(new Insets(2, 2, 2, 2));
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnLastActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnLast);
        this.txtGoTo.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("go.to.page"));
        this.txtGoTo.setMaximumSize(new Dimension(40, 23));
        this.txtGoTo.setMinimumSize(new Dimension(40, 23));
        this.txtGoTo.setPreferredSize(new Dimension(40, 23));
        this.txtGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.txtGoToActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.txtGoTo);
        this.pnlSep02.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep02);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/actualsize.GIF")));
        this.btnActualSize.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("actual.size"));
        this.btnActualSize.setMargin(new Insets(2, 2, 2, 2));
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnActualSizeActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitpage.GIF")));
        this.btnFitPage.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("fit.page"));
        this.btnFitPage.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFitPageActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/fitwidth.GIF")));
        this.btnFitWidth.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("fit.width"));
        this.btnFitWidth.setMargin(new Insets(2, 2, 2, 2));
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnFitWidthActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnFitWidth);
        this.pnlSep03.setMaximumSize(new Dimension(10, 10));
        this.tlbToolBar.add(this.pnlSep03);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomin.GIF")));
        this.btnZoomIn.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("zoom.in"));
        this.btnZoomIn.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomInActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/net/sf/jasperreports/view/images/zoomout.GIF")));
        this.btnZoomOut.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("zoom.out"));
        this.btnZoomOut.setMargin(new Insets(2, 2, 2, 2));
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.tlbToolBar.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setToolTipText(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("zoom.ratio"));
        this.cmbZoom.setMaximumSize(new Dimension(80, 23));
        this.cmbZoom.setMinimumSize(new Dimension(80, 23));
        this.cmbZoom.setPreferredSize(new Dimension(80, 23));
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRViewer.this.cmbZoomActionPerformed(evt);
            }
        });
        this.cmbZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JRViewer.this.cmbZoomItemStateChanged(evt);
            }
        });
        this.tlbToolBar.add(this.cmbZoom);
        this.add((Component)this.tlbToolBar, "North");
        this.pnlMain.setLayout(new BorderLayout());
        this.pnlMain.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                JRViewer.this.pnlMainComponentResized(evt);
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.pnlInScroll.setLayout(new GridBagLayout());
        this.pnlPage.setLayout(new BorderLayout());
        this.pnlPage.setMinimumSize(new Dimension(100, 100));
        this.pnlPage.setPreferredSize(new Dimension(100, 100));
        this.jPanel4.setLayout(new GridBagLayout());
        this.jPanel4.setMinimumSize(new Dimension(100, 120));
        this.jPanel4.setPreferredSize(new Dimension(100, 120));
        this.pnlLinks.setLayout(null);
        this.pnlLinks.setMinimumSize(new Dimension(5, 5));
        this.pnlLinks.setPreferredSize(new Dimension(5, 5));
        this.pnlLinks.setOpaque(false);
        this.pnlLinks.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                JRViewer.this.pnlLinksMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseReleased(evt);
            }
        });
        this.pnlLinks.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                JRViewer.this.pnlLinksMouseDragged(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.jPanel4.add((Component)this.pnlLinks, gridBagConstraints);
        this.jPanel5.setBackground(Color.gray);
        this.jPanel5.setMinimumSize(new Dimension(5, 5));
        this.jPanel5.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.jPanel4.add((Component)this.jPanel5, gridBagConstraints);
        this.jPanel6.setMinimumSize(new Dimension(5, 5));
        this.jPanel6.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanel7.setBackground(Color.gray);
        this.jPanel7.setMinimumSize(new Dimension(5, 5));
        this.jPanel7.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.jPanel4.add((Component)this.jPanel7, gridBagConstraints);
        this.jPanel8.setBackground(Color.gray);
        this.jPanel8.setMinimumSize(new Dimension(5, 5));
        this.jPanel8.setPreferredSize(new Dimension(5, 5));
        this.jLabel1.setText("jLabel1");
        this.jPanel8.add(this.jLabel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        this.jPanel4.add((Component)this.jPanel8, gridBagConstraints);
        this.jPanel9.setMinimumSize(new Dimension(5, 5));
        this.jPanel9.setPreferredSize(new Dimension(5, 5));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.jPanel4.add((Component)this.jPanel9, gridBagConstraints);
        this.lblPage.setBackground(Color.white);
        this.lblPage.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.lblPage.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel4.add((Component)this.lblPage, gridBagConstraints);
        this.pnlPage.add((Component)this.jPanel4, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.pnlInScroll.add((Component)this.pnlPage, gridBagConstraints);
        this.scrollPane.setViewportView(this.pnlInScroll);
        this.pnlMain.add((Component)this.scrollPane, "Center");
        this.add((Component)this.pnlMain, "Center");
        this.pnlStatus.setLayout(new FlowLayout(1, 0, 0));
        this.lblStatus.setFont(new Font("Dialog", 1, 10));
        this.lblStatus.setText("Page i of n");
        this.pnlStatus.add(this.lblStatus);
        this.add((Component)this.pnlStatus, "South");
    }

    private void txtGoToActionPerformed(ActionEvent evt) {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber != this.pageIndex + 1 && pageNumber > 0 && pageNumber <= this.jasperPrint.getPages().size()) {
                this.setPageIndex(pageNumber - 1);
                this.refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void cmbZoomItemStateChanged(ItemEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    private void pnlMainComponentResized(ComponentEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.setZoomRatio(((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight());
        } else if (this.btnFitWidth.isSelected()) {
            this.setZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
        }
    }

    private void btnActualSizeActionPerformed(ActionEvent evt) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.setZoomRatio(1.0f);
        }
    }

    private void btnFitWidthActionPerformed(ActionEvent evt) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.setZoomRatio(((float)this.pnlInScroll.getVisibleRect().getWidth() - 20.0f) / (float)this.jasperPrint.getPageWidth());
        }
    }

    private void btnFitPageActionPerformed(ActionEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.setZoomRatio(((float)this.pnlInScroll.getVisibleRect().getHeight() - 20.0f) / (float)this.jasperPrint.getPageHeight());
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        FileFilter jrprintFileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().toLowerCase().endsWith(".jrprint");
            }

            public String getDescription() {
                return "JasperReports (*.jrprint)";
            }
        };
        fileChooser.addChoosableFileFilter(jrprintFileFilter);
        JRSaveContributor pdfSaveContrib = null;
        try {
            Class pdfSaveContribClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRPdfSaveContributor");
            pdfSaveContrib = (JRSaveContributor)pdfSaveContribClass.newInstance();
            fileChooser.addChoosableFileFilter(pdfSaveContrib);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor htmlSaver = null;
        try {
            Class htmlSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRHtmlSaveContributor");
            htmlSaver = (JRSaveContributor)htmlSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(htmlSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor xlsSingleSheetSaver = null;
        try {
            Class xlsSingleSheetSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor");
            xlsSingleSheetSaver = (JRSaveContributor)xlsSingleSheetSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(xlsSingleSheetSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor xlsMultipleSheetsSaver = null;
        try {
            Class xlsMultipleSheetsSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor");
            xlsMultipleSheetsSaver = (JRSaveContributor)xlsMultipleSheetsSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(xlsMultipleSheetsSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor csvSaver = null;
        try {
            Class csvSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRCsvSaveContributor");
            csvSaver = (JRSaveContributor)csvSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(csvSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor xmlSaver = null;
        try {
            Class xmlSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JRXmlSaveContributor");
            xmlSaver = (JRSaveContributor)xmlSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(xmlSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        JRSaveContributor xmlEmbeddedImagesSaver = null;
        try {
            Class xmlEmbeddedImagesSaverClass = JRClassLoader.loadClassForName("net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor");
            xmlEmbeddedImagesSaver = (JRSaveContributor)xmlEmbeddedImagesSaverClass.newInstance();
            fileChooser.addChoosableFileFilter(xmlEmbeddedImagesSaver);
        }
        catch (Exception e) {
            // empty catch block
        }
        fileChooser.setFileFilter(jrprintFileFilter);
        int retValue = fileChooser.showSaveDialog(this);
        if (retValue == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            String lowerCaseFileName = file.getName().toLowerCase();
            try {
                if (fileFilter == jrprintFileFilter) {
                    if (!file.getName().endsWith(".jrprint")) {
                        file = new File(file.getAbsolutePath() + ".jrprint");
                    }
                    JRSaver.saveObject((Object)this.jasperPrint, file);
                } else if (fileFilter instanceof JRSaveContributor) {
                    ((JRSaveContributor)fileFilter).save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".jrprint")) {
                    JRSaver.saveObject((Object)this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".pdf") && pdfSaveContrib != null) {
                    pdfSaveContrib.save(this.jasperPrint, file);
                } else if ((lowerCaseFileName.endsWith(".html") || lowerCaseFileName.endsWith(".htm")) && htmlSaver != null) {
                    htmlSaver.save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".xls") && xlsSingleSheetSaver != null) {
                    xlsSingleSheetSaver.save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".csv") && csvSaver != null) {
                    csvSaver.save(this.jasperPrint, file);
                } else if (lowerCaseFileName.endsWith(".xml") || lowerCaseFileName.endsWith(".jrpxml") && xmlSaver != null) {
                    xmlSaver.save(this.jasperPrint, file);
                } else {
                    if (!file.getName().endsWith(".jrprint")) {
                        file = new File(file.getAbsolutePath() + ".jrprint");
                    }
                    JRSaver.saveObject((Object)this.jasperPrint, file);
                }
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.saving"));
            }
        }
    }

    private void pnlLinksMouseDragged(MouseEvent evt) {
        Container container = this.pnlInScroll.getParent();
        if (container instanceof JViewport) {
            JViewport viewport = (JViewport)container;
            Point point = viewport.getViewPosition();
            int newX = point.x - (evt.getX() - this.downX);
            int newY = point.y - (evt.getY() - this.downY);
            int maxX = this.pnlInScroll.getWidth() - viewport.getWidth();
            int maxY = this.pnlInScroll.getHeight() - viewport.getHeight();
            if (newX < 0) {
                newX = 0;
            }
            if (newX > maxX) {
                newX = maxX;
            }
            if (newY < 0) {
                newY = 0;
            }
            if (newY > maxY) {
                newY = maxY;
            }
            viewport.setViewPosition(new Point(newX, newY));
        }
    }

    private void pnlLinksMouseReleased(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(0));
    }

    private void pnlLinksMousePressed(MouseEvent evt) {
        this.pnlLinks.setCursor(new Cursor(13));
        this.downX = evt.getX();
        this.downY = evt.getY();
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JasperPrintManager.printReport(JRViewer.this.jasperPrint, true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.printing"));
                }
            }
        });
        thread.start();
    }

    private void btnLastActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.jasperPrint.getPages().size() - 1);
        this.refreshPage();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex + 1);
        this.refreshPage();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        this.setPageIndex(this.pageIndex - 1);
        this.refreshPage();
    }

    private void btnFirstActionPerformed(ActionEvent evt) {
        this.setPageIndex(0);
        this.refreshPage();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        if (this.type == 1) {
            try {
                this.loadReport(this.reportFileName, this.isXML);
            }
            catch (JRException e) {
                e.printStackTrace();
                this.jasperPrint = null;
                this.setPageIndex(0);
                this.refreshPage();
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.loading"));
            }
            this.zoom = 0.0f;
            this.setZoomRatio(1.0f);
        }
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        float newZoom = this.getZoomRatio();
        if (newZoom < this.MIN_ZOOM) {
            newZoom = this.MIN_ZOOM;
        }
        if (newZoom > this.MAX_ZOOM) {
            newZoom = this.MAX_ZOOM;
        }
        this.setZoomRatio(newZoom);
    }

    private void hyperlinkClicked(MouseEvent evt) {
        JPanel link = (JPanel)evt.getSource();
        JRPrintHyperlink element = (JRPrintHyperlink)this.linksMap.get(link);
        try {
            JRHyperlinkListener listener = null;
            for (int i = 0; i < this.hyperlinkListeners.size(); ++i) {
                listener = (JRHyperlinkListener)this.hyperlinkListeners.get(i);
                listener.gotoHyperlink(element);
            }
        }
        catch (JRException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.hyperlink"));
        }
    }

    private void setPageIndex(int index) {
        this.pageIndex = index;
        if (this.jasperPrint != null && this.jasperPrint.getPages() != null && this.jasperPrint.getPages().size() > 0) {
            this.btnFirst.setEnabled(this.pageIndex > 0);
            this.btnPrevious.setEnabled(this.pageIndex > 0);
            this.btnNext.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
            this.btnLast.setEnabled(this.pageIndex < this.jasperPrint.getPages().size() - 1);
            this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
            this.txtGoTo.setText("" + (this.pageIndex + 1));
            this.lblStatus.setText(MessageFormat.format(ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("page"), new Integer(this.pageIndex + 1), new Integer(this.jasperPrint.getPages().size())));
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
            this.lblStatus.setText("");
        }
    }

    protected void loadReport(String fileName, boolean isXML) throws JRException {
        this.jasperPrint = isXML ? JRPrintXmlLoader.load(fileName) : (JasperPrint)JRLoader.loadObject(fileName);
        this.type = 1;
        this.isXML = isXML;
        this.reportFileName = fileName;
        this.btnReload.setEnabled(true);
        this.setPageIndex(0);
    }

    protected void loadReport(InputStream is, boolean isXML) throws JRException {
        this.jasperPrint = isXML ? JRPrintXmlLoader.load(is) : (JasperPrint)JRLoader.loadObject(is);
        this.type = 2;
        this.isXML = isXML;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void loadReport(JasperPrint jrPrint) throws JRException {
        this.jasperPrint = jrPrint;
        this.type = 3;
        this.isXML = false;
        this.btnReload.setEnabled(false);
        this.setPageIndex(0);
    }

    protected void refreshPage() {
        if (this.jasperPrint == null || this.jasperPrint.getPages() == null || this.jasperPrint.getPages().size() == 0) {
            this.pnlPage.setVisible(false);
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            if (this.jasperPrint != null) {
                JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("no.pages"));
            }
            return;
        }
        this.pnlPage.setVisible(true);
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.zoom < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.zoom > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
        Image image = null;
        ImageIcon imageIcon = null;
        Dimension dim = new Dimension((int)((float)this.jasperPrint.getPageWidth() * this.zoom) + 8, (int)((float)this.jasperPrint.getPageHeight() * this.zoom) + 8);
        this.pnlPage.setMaximumSize(dim);
        this.pnlPage.setMinimumSize(dim);
        this.pnlPage.setPreferredSize(dim);
        try {
            image = JasperPrintManager.printPageToImage(this.jasperPrint, this.pageIndex, this.zoom);
            imageIcon = new ImageIcon(image);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, ResourceBundle.getBundle("net/sf/jasperreports/view/viewer").getString("error.displaying"));
        }
        this.pnlLinks.removeAll();
        this.linksMap = new HashMap();
        List pages = this.jasperPrint.getPages();
        JRPrintPage page = (JRPrintPage)pages.get(this.pageIndex);
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            String toolTip = null;
            JPanel link = null;
            JRPrintElement element = null;
            JRPrintHyperlink hyperlink = null;
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (!(element instanceof JRPrintHyperlink) || ((JRPrintHyperlink)((Object)element)).getHyperlinkType() == 1) continue;
                hyperlink = (JRPrintHyperlink)((Object)element);
                link = new JPanel();
                link.setCursor(new Cursor(12));
                link.setLocation((int)((float)element.getX() * this.zoom), (int)((float)element.getY() * this.zoom));
                link.setSize((int)((float)element.getWidth() * this.zoom), (int)((float)element.getHeight() * this.zoom));
                link.setOpaque(false);
                toolTip = null;
                switch (hyperlink.getHyperlinkType()) {
                    case 2: {
                        toolTip = hyperlink.getHyperlinkReference();
                        break;
                    }
                    case 3: {
                        if (hyperlink.getHyperlinkAnchor() == null) break;
                        toolTip = "#" + hyperlink.getHyperlinkAnchor();
                        break;
                    }
                    case 4: {
                        if (hyperlink.getHyperlinkPage() == null) break;
                        toolTip = "#page " + hyperlink.getHyperlinkPage();
                        break;
                    }
                    case 5: {
                        toolTip = "";
                        if (hyperlink.getHyperlinkReference() != null) {
                            toolTip = toolTip + hyperlink.getHyperlinkReference();
                        }
                        if (hyperlink.getHyperlinkAnchor() == null) break;
                        toolTip = toolTip + "#" + hyperlink.getHyperlinkAnchor();
                        break;
                    }
                    case 6: {
                        toolTip = "";
                        if (hyperlink.getHyperlinkReference() != null) {
                            toolTip = toolTip + hyperlink.getHyperlinkReference();
                        }
                        if (hyperlink.getHyperlinkPage() == null) break;
                        toolTip = toolTip + "#page " + hyperlink.getHyperlinkPage();
                        break;
                    }
                }
                link.setToolTipText(toolTip);
                link.addMouseListener(this.mouseListener);
                this.pnlLinks.add(link);
                this.linksMap.put(link, element);
            }
        }
        this.lblPage.setIcon(imageIcon);
    }

    private void emptyContainer(Container container) {
        Component[] components = container.getComponents();
        if (components != null) {
            for (int i = 0; i < components.length; ++i) {
                if (!(components[i] instanceof Container)) continue;
                this.emptyContainer((Container)components[i]);
            }
        }
        components = null;
        container.removeAll();
        container = null;
    }

    private float getZoomRatio() {
        float newZoom = this.zoom;
        try {
            newZoom = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newZoom;
    }

    private void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.refreshPage();
            }
        }
    }
}

