/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.HyperLinkableReportElement;
import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.TextReportElement;

public class TextFieldReportElement
extends TextReportElement
implements HyperLinkableReportElement {
    private String classExpression;
    private String group;
    private String evaluationTime;
    private boolean blankWhenNull;
    private boolean stretchWithOverflow;
    private String pattern;
    private String anchorNameExpression = "";
    private String hyperlinkAnchorExpression = "";
    private String hyperlinkPageExpression = "";
    private String hyperlinkReferenceExpression = "";
    private String hyperlinkType = "None";
    protected String hyperlinkTarget = "Self";

    public TextFieldReportElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setText("$F{Field}");
        this.pattern = "";
        this.stretchWithOverflow = false;
        this.blankWhenNull = false;
        this.group = "";
        this.evaluationTime = "Now";
        this.classExpression = "java.lang.String";
        this.hyperlinkType = "None";
        this.anchorNameExpression = "";
        this.setKey("textField");
    }

    public boolean isBlankWhenNull() {
        return this.blankWhenNull;
    }

    public void setBlankWhenNull(boolean blankWhenNull) {
        this.blankWhenNull = blankWhenNull;
    }

    public String getClassExpression() {
        return this.classExpression;
    }

    public void setClassExpression(String classExpression) {
        this.classExpression = classExpression;
    }

    public String getEvaluationTime() {
        return this.evaluationTime;
    }

    public void setEvaluationTime(String evaluationTime) {
        this.evaluationTime = evaluationTime;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public boolean isStretchWithOverflow() {
        return this.stretchWithOverflow;
    }

    public void setStretchWithOverflow(boolean stretchWithOverflow) {
        this.stretchWithOverflow = stretchWithOverflow;
    }

    public String getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    public void setAnchorNameExpression(String anchorNameExpression) {
        this.anchorNameExpression = anchorNameExpression;
    }

    public String getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public void setHyperlinkAnchorExpression(String hyperlinkAnchorExpression) {
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
    }

    public String getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public void setHyperlinkPageExpression(String hyperlinkPageExpression) {
        this.hyperlinkPageExpression = hyperlinkPageExpression;
    }

    public String getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public void setHyperlinkReferenceExpression(String hyperlinkReferenceExpression) {
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
    }

    public String getHyperlinkType() {
        return this.hyperlinkType;
    }

    public void setHyperlinkType(String hyperlinkType) {
        this.hyperlinkType = hyperlinkType;
    }

    public ReportElement cloneMe() {
        TextFieldReportElement newReportElement = new TextFieldReportElement(this.position.x, this.position.y, this.width, this.height);
        this.copyBaseReportElement(newReportElement, this);
        return newReportElement;
    }

    public void copyBaseReportElement(ReportElement destination, ReportElement source) {
        super.copyBaseReportElement(destination, source);
        if (destination instanceof TextFieldReportElement && source instanceof TextFieldReportElement) {
            ((TextFieldReportElement)destination).setBlankWhenNull(((TextFieldReportElement)source).isBlankWhenNull());
            ((TextFieldReportElement)destination).setClassExpression(new String(((TextFieldReportElement)source).getClassExpression()));
            ((TextFieldReportElement)destination).setEvaluationTime(new String(((TextFieldReportElement)source).getEvaluationTime()));
            ((TextFieldReportElement)destination).setGroup(new String(((TextFieldReportElement)source).getGroup()));
            ((TextFieldReportElement)destination).setPattern(new String(((TextFieldReportElement)source).getPattern()));
            ((TextFieldReportElement)destination).setStretchWithOverflow(((TextFieldReportElement)source).isStretchWithOverflow());
            ((HyperLinkableReportElement)((Object)destination)).setAnchorNameExpression(new String(((HyperLinkableReportElement)((Object)source)).getAnchorNameExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkAnchorExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkAnchorExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkPageExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkPageExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkReferenceExpression(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkReferenceExpression()));
            ((HyperLinkableReportElement)((Object)destination)).setHyperlinkType(new String(((HyperLinkableReportElement)((Object)source)).getHyperlinkType()));
        }
    }

    public String getHyperlinkTarget() {
        return this.hyperlinkTarget;
    }

    public void setHyperlinkTarget(String hyperlinkTarget) {
        this.hyperlinkTarget = hyperlinkTarget;
    }
}

