/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.EventListenerList;

public class ColorSelectorPanel
extends JPanel {
    private Color color = Color.BLACK;
    private String value = "[0,0,0]";
    private JButton jButtonSelect;
    private JPanel jPanelColor;
    private JTextField jTextFieldColorValue;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    public ColorSelectorPanel() {
        this.initComponents();
        this.setColor(Color.GRAY);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        Color newColor = ColorSelectorPanel.parseColorString(newValue);
        if (newColor == null) {
            return;
        }
        this.setColor(newColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.value = "[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "]";
        this.jPanelColor.setBackground(color);
        this.jPanelColor.invalidate();
        this.jPanelColor.updateUI();
        this.jTextFieldColorValue.setText(this.getValue());
        this.fireActionListenerActionPerformed(new ActionEvent(this, 0, ""));
    }

    public static Color parseColorString(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (!(newValue = newValue.trim()).startsWith("[") || !newValue.endsWith("]")) {
            return null;
        }
        int r = 0;
        int g = 0;
        int b = 0;
        String rgbValues = newValue.substring(1, newValue.length() - 1);
        try {
            StringTokenizer st = new StringTokenizer(rgbValues, ",", false);
            r = Integer.parseInt(st.nextToken());
            g = Integer.parseInt(st.nextToken());
            b = Integer.parseInt(st.nextToken());
        }
        catch (Exception ex) {
            return null;
        }
        Color c = new Color(r, g, b);
        return c;
    }

    private void initComponents() {
        this.jPanelColor = new JPanel();
        this.jTextFieldColorValue = new JTextField();
        this.jButtonSelect = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBackground(new Color(255, 255, 255));
        this.setMinimumSize(new Dimension(45, 10));
        this.setPreferredSize(new Dimension(75, 22));
        this.jPanelColor.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.jPanelColor.setMaximumSize(new Dimension(18, 18));
        this.jPanelColor.setMinimumSize(new Dimension(18, 8));
        this.jPanelColor.setPreferredSize(new Dimension(18, 18));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.add((Component)this.jPanelColor, gridBagConstraints);
        this.jTextFieldColorValue.setFont(new Font("Dialog", 0, 11));
        this.jTextFieldColorValue.setText("[0,0,0]");
        this.jTextFieldColorValue.setBorder(null);
        this.jTextFieldColorValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel.this.jTextFieldColorValueActionPerformed(evt);
            }
        });
        this.jTextFieldColorValue.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ColorSelectorPanel.this.jTextFieldColorValueFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jTextFieldColorValue, gridBagConstraints);
        this.jButtonSelect.setFont(new Font("Dialog", 0, 11));
        this.jButtonSelect.setText("...");
        this.jButtonSelect.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonSelect.setMinimumSize(new Dimension(19, 10));
        this.jButtonSelect.setPreferredSize(new Dimension(19, 22));
        this.jButtonSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ColorSelectorPanel.this.jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jButtonSelect, gridBagConstraints);
    }

    private void jTextFieldColorValueFocusLost(FocusEvent evt) {
        this.jTextFieldColorValueActionPerformed(null);
    }

    private void jButtonSelectActionPerformed(ActionEvent evt) {
        Color c = JColorChooser.showDialog(this, "Pick a color...", this.getColor());
        if (c != null) {
            this.setColor(c);
        }
    }

    private void jTextFieldColorValueActionPerformed(ActionEvent evt) {
        Color newColor = ColorSelectorPanel.parseColorString(this.jTextFieldColorValue.getText());
        if (newColor == null) {
            this.jTextFieldColorValue.setText(this.getValue());
        }
        if (newColor != null) {
            this.setColor(newColor);
        }
    }

    public synchronized void addActionListener(ActionListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ColorSelectorPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = ColorSelectorPanel.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, listener);
    }

    private void fireActionListenerActionPerformed(ActionEvent event) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$java$awt$event$ActionListener == null ? ColorSelectorPanel.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)listeners[i + 1]).actionPerformed(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

