/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui.sheet;

import it.businesslogic.ireport.ReportElement;
import it.businesslogic.ireport.gui.JReportFrame;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.gui.event.ReportBandChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementChangedEvent;
import it.businesslogic.ireport.gui.event.ReportElementsSelectionEvent;
import it.businesslogic.ireport.gui.event.ReportListener;
import it.businesslogic.ireport.gui.sheet.CategorySheetPanel;
import it.businesslogic.ireport.gui.sheet.ComboBoxSheetProperty;
import it.businesslogic.ireport.gui.sheet.SheetProperty;
import java.util.Enumeration;
import java.util.Vector;

public class ReportElementSheetPanel
extends CategorySheetPanel
implements ReportListener {
    private ComboBoxSheetProperty spBands;
    private SheetProperty spTop;
    private SheetProperty spLeft;
    private SheetProperty spHeight;
    private SheetProperty spWidth;
    private ComboBoxSheetProperty spGroups;
    private ComboBoxSheetProperty spImageGroup;
    private ComboBoxSheetProperty spImageGroup1;
    private ComboBoxSheetProperty spTextFieldGroup;
    private ComboBoxSheetProperty spBarcodeGroup;
    private JReportFrame jrf = null;

    public ReportElementSheetPanel() {
        this.initSheetProperties();
        MainFrame mf = MainFrame.getMainInstance();
        mf.addReportListener(this);
    }

    public void updateSelection() {
        this.removeAllProperties();
        this.recreateSheet();
        this.jrf = MainFrame.getMainInstance().getActiveReportFrame();
        if (this.jrf == null || this.jrf.getSelectedElements().size() == 0) {
            return;
        }
        Vector selectedElements = this.jrf.getSelectedElements();
        ReportElement re = (ReportElement)selectedElements.elementAt(0);
        this.spTop.setValue(new Integer(re.getPosition().x));
        this.spLeft.setValue(new Integer(re.getPosition().y));
        this.updateGroups();
        this.addSheetProperty("Common", this.spBands);
        this.addSheetProperty("Common", this.spTop);
        this.addSheetProperty("Common", this.spLeft);
        this.addSheetProperty("Common", this.spHeight);
        this.addSheetProperty("Common", this.spWidth);
        this.spGroups.setValue(re.getPrintWhenGroupChanges());
        this.addSheetProperty("Common", this.spGroups);
        this.recreateSheet();
    }

    public void reportElementsSelectionChanged(ReportElementsSelectionEvent evt) {
        this.updateSelection();
    }

    public void reportElementsChanged(ReportElementChangedEvent evt) {
        this.updateSelection();
    }

    public void reportBandChanged(ReportBandChangedEvent evt) {
        this.updateSelection();
    }

    protected void initSheetProperties() {
        this.spBands = new ComboBoxSheetProperty("band", "Band");
        this.spTop = new SheetProperty("top", "Top", 6);
        this.spLeft = new SheetProperty("left", "Left", 6);
        this.spHeight = new SheetProperty("height", "Height", 6);
        this.spWidth = new SheetProperty("width", "Width", 6);
        this.spGroups = new ComboBoxSheetProperty("groups", "Print when group change");
        this.spImageGroup = new ComboBoxSheetProperty("img_group", "Evaluation group");
        this.spImageGroup1 = new ComboBoxSheetProperty("chart_group", "Evaluation group");
        this.spTextFieldGroup = new ComboBoxSheetProperty("textfield_group", "Evaluation group");
        this.spBarcodeGroup = new ComboBoxSheetProperty("barcode_group", "Evaluation group");
    }

    protected void updateGroups() {
        if (this.jrf == null) {
            return;
        }
        Vector<String> group_names = new Vector<String>();
        Enumeration e = this.jrf.getReport().getGroups().elements();
        while (e.hasMoreElements()) {
            group_names.addElement("" + e.nextElement());
        }
        this.spGroups.updateValues(group_names, true);
        this.spImageGroup.updateValues(group_names, true);
        this.spImageGroup1.updateValues(group_names, true);
        this.spTextFieldGroup.updateValues(group_names, true);
        this.spBarcodeGroup.updateValues(group_names, true);
    }

    protected void updateBands() {
        this.spBands.updateValues(this.jrf.getReport().getBands(), true);
    }
}

