/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.util;

import it.businesslogic.ireport.util.LanguageChangedEvent;
import it.businesslogic.ireport.util.LanguageChangedListener;
import it.businesslogic.ireport.util.Misc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;

public class I18n {
    public static final String localPackageName = "it/businesslogic/ireport/locale/";
    public static final String baseName = "Ireport";
    private static ResourceBundle oLanguage = null;
    public static Vector languageChangedListeners = null;
    private static Locale currentLocale;

    public static void addOnLanguageChangedListener(LanguageChangedListener listener) {
        languageChangedListeners.add(listener);
    }

    public static List getListOfAvailLanguages() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        try {
            Set names = Misc.getResoucesInPackage(localPackageName);
            Iterator it = names.iterator();
            while (it.hasNext()) {
                Locale model;
                String language;
                int underscorePos;
                String n = (String)it.next();
                String lang = n.substring(n.lastIndexOf(47) + 1);
                if ((lang = lang.substring(0, lang.indexOf(".properties"))).indexOf("_") > 0) {
                    lang = lang.substring(baseName.length() + 1);
                }
                if ((underscorePos = lang.indexOf(95)) == -1) {
                    language = lang;
                    model = new Locale(language);
                } else {
                    language = lang.substring(0, lang.indexOf(95));
                    String country = lang.substring(lang.indexOf(95) + 1);
                    model = new Locale(language, country);
                }
                supportedLocales.add(model);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(supportedLocales, new Comparator(){

            public int compare(Object lhs, Object rhs) {
                Locale ll = (Locale)lhs;
                Locale rl = (Locale)rhs;
                return ll.getDisplayLanguage().compareTo(rl.getDisplayLanguage());
            }
        });
        return supportedLocales;
    }

    public static void setCurrentLocale(String language) {
        I18n.setCurrentLocale(language, null);
    }

    public static void setCurrentLocale(String language, String country) {
        if (language != null && !language.equals("")) {
            if (country != null && !country.equals("")) {
                I18n.setCurrentLocale(new Locale(language, country));
            } else {
                I18n.setCurrentLocale(new Locale(language));
            }
        } else {
            I18n.setCurrentLocale(Locale.getDefault());
        }
    }

    public static void setCurrentLocale(Locale locale) {
        currentLocale = locale;
        oLanguage = null;
        Enumeration enum_listeners = languageChangedListeners.elements();
        while (enum_listeners.hasMoreElements()) {
            try {
                ((LanguageChangedListener)enum_listeners.nextElement()).languageChanged(new LanguageChangedEvent(locale));
            }
            catch (Exception exception) {}
        }
    }

    public static Locale getCurrentLocale() {
        return currentLocale;
    }

    public static String getString(String cID) {
        return I18n.getString(cID, currentLocale);
    }

    public static String getString(String cID, String defaultValue) {
        return I18n.getString(cID, currentLocale, defaultValue);
    }

    public static String getString(String cID, Locale currentLocale) {
        if (oLanguage == null) {
            oLanguage = ResourceBundle.getBundle("it/businesslogic/ireport/locale/Ireport", currentLocale);
        }
        return oLanguage.getString(cID);
    }

    public static String getString(String cID, Locale currentLocale, String defaultValue) {
        try {
            if (oLanguage == null) {
                oLanguage = ResourceBundle.getBundle("it/businesslogic/ireport/locale/Ireport", currentLocale);
            }
            return oLanguage.getString(cID);
        }
        catch (Exception ex) {
            System.out.println("Exception loading cID = " + cID + ": " + ex.getMessage());
            return defaultValue;
        }
    }

    public static String getCurrentLocaleID() {
        return "";
    }

    static {
        languageChangedListeners = new Vector();
        currentLocale = Locale.ENGLISH;
    }
}

