/*
 * Decompiled with CFR 0.152.
 */
package de.muntjak.tinylookandfeel;

import de.muntjak.tinylookandfeel.Theme;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalSeparatorUI;

public class TinyPopupMenuSeparatorUI
extends MetalSeparatorUI {
    public static ComponentUI createUI(JComponent c) {
        return new TinyPopupMenuSeparatorUI();
    }

    public void paint(Graphics g, JComponent c) {
        Dimension s = c.getSize();
        switch (Theme.derivedStyle[Theme.style]) {
            case 0: {
                this.drawTinySeparator(g, c.getSize());
                break;
            }
            case 1: {
                this.drawWinSeparator(g, c.getSize());
                break;
            }
            case 2: {
                this.drawXpSeparator(g, c.getSize());
            }
        }
    }

    private void drawTinySeparator(Graphics g, Dimension s) {
    }

    private void drawWinSeparator(Graphics g, Dimension s) {
        g.setColor(Theme.menuPopupColor[Theme.style].getColor());
        g.fillRect(0, 0, s.width, s.height);
        g.setColor(Theme.menuSepDarkColor[Theme.style].getColor());
        g.drawLine(2, 1, s.width - 3, 1);
        g.setColor(Theme.menuSepLightColor[Theme.style].getColor());
        g.drawLine(2, 2, s.width - 3, 2);
    }

    private void drawXpSeparator(Graphics g, Dimension s) {
        g.setColor(Theme.menuPopupColor[Theme.style].getColor());
        g.fillRect(0, 0, s.width, s.height);
        g.setColor(Theme.menuSepDarkColor[Theme.style].getColor());
        g.drawLine(2, 1, s.width - 3, 1);
    }

    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(0, Theme.menuSeparatorHeight[Theme.derivedStyle[Theme.style]]);
    }
}

