/*
 * Decompiled with CFR 0.152.
 */
package groovy.servlet;

import groovy.lang.Binding;
import groovy.xml.MarkupBuilder;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ServletBinding
extends Binding {
    protected Binding binding = new Binding();
    private ServletResponse response;
    private MarkupBuilder html;

    public ServletBinding(HttpServletRequest request, ServletResponse response, ServletContext sc) {
        this.response = response;
        this.binding.setVariable("request", request);
        this.binding.setVariable("response", response);
        this.binding.setVariable("context", sc);
        this.binding.setVariable("application", sc);
        this.binding.setVariable("session", request.getSession(true));
        Enumeration paramEnum = request.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            String key = (String)paramEnum.nextElement();
            if (this.binding.getVariables().containsKey(key)) continue;
            String[] values = request.getParameterValues(key);
            if (values.length == 1) {
                this.binding.setVariable(key, values[0]);
                continue;
            }
            this.binding.setVariable(key, values);
        }
    }

    public void setVariable(String name, Object value) {
        this.binding.setVariable(name, value);
    }

    public Map getVariables() {
        return this.binding.getVariables();
    }

    public Object getVariable(String name) {
        try {
            if ("out".equals(name)) {
                return this.response.getWriter();
            }
            if ("sout".equals(name)) {
                return this.response.getOutputStream();
            }
            if ("html".equals(name)) {
                if (this.html == null) {
                    this.html = new MarkupBuilder(this.response.getWriter());
                }
                return this.html;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.binding.getVariable(name);
    }
}

