/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerException;
import org.codehaus.groovy.syntax.lexer.TextLexerBase;
import org.codehaus.groovy.syntax.lexer.UnterminatedStringLiteralException;

public class StringLexer
extends TextLexerBase {
    protected String delimiter = null;
    protected char watchFor;
    protected boolean allowGStrings = false;
    protected boolean emptyString = true;
    private int lookahead = 0;
    private char[] characters = new char[3];
    private int[] widths = new int[3];

    public void allowGStrings(boolean allow) {
        this.allowGStrings = allow;
    }

    public Token undelegatedNextToken() throws ReadException, LexerException {
        if (this.emptyString) {
            this.emptyString = false;
            return Token.newString("", this.getStartLine(), this.getStartColumn());
        }
        if (this.finished) {
            return null;
        }
        StringBuffer string = new StringBuffer();
        while (this.la(1) != '\uffff') {
            string.append(this.consume());
        }
        if (this.la(1) == '\uffff' && string.length() == 0) {
            this.finished = true;
        }
        return Token.newString(string.toString(), this.getStartLine(), this.getStartColumn());
    }

    public void delimit(boolean delimit) {
        super.delimit(delimit);
        if (delimit) {
            try {
                if (!this.finished && this.la(1) == '\uffff') {
                    this.finishUp();
                    if (!this.allowGStrings) {
                        this.emptyString = true;
                    }
                }
            }
            catch (Exception e) {
                this.finished = true;
            }
        }
    }

    public void setSource(Lexer source) {
        super.setSource(source);
        this.emptyString = false;
        try {
            char c = source.la();
            switch (c) {
                case '\"': 
                case '\'': {
                    this.mark();
                    source.consume();
                    if (source.la() == c && source.la(2) == c) {
                        source.consume();
                        source.consume();
                        this.delimiter = "" + c + c + c;
                    } else {
                        this.delimiter = "" + c;
                    }
                    this.watchFor = this.delimiter.charAt(0);
                    break;
                }
                default: {
                    throw new GroovyBugError("at the time of StringLexer.setSource(), the source must be on a single or double quote");
                }
            }
            this.restart();
            this.delimit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.unsetSource();
        }
    }

    public void unsetSource() {
        super.unsetSource();
        this.delimiter = null;
        this.finished = true;
        this.emptyString = false;
    }

    public char la() throws LexerException, ReadException {
        return this.la(1);
    }

    public char la(int k) throws LexerException, ReadException {
        if (!this.finished && this.source != null) {
            if (this.delimited) {
                if (k > this.characters.length) {
                    throw new GroovyBugError("StringLexer lookahead tolerance exceeded");
                }
                if (this.lookahead >= k && k >= 1) {
                    this.lookahead = 1;
                    return this.characters[k - 1];
                }
                this.lookahead = 0;
                char c = ' ';
                char c1 = ' ';
                char c2 = ' ';
                int offset = 1;
                int width = 0;
                for (int i = 1; i <= k; ++i) {
                    c1 = this.source.la(offset);
                    block0 : switch (c1) {
                        case '\uffff': {
                            return c1;
                        }
                        case '\\': {
                            c2 = this.source.la(offset + 1);
                            switch (c2) {
                                case '\uffff': {
                                    return c2;
                                }
                                case '\\': {
                                    this.characters[0] = c = '\\';
                                    this.widths[0] = 2;
                                    this.lookahead = 1;
                                    return c;
                                }
                                case 'n': {
                                    c = '\n';
                                    width = 2;
                                    break block0;
                                }
                                case 'r': {
                                    c = '\r';
                                    width = 2;
                                    break block0;
                                }
                                case 't': {
                                    c = '\t';
                                    width = 2;
                                    break block0;
                                }
                                case 'b': {
                                    c = '\b';
                                    width = 2;
                                    break block0;
                                }
                                case 'f': {
                                    c = '\f';
                                    width = 2;
                                    break block0;
                                }
                                case '$': {
                                    if (this.allowGStrings) {
                                        c = c1;
                                        width = 1;
                                        break block0;
                                    }
                                    c = c2;
                                    width = 2;
                                    break block0;
                                }
                                case '\"': 
                                case '\'': {
                                    this.characters[0] = c = c2;
                                    this.widths[0] = 2;
                                    this.lookahead = 1;
                                    return c;
                                }
                            }
                            this.characters[0] = c = '\\';
                            this.widths[0] = 1;
                            this.lookahead = 1;
                            return c;
                        }
                        default: {
                            if (c1 == this.watchFor) {
                                boolean atEnd = true;
                                if (this.delimiter.length() == 1) {
                                    if (this.source.la(offset) != this.watchFor) {
                                        atEnd = false;
                                        c = c1;
                                        break;
                                    }
                                } else {
                                    for (int j = 1; j < this.delimiter.length(); ++j) {
                                        if (this.source.la(offset + j) == this.delimiter.charAt(j)) continue;
                                        atEnd = false;
                                        break;
                                    }
                                }
                                if (atEnd) {
                                    return '\uffff';
                                }
                            }
                            c = c1;
                            width = 1;
                            if (c != 36 || !this.allowGStrings) break;
                            this.lookahead = 0;
                        }
                    }
                    this.characters[this.lookahead] = c;
                    this.widths[this.lookahead] = width;
                    offset += width;
                    ++this.lookahead;
                }
                return c;
            }
            this.lookahead = 0;
            return this.source.la(k);
        }
        return '\uffff';
    }

    public char consume() throws LexerException, ReadException {
        if (!this.finished && this.source != null) {
            char c = '\uffff';
            if (this.delimited) {
                if (this.lookahead < 1) {
                    this.la(1);
                }
                if (this.lookahead >= 1) {
                    c = this.characters[0];
                    for (int i = 0; i < this.widths[0]; ++i) {
                        this.source.consume();
                    }
                    this.lookahead = 0;
                }
                if (this.la(1) == '\uffff') {
                    this.finishUp();
                }
            } else {
                c = this.source.consume();
            }
            this.lookahead = 0;
            return c;
        }
        return '\uffff';
    }

    protected void finishUp() throws LexerException, ReadException {
        for (int i = 0; i < this.delimiter.length(); ++i) {
            char c = this.source.la(1);
            if (c == '\uffff') {
                throw new UnterminatedStringLiteralException(this.getStartLine(), this.getStartColumn());
            }
            if (c != this.delimiter.charAt(i)) {
                throw new GroovyBugError("la() said delimiter [" + this.delimiter + "], finishUp() found [" + c + "]");
            }
            this.source.consume();
        }
        this.finish();
    }
}

