/*
 * JRParameterDialog.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 9 maggio 2003, 17.25
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;


/**
 * @author Administrator
 */
public class JRVariableDialog
    extends javax.swing.JDialog
{

    /** Creates new form JRParameterDialog */
    JRVariable tmpVariable = null;
    Report report = null;

    /**
     * Creates a new JRVariableDialog object.
     * 
     * @param report DOCUMENT ME!
     * @param parent DOCUMENT ME!
     * @param modal DOCUMENT ME!
     */
    public JRVariableDialog(Report report, java.awt.Frame parent, 
                            boolean modal)
    {
        super(parent, modal);
        initComponents();

        this.report = report;
        updateGroups();

        this.jRTextExpressionAreaExpression.setText("");
        this.jRTextExpressionAreaInitialExpression.setText("");
        setTypes();
        this.jComboBoxClassType.setSelectedItem("java.lang.String");
        this.jComboBoxCalculationType.setSelectedItem("Nothing");
        this.jComboBoxResetType.setSelectedItem("Report");

        updateGroups();
        pack();
    }

    /**
     * DOCUMENT ME!
     */
    public void setTypes()
    {
        this.jComboBoxClassType.addItem("java.lang.String");
        this.jComboBoxClassType.addItem("java.lang.Object");
        this.jComboBoxClassType.addItem("java.lang.Boolean");
        this.jComboBoxClassType.addItem("java.lang.Byte");
        this.jComboBoxClassType.addItem("java.util.Date");
        this.jComboBoxClassType.addItem("java.sql.Timestamp");
        this.jComboBoxClassType.addItem("java.sql.Time");
        this.jComboBoxClassType.addItem("java.lang.Double");
        this.jComboBoxClassType.addItem("java.lang.Float");
        this.jComboBoxClassType.addItem("java.lang.Integer");
        this.jComboBoxClassType.addItem("java.io.InputStream");
        this.jComboBoxClassType.addItem("java.lang.Long");
        this.jComboBoxClassType.addItem("java.lang.Short");
        this.jComboBoxClassType.addItem("java.math.BigDecimal");
        this.jComboBoxClassType.addItem(
                "net.sf.jasperreports.engine.JREmptyDataSource");

        this.jComboBoxCalculationType.addItem("Nothing");
        this.jComboBoxCalculationType.addItem("Count");
        this.jComboBoxCalculationType.addItem("Sum");
        this.jComboBoxCalculationType.addItem("Average");
        this.jComboBoxCalculationType.addItem("Lowest");
        this.jComboBoxCalculationType.addItem("Highest");
        this.jComboBoxCalculationType.addItem("StandardDeviation");
        this.jComboBoxCalculationType.addItem("Variance");
        this.jComboBoxCalculationType.addItem("System");

        this.jComboBoxResetType.addItem("None");
        this.jComboBoxResetType.addItem("Report");
        this.jComboBoxResetType.addItem("Page");
        this.jComboBoxResetType.addItem("Column");
        this.jComboBoxResetType.addItem("Group");

        this.jComboBoxIncrementType.addItem("None");
        this.jComboBoxIncrementType.addItem("Report");
        this.jComboBoxIncrementType.addItem("Page");
        this.jComboBoxIncrementType.addItem("Column");
        this.jComboBoxIncrementType.addItem("Group");
    }

    /**
     * DOCUMENT ME!
     */
    public void updateGroups()
    {

        if (getReport() == null)
	{
            jComboBoxResetGroup.removeAllItems();
            jComboBoxResetGroup.addItem("");
        }	
        else
        {
            Misc.updateStringComboBox(jComboBoxResetGroup, 
                                      getReport().getGroups(), true);
            Misc.updateStringComboBox(jComboBoxIncrementGroup, 
                                      getReport().getGroups(), true);
        }
        
    }

    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */


    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents()
    {

        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jTextFieldName = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jComboBoxResetGroup = new javax.swing.JComboBox();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jComboBoxResetType = new javax.swing.JComboBox();
        jComboBoxCalculationType = new javax.swing.JComboBox();
        jLabel6 = new javax.swing.JLabel();
        jComboBoxClassType = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        jRTextExpressionAreaExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jRTextExpressionAreaInitialExpression = new it.businesslogic.ireport.gui.JRTextExpressionArea();
        jLabel8 = new javax.swing.JLabel();
        jTextFieldNameIncrementerFactoryClass = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jComboBoxIncrementType = new javax.swing.JComboBox();
        jComboBoxIncrementGroup = new javax.swing.JComboBox();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setTitle("Add/modify variable");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                closeDialog(evt);
            }
        });

        jLabel1.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel1.setText("Variable name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel1, gridBagConstraints);

        jTextFieldName.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jTextFieldName, gridBagConstraints);

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel2.setText("Calculation type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel2, gridBagConstraints);

        jComboBoxResetGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxResetGroup, gridBagConstraints);

        jLabel3.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel3.setText("Variable expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel3, gridBagConstraints);

        jLabel4.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel4.setText("Initial value expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel4, gridBagConstraints);

        jLabel5.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel5.setText("Variable class type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel5, gridBagConstraints);

        jComboBoxResetType.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxResetType, gridBagConstraints);

        jComboBoxCalculationType.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxCalculationType, gridBagConstraints);

        jLabel6.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel6.setText("Reset group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel6, gridBagConstraints);

        jComboBoxClassType.setEditable(true);
        jComboBoxClassType.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxClassType, gridBagConstraints);

        jLabel7.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel7.setText("Reset type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel7, gridBagConstraints);

        jRTextExpressionAreaExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaExpression.setCaretVisible(false);
        jRTextExpressionAreaExpression.setElectricScroll(0);
        jRTextExpressionAreaExpression.setMinimumSize(new java.awt.Dimension(
                                                              657, 100));
        jRTextExpressionAreaExpression.setNextFocusableComponent(
                jRTextExpressionAreaInitialExpression);
        jRTextExpressionAreaExpression.setPreferredSize(new java.awt.Dimension(
                                                                325, 70));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jRTextExpressionAreaExpression, 
                             gridBagConstraints);

        jRTextExpressionAreaInitialExpression.setBorder(new javax.swing.border.EtchedBorder());
        jRTextExpressionAreaInitialExpression.setCaretVisible(false);
        jRTextExpressionAreaInitialExpression.setElectricScroll(0);
        jRTextExpressionAreaInitialExpression.setFont(new java.awt.Font(
                                                              "Dialog", 0, 12));
        jRTextExpressionAreaInitialExpression.setMinimumSize(new java.awt.Dimension(
                                                                     657, 100));
        jRTextExpressionAreaInitialExpression.setPreferredSize(new java.awt.Dimension(
                                                                       325, 70));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jRTextExpressionAreaInitialExpression, 
                             gridBagConstraints);

        jLabel8.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel8.setText("Custom Incrementer Factory Class");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel8, gridBagConstraints);

        jTextFieldNameIncrementerFactoryClass.setFont(new java.awt.Font(
                                                              "Dialog", 0, 11));
        jTextFieldNameIncrementerFactoryClass.setNextFocusableComponent(
                jRTextExpressionAreaExpression);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jTextFieldNameIncrementerFactoryClass, 
                             gridBagConstraints);

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jButtonOKActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonOK);

        jButtonCancel.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonCancel.setText("Cancel");
        jButtonCancel.setMnemonic('c');
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt)
            {
                jButtonCancelActionPerformed(evt);
            }
        });

        jPanel1.add(jButtonCancel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jPanel1, gridBagConstraints);

        jLabel9.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel9.setText("Increment type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel9, gridBagConstraints);

        jLabel10.setFont(new java.awt.Font("Dialog", 0, 11));
        jLabel10.setText("Increment group");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jLabel10, gridBagConstraints);

        jComboBoxIncrementType.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxIncrementType, gridBagConstraints);

        jComboBoxIncrementGroup.setFont(new java.awt.Font("Dialog", 0, 11));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        getContentPane().add(jComboBoxIncrementGroup, gridBagConstraints);

        pack();

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width - dialogSize.width) / 2, 
                    (screenSize.height - dialogSize.height) / 2);
    }

    // </editor-fold>//GEN-END:initComponents
    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) //GEN-FIRST:event_jButtonCancelActionPerformed
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    } //GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) //GEN-FIRST:event_jButtonOKActionPerformed
    {

        if (this.jTextFieldName.getText().trim().length() <= 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this, 
                                                      "Please insert a valid variable name!", 
                                                      "Invalid variable!", 
                                                      javax.swing.JOptionPane.WARNING_MESSAGE);

            return;
        }

        tmpVariable = new JRVariable(this.jTextFieldName.getText(), false);
        tmpVariable.setClassType(
                this.jComboBoxClassType.getSelectedItem() + "");
        tmpVariable.setCalculation(
                this.jComboBoxCalculationType.getSelectedItem() + "");
        tmpVariable.setResetType(
                this.jComboBoxResetType.getSelectedItem() + "");
        tmpVariable.setIncrementType(
                this.jComboBoxIncrementType.getSelectedItem() + "");

        //System.out.println(this.jComboBoxIncrementType.getSelectedItem()+"  "+ tmpVariable.getIncrementType());
        tmpVariable.setIncrementerFactoryClass(this.jTextFieldNameIncrementerFactoryClass.getText());

        if (this.jComboBoxClassType.getSelectedItem().toString().trim().length() == 0)
	{
            tmpVariable.setClassType("java.lang.String");
        }

        else
        {
            tmpVariable.setClassType(this.jComboBoxClassType.getSelectedItem().toString().trim());
        }
        
        if (tmpVariable.getResetType().equals("Group"))
        {

            if (this.jComboBoxResetGroup.getSelectedItem() == null || 
                this.jComboBoxResetGroup.getSelectedItem().equals(""))
            {
                javax.swing.JOptionPane.showMessageDialog(this, 
                                                          "Please choose a valid group for the reset type selected!", 
                                                          "Invalid group!", 
                                                          javax.swing.JOptionPane.WARNING_MESSAGE);

                return;
            }

            tmpVariable.setResetGroup(
                    this.jComboBoxResetGroup.getSelectedItem() + "");
        }

        if (tmpVariable.getIncrementType().equals("Group"))
        {

            if (this.jComboBoxIncrementGroup.getSelectedItem() == null || 
                this.jComboBoxIncrementGroup.getSelectedItem().equals(""))
            {
                javax.swing.JOptionPane.showMessageDialog(this, 
                                                          "Please choose a valid group for the increment type selected!", 
                                                          "Invalid group!", 
                                                          javax.swing.JOptionPane.WARNING_MESSAGE);

                return;
            }

            tmpVariable.setIncrementGroup(
                    this.jComboBoxIncrementGroup.getSelectedItem() + "");
        }

        tmpVariable.setExpression(jRTextExpressionAreaExpression.getText());

        tmpVariable.setInitialValueExpression(jRTextExpressionAreaInitialExpression.getText());

        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.OK_OPTION);
        dispose();
    } //GEN-LAST:event_jButtonOKActionPerformed

    /**
     * Closes the dialog
     * @param evt DOCUMENT ME!
     */
    private void closeDialog(java.awt.event.WindowEvent evt) //GEN-FIRST:event_closeDialog
    {
        setVisible(false);
        this.setDialogResult(javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    } //GEN-LAST:event_closeDialog

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
        new JRParameterDialog(new javax.swing.JFrame(), true).show();
    }

    /**
     * Getter for property tmpParameter.
     * 
     * @return Value of property tmpParameter.
     */
    public it.businesslogic.ireport.JRVariable getVariable()
    {

        return tmpVariable;
    }

    /**
     * Setter for property tmpParameter.
     * 
     * @param tmpVariable New value of property tmpParameter.
     */
    public void setVariable(it.businesslogic.ireport.JRVariable tmpVariable)
    {
        this.jTextFieldName.setText(new String(tmpVariable.getName()));

        this.jComboBoxClassType.setSelectedItem(new String(tmpVariable.getClassType()));
        this.jComboBoxResetType.setSelectedItem(new String(tmpVariable.getResetType()));
        this.jComboBoxIncrementType.setSelectedItem(new String(tmpVariable.getIncrementType()));
        this.jComboBoxCalculationType.setSelectedItem(new String(tmpVariable.getCalculation()));
        this.jComboBoxResetGroup.setSelectedItem(tmpVariable.getResetGroup());
        this.jComboBoxIncrementGroup.setSelectedItem(tmpVariable.getIncrementGroup());

        this.jRTextExpressionAreaExpression.setText(new String(tmpVariable.getExpression()));
        this.jRTextExpressionAreaInitialExpression.setText(new String(tmpVariable.getInitialValueExpression()));
        this.jTextFieldNameIncrementerFactoryClass.setText(new String(tmpVariable.getIncrementerFactoryClass()));
    }

    /**
     * Getter for property dialogResult.
     * 
     * @return Value of property dialogResult.
     */
    public int getDialogResult()
    {

        return dialogResult;
    }

    /**
     * Setter for property dialogResult.
     * 
     * @param dialogResult New value of property dialogResult.
     */
    public void setDialogResult(int dialogResult)
    {
        this.dialogResult = dialogResult;
    }

    /**
     * Getter for property report.
     * 
     * @return Value of property report.
     */
    public it.businesslogic.ireport.Report getReport()
    {

        return report;
    }

    /**
     * Setter for property report.
     * 
     * @param report New value of property report.
     */
    public void setReport(it.businesslogic.ireport.Report report)
    {
        this.report = report;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JComboBox jComboBoxCalculationType;
    private javax.swing.JComboBox jComboBoxClassType;
    private javax.swing.JComboBox jComboBoxIncrementGroup;
    private javax.swing.JComboBox jComboBoxIncrementType;
    private javax.swing.JComboBox jComboBoxResetGroup;
    private javax.swing.JComboBox jComboBoxResetType;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaExpression;
    private it.businesslogic.ireport.gui.JRTextExpressionArea jRTextExpressionAreaInitialExpression;
    private javax.swing.JTextField jTextFieldName;
    private javax.swing.JTextField jTextFieldNameIncrementerFactoryClass;

    // End of variables declaration//GEN-END:variables
    private int dialogResult;
}
