/*
 * ValuesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 7 maggio 2003, 23.43
 */

package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.*;

import javax.swing.table.*;
import javax.swing.*;
import javax.swing.event.*;
import it.businesslogic.ireport.*;
import it.businesslogic.ireport.util.*;

import java.util.*;
/**
 *
 * @author  Administrator
 */
public class PropertiesDialog extends javax.swing.JDialog {
    
    /** Creates new form ValuesDialog */
    public PropertiesDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.setSize(420, 250);
        //DefaultTableColumnModel dtcm = (DefaultTableColumnModel)jTableParameters.getColumnModel();
        //DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)dtcm.getColumn(0).getHeaderRenderer();
        
        //new DefaultTableCellRenderer();
        //tcr.setFont(jTableParameters.getFont());
        //tcr.setBackground(this.getBackground());
        //tcr.setBorder( new javax.swing.border.BevelBorder( javax.swing.border.BevelBorder.RAISED));
        //dtcm.getColumn(0).setHeaderRenderer(tcr);
        
        
        DefaultListSelectionModel dlsm =  (DefaultListSelectionModel)this.jTableProperties.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)  {
                jTablePropertiesListSelectionValueChanged(e);
            }
        });     
            
	applyI18n();
        // Open in center...
        it.businesslogic.ireport.util.Misc.centerFrame(this);
    }
    
    
    public void jTablePropertiesListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {
         if (this.jTableProperties.getSelectedRowCount() > 0) {
            this.jButtonModifyProperty.setEnabled(true);
            this.jButtonDeleteProperty.setEnabled(true);
        }
        else {
            this.jButtonModifyProperty.setEnabled(false);
            this.jButtonDeleteProperty.setEnabled(false);
        }
    }
    
  
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
        private void initComponents() {//GEN-BEGIN:initComponents
                java.awt.GridBagConstraints gridBagConstraints;

                jPanelFields = new javax.swing.JPanel();
                jScrollPane3 = new javax.swing.JScrollPane();
                jTableProperties = new it.businesslogic.ireport.gui.JDragTable();
                jPanelButtons2 = new javax.swing.JPanel();
                jButtonNewProperty = new javax.swing.JButton();
                jButtonModifyProperty = new javax.swing.JButton();
                jButtonDeleteProperty = new javax.swing.JButton();
                jPanel1 = new javax.swing.JPanel();
                jButtonClose = new javax.swing.JButton();

                setTitle("Values");
                addWindowListener(new java.awt.event.WindowAdapter() {
                        public void windowClosing(java.awt.event.WindowEvent evt) {
                                closeDialog(evt);
                        }
                });

                jPanelFields.setLayout(new java.awt.BorderLayout());

                jScrollPane3.setBackground(new java.awt.Color(255, 255, 255));
                jScrollPane3.setFont(new java.awt.Font("Dialog", 0, 11));
                jScrollPane3.setPreferredSize(new java.awt.Dimension(32767, 32767));
                jScrollPane3.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mouseClicked(java.awt.event.MouseEvent evt) {
                                jScrollPane3MouseClicked(evt);
                        }
                });

                jTableProperties.setModel(new javax.swing.table.DefaultTableModel(
                        new Object [][] {

                        },
                        new String [] {
                                "Name", "Value"
                        }
                ) {
                        Class[] types = new Class [] {
                                java.lang.Object.class, java.lang.String.class
                        };
                        boolean[] canEdit = new boolean [] {
                                false, false
                        };

                        public Class getColumnClass(int columnIndex) {
                                return types [columnIndex];
                        }

                        public boolean isCellEditable(int rowIndex, int columnIndex) {
                                return canEdit [columnIndex];
                        }
                });
                jTableProperties.addMouseListener(new java.awt.event.MouseAdapter() {
                        public void mouseClicked(java.awt.event.MouseEvent evt) {
                                jTablePropertiesMouseClicked(evt);
                        }
                });

                jScrollPane3.setViewportView(jTableProperties);

                jPanelFields.add(jScrollPane3, java.awt.BorderLayout.CENTER);

                jPanelButtons2.setLayout(new java.awt.GridBagLayout());

                jPanelButtons2.setPreferredSize(new java.awt.Dimension(100, 100));
                jPanelButtons2.setMinimumSize(new java.awt.Dimension(100, 10));
                jButtonNewProperty.setText("New");
                jButtonNewProperty.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonNewPropertyActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(5, 4, 0, 4);
                jPanelButtons2.add(jButtonNewProperty, gridBagConstraints);

                jButtonModifyProperty.setText("Modify");
                jButtonModifyProperty.setEnabled(false);
                jButtonModifyProperty.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonModifyPropertyActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(3, 4, 0, 4);
                jPanelButtons2.add(jButtonModifyProperty, gridBagConstraints);

                jButtonDeleteProperty.setText("Delete");
                jButtonDeleteProperty.setEnabled(false);
                jButtonDeleteProperty.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonDeletePropertyActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
                jPanelButtons2.add(jButtonDeleteProperty, gridBagConstraints);

                jPanel1.setLayout(new java.awt.BorderLayout());

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.weighty = 1.0;
                jPanelButtons2.add(jPanel1, gridBagConstraints);

                jButtonClose.setText("Close");
                jButtonClose.setMnemonic('c');
                jButtonClose.addActionListener(new java.awt.event.ActionListener() {
                        public void actionPerformed(java.awt.event.ActionEvent evt) {
                                jButtonCloseActionPerformed(evt);
                        }
                });

                gridBagConstraints = new java.awt.GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 4;
                gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
                gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
                gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
                jPanelButtons2.add(jButtonClose, gridBagConstraints);

                jPanelFields.add(jPanelButtons2, java.awt.BorderLayout.EAST);

                getContentPane().add(jPanelFields, java.awt.BorderLayout.CENTER);

                pack();
        }//GEN-END:initComponents

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        setVisible(false);
    }//GEN-LAST:event_jButtonCloseActionPerformed

    private void jScrollPane3MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jScrollPane3MouseClicked
        // Add your handling code here:
    }//GEN-LAST:event_jScrollPane3MouseClicked

    private void jTablePropertiesMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTablePropertiesMouseClicked
        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 &&  jTableProperties.getSelectedRow() >=0 ) {
            jButtonModifyPropertyActionPerformed(new java.awt.event.ActionEvent( jButtonModifyProperty,0, ""));
        }
    }//GEN-LAST:event_jTablePropertiesMouseClicked

    private void jButtonNewPropertyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonNewPropertyActionPerformed
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog( parent, true);
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            JRProperty property = jrpd.getProperty();
            this.getJReportFrame().getReport().addJRProperty( property );
            this.updateProperties();
        }
    }//GEN-LAST:event_jButtonNewPropertyActionPerformed

    private void jButtonModifyPropertyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonModifyPropertyActionPerformed
        JRProperty property = (JRProperty)jTableProperties.getValueAt( jTableProperties.getSelectedRow(), 0);
        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRPropertyDialog jrpd = new JRPropertyDialog(parent, true);
        jrpd.setProperty( property );
        jrpd.show();
        
        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION) {
            property.setName( jrpd.getProperty().getName() );
            
            
            property.setValue( jrpd.getProperty().getValue() );
            
            this.updateProperties();
        }
    }//GEN-LAST:event_jButtonModifyPropertyActionPerformed

    private void jButtonDeletePropertyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonDeletePropertyActionPerformed
        jTableProperties.getSelectedRows();
        int[]  rows= jTableProperties.getSelectedRows();
        for (int i=rows.length-1; i>=0; --i) {
            this.getJReportFrame().getReport().removeJRProperty( (JRProperty) jTableProperties.getValueAt( rows[i], 0) );
            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
        updateProperties();
    }//GEN-LAST:event_jButtonDeletePropertyActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ValuesDialog(new javax.swing.JFrame(), true).show();
    }
    
    /** Getter for property jReportFrame.
     * @return Value of property jReportFrame.
     *
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame() {
        return jReportFrame;
    }
    
    /** Setter for property jReportFrame.
     * @param jReportFrame New value of property jReportFrame.
     *
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame) {
        this.jReportFrame = jReportFrame;
        
        // Update all...
        if (jReportFrame == null) 
        {
            setVisible(false);
            return;
        }
        
        if (isVisible())
        {
            this.setTitle(jReportFrame.getReport().getName()+" values...");
            updateProperties();
        }
    }
    
    public void updateProperties() {
        
        DefaultTableModel dtm = (DefaultTableModel)jTableProperties.getModel();
        dtm.setRowCount(0);
    
        Enumeration e = jReportFrame.getReport().getJRproperties().elements();
        while (e.hasMoreElements())
        {
            it.businesslogic.ireport.JRProperty property = (it.businesslogic.ireport.JRProperty)e.nextElement();
            Vector row = new Vector();
            row.addElement( property);
            row.addElement( property.getValue());
            
            dtm.addRow(row);           
        }    
    }
    public void applyI18n(){
        jButtonNewProperty.setText(it.businesslogic.ireport.util.I18n.getString("new","New"));
        jButtonModifyProperty.setText(it.businesslogic.ireport.util.I18n.getString("modify","Modify"));
        jButtonDeleteProperty.setText(it.businesslogic.ireport.util.I18n.getString("delete","Delete"));
        jButtonClose.setText(it.businesslogic.ireport.util.I18n.getString("close","Close"));
    }      
    public void languageChanged(LanguageChangedEvent evt) {
            
        this.applyI18n();
    }
       
        // Variables declaration - do not modify//GEN-BEGIN:variables
        private javax.swing.JButton jButtonClose;
        private javax.swing.JButton jButtonDeleteProperty;
        private javax.swing.JButton jButtonModifyProperty;
        private javax.swing.JButton jButtonNewProperty;
        private javax.swing.JPanel jPanel1;
        private javax.swing.JPanel jPanelButtons2;
        private javax.swing.JPanel jPanelFields;
        private javax.swing.JScrollPane jScrollPane3;
        private it.businesslogic.ireport.gui.JDragTable jTableProperties;
        // End of variables declaration//GEN-END:variables

    private JReportFrame jReportFrame;    

    public void setVisible(boolean visible)
    {
        if (visible == isVisible()) return;
        super.setVisible(visible);
        if (visible == true) 
        {
            this.setJReportFrame(jReportFrame);
        }
    }
   
   }
