/*
 * ValuesDialog.java
 *
 * iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 * Created on 7 maggio 2003, 23.43
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.*;
import it.businesslogic.ireport.gui.event.*;
import it.businesslogic.ireport.util.*;

import java.util.*;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;


/**
 * @author Administrator
 */
public class ValuesDialog
    extends javax.swing.JDialog
    implements ReportObjectChangedListener
{

    private Vector clipboardFields = null;
    private Vector clipboardVariables = null;
    private Vector clipboardParameters = null;

    /**
     * Creates new form ValuesDialog
     * @param parent DOCUMENT ME!
     * @param modal DOCUMENT ME!
     */
    public ValuesDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();

        setClipboardFields(new Vector());
        setClipboardVariables(new Vector());
        setClipboardParameters(new Vector());

        this.setSize(500, 300);

        //DefaultTableColumnModel dtcm = (DefaultTableColumnModel)jTableParameters.getColumnModel();
        //DefaultTableCellRenderer tcr = (DefaultTableCellRenderer)dtcm.getColumn(0).getHeaderRenderer();

        //new DefaultTableCellRenderer();
        //tcr.setFont(jTableParameters.getFont());
        //tcr.setBackground(this.getBackground());
        //tcr.setBorder( new javax.swing.border.BevelBorder( javax.swing.border.BevelBorder.RAISED));
        //dtcm.getColumn(0).setHeaderRenderer(tcr);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel) this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)
            {
                jTableParametersListSelectionValueChanged(e);
            }
        });

        dlsm = (DefaultListSelectionModel) this.jTableVariables.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)
            {
                jTableVariablesListSelectionValueChanged(e);
            }
        });

        dlsm = (DefaultListSelectionModel) this.jTableFields.getSelectionModel();
        dlsm.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e)
            {
                jTableFieldsListSelectionValueChanged(e);
            }
        });

        applyI18n();

        // Open in center...
        it.businesslogic.ireport.util.Misc.centerFrame(this);
    }

    /**
     * DOCUMENT ME!
     * 
     * @param e DOCUMENT ME!
     */
    public void jTableParametersListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {

        if (this.jTableParameters.getSelectedRowCount() > 0)
        {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);

            // if more than one row is selected and one of them is a built-in parameter then
            // the buttons must be disabled
            int[] rows = jTableParameters.getSelectedRows();

            for (int i = rows.length - 1; i >= 0; --i)
            {

                if (((JRParameter) jTableParameters.getValueAt(rows[ i ], 0)).isBuiltin())
                {
                    this.jButtonModifyParameter.setEnabled(false);
                    this.jButtonDeleteParameter.setEnabled(false);
                }
            }

        }
        else
        {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
        }

    }

    /**
     * DOCUMENT ME!
     * 
     * @param e DOCUMENT ME!
     */
    public void jTableVariablesListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {

        if (this.jTableVariables.getSelectedRowCount() > 0)
        {
            this.jButtonModifyVariable.setEnabled(true);
            this.jButtonDeleteVariable.setEnabled(true);

            // if more than one row is selected and one of them is a built-in variable then
            // the buttons must be disabled
            int[] rows = jTableVariables.getSelectedRows();

            for (int i = rows.length - 1; i >= 0; --i)
            {

                if (((JRVariable) jTableVariables.getValueAt(rows[ i ], 0)).isBuiltin())
                {
                    this.jButtonModifyVariable.setEnabled(false);
                    this.jButtonDeleteVariable.setEnabled(false);
                }
            }

        }
        else
        {
            this.jButtonModifyVariable.setEnabled(false);
            this.jButtonDeleteVariable.setEnabled(false);
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param e DOCUMENT ME!
     */
    public void jTableFieldsListSelectionValueChanged(javax.swing.event.ListSelectionEvent e)
    {

        if (this.jTableFields.getSelectedRowCount() > 0)
        {
            this.jButtonModifyField.setEnabled(true);
            this.jButtonDeleteField.setEnabled(true);
        }
        else
        {
            this.jButtonModifyField.setEnabled(false);
            this.jButtonDeleteField.setEnabled(false);
        }
    }

    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */


    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jPopupMenuFields = new javax.swing.JPopupMenu();
        jMenuItemCut = new javax.swing.JMenuItem();
        jMenuItemCopy = new javax.swing.JMenuItem();
        jMenuItemPaste = new javax.swing.JMenuItem();
        jMenuItemDelete = new javax.swing.JMenuItem();
        jMenuItemDuplicate = new javax.swing.JMenuItem();
        jPopupMenuVariables = new javax.swing.JPopupMenu();
        jMenuItemCut1 = new javax.swing.JMenuItem();
        jMenuItemCopy1 = new javax.swing.JMenuItem();
        jMenuItemPaste1 = new javax.swing.JMenuItem();
        jMenuItemDelete1 = new javax.swing.JMenuItem();
        jMenuItemDuplicate1 = new javax.swing.JMenuItem();
        jPopupMenuParameters = new javax.swing.JPopupMenu();
        jMenuItemCut2 = new javax.swing.JMenuItem();
        jMenuItemCopy2 = new javax.swing.JMenuItem();
        jMenuItemPaste2 = new javax.swing.JMenuItem();
        jMenuItemDelete2 = new javax.swing.JMenuItem();
        jMenuItemDuplicate2 = new javax.swing.JMenuItem();
        jTabbedPane = new javax.swing.JTabbedPane();
        jPanelFields = new javax.swing.JPanel();
        jScrollPane3 = new javax.swing.JScrollPane();
        jTableFields = new it.businesslogic.ireport.gui.JDragTable();
        jPanelButtons2 = new javax.swing.JPanel();
        jButtonNewField = new javax.swing.JButton();
        jButtonModifyField = new javax.swing.JButton();
        jButtonDeleteField = new javax.swing.JButton();
        jPanelVariables = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTableVariables = new it.businesslogic.ireport.gui.JDragTable();
        jPanelButtons1 = new javax.swing.JPanel();
        jButtonNewVariable = new javax.swing.JButton();
        jButtonModifyVariable = new javax.swing.JButton();
        jButtonDeleteVariable = new javax.swing.JButton();
        jPanelParameters = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTableParameters = new it.businesslogic.ireport.gui.JDragTable();
        jPanelButtons = new javax.swing.JPanel();
        jButtonNewParameter = new javax.swing.JButton();
        jButtonModifyParameter = new javax.swing.JButton();
        jButtonDeleteParameter = new javax.swing.JButton();

        jPopupMenuFields.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });

        jMenuItemCut.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCut.setText("Item");
        jMenuItemCut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCutActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemCut);

        jMenuItemCopy.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCopy.setText("Item");
        jMenuItemCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemCopy);

        jMenuItemPaste.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPaste.setText("Item");
        jMenuItemPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPasteActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemPaste);

        jMenuItemDelete.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDelete.setText("Item");
        jMenuItemDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemDelete);

        jMenuItemDuplicate.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDuplicate.setText("Item");
        jMenuItemDuplicate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDuplicateActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemDuplicate);

        jPopupMenuVariables.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
                jPopupMenuVariablesPopupMenuWillBecomeInvisible(evt);
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                jPopupMenuVariablesPopupMenuWillBecomeVisible(evt);
            }
        });

        jMenuItemCut1.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCut1.setText("Item");
        jMenuItemCut1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCut1ActionPerformed(evt);
            }
        });

        jPopupMenuVariables.add(jMenuItemCut1);

        jMenuItemCopy1.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCopy1.setText("Item");
        jMenuItemCopy1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopy1ActionPerformed(evt);
            }
        });

        jPopupMenuVariables.add(jMenuItemCopy1);

        jMenuItemPaste1.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPaste1.setText("Item");
        jMenuItemPaste1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPaste1ActionPerformed(evt);
            }
        });

        jPopupMenuVariables.add(jMenuItemPaste1);

        jMenuItemDelete1.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDelete1.setText("Item");
        jMenuItemDelete1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDelete1ActionPerformed(evt);
            }
        });

        jPopupMenuVariables.add(jMenuItemDelete1);

        jMenuItemDuplicate1.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDuplicate1.setText("Item");
        jMenuItemDuplicate1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDuplicate1ActionPerformed(evt);
            }
        });

        jPopupMenuVariables.add(jMenuItemDuplicate1);

        jPopupMenuParameters.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                jPopupMenuParametersPopupMenuWillBecomeVisible(evt);
            }
        });

        jMenuItemCut2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCut2.setText("Item");
        jMenuItemCut2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCut2ActionPerformed(evt);
            }
        });

        jPopupMenuParameters.add(jMenuItemCut2);

        jMenuItemCopy2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCopy2.setText("Item");
        jMenuItemCopy2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopy2ActionPerformed(evt);
            }
        });

        jPopupMenuParameters.add(jMenuItemCopy2);

        jMenuItemPaste2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPaste2.setText("Item");
        jMenuItemPaste2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPaste2ActionPerformed(evt);
            }
        });

        jPopupMenuParameters.add(jMenuItemPaste2);

        jMenuItemDelete2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDelete2.setText("Item");
        jMenuItemDelete2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDelete2ActionPerformed(evt);
            }
        });

        jPopupMenuParameters.add(jMenuItemDelete2);

        jMenuItemDuplicate2.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDuplicate2.setText("Item");
        jMenuItemDuplicate2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDuplicate2ActionPerformed(evt);
            }
        });

        jPopupMenuParameters.add(jMenuItemDuplicate2);

        setTitle("Values");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jTabbedPane.setName("");
        jPanelFields.setLayout(new java.awt.BorderLayout());

        jScrollPane3.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane3.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jScrollPane3MouseClicked(evt);
            }
        });

        jTableFields.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Field name", "Class type"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableFields.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableFieldsMouseClicked(evt);
            }
        });

        jScrollPane3.setViewportView(jTableFields);

        jPanelFields.add(jScrollPane3, java.awt.BorderLayout.CENTER);

        jPanelButtons2.setLayout(null);

        jPanelButtons2.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelButtons2.setPreferredSize(new java.awt.Dimension(100, 10));
        jButtonNewField.setText("New");
        jButtonNewField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewFieldActionPerformed(evt);
            }
        });

        jPanelButtons2.add(jButtonNewField);
        jButtonNewField.setBounds(4, 5, 92, 22);

        jButtonModifyField.setText("Modify");
        jButtonModifyField.setEnabled(false);
        jButtonModifyField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyFieldActionPerformed(evt);
            }
        });

        jPanelButtons2.add(jButtonModifyField);
        jButtonModifyField.setBounds(4, 30, 92, 22);

        jButtonDeleteField.setText("Delete");
        jButtonDeleteField.setEnabled(false);
        jButtonDeleteField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteFieldActionPerformed(evt);
            }
        });

        jPanelButtons2.add(jButtonDeleteField);
        jButtonDeleteField.setBounds(4, 56, 92, 22);

        jPanelFields.add(jPanelButtons2, java.awt.BorderLayout.EAST);

        jTabbedPane.addTab("Fields", jPanelFields);

        jPanelVariables.setLayout(new java.awt.BorderLayout());

        jScrollPane2.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jScrollPane2MouseClicked(evt);
            }
        });

        jTableVariables.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Variable name", "Builtin"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableVariables.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableVariablesMouseClicked(evt);
            }
        });

        jScrollPane2.setViewportView(jTableVariables);

        jPanelVariables.add(jScrollPane2, java.awt.BorderLayout.CENTER);

        jPanelButtons1.setLayout(null);

        jPanelButtons1.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelButtons1.setPreferredSize(new java.awt.Dimension(100, 10));
        jButtonNewVariable.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonNewVariable.setText("New");
        jButtonNewVariable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewVariableActionPerformed(evt);
            }
        });

        jPanelButtons1.add(jButtonNewVariable);
        jButtonNewVariable.setBounds(4, 5, 92, 22);

        jButtonModifyVariable.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModifyVariable.setText("Modify");
        jButtonModifyVariable.setEnabled(false);
        jButtonModifyVariable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyVariableActionPerformed(evt);
            }
        });

        jPanelButtons1.add(jButtonModifyVariable);
        jButtonModifyVariable.setBounds(4, 30, 92, 22);

        jButtonDeleteVariable.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteVariable.setText("Delete");
        jButtonDeleteVariable.setEnabled(false);
        jButtonDeleteVariable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteVariableActionPerformed(evt);
            }
        });

        jPanelButtons1.add(jButtonDeleteVariable);
        jButtonDeleteVariable.setBounds(4, 56, 92, 22);

        jPanelVariables.add(jPanelButtons1, java.awt.BorderLayout.EAST);

        jTabbedPane.addTab("Variables", jPanelVariables);

        jPanelParameters.setLayout(new java.awt.BorderLayout(2, 2));

        jScrollPane1.setBackground(new java.awt.Color(255, 255, 255));
        jScrollPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jScrollPane1MouseClicked(evt);
            }
        });

        jTableParameters.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {
                "Parameter name", "Class type", "Is for prompting", "Built-in"
            }
        ) {
            boolean[] canEdit = new boolean [] {
                false, false, false, false
            };

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
        });
        jTableParameters.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTableParametersMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jTableParameters);

        jPanelParameters.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        jPanelButtons.setLayout(null);

        jPanelButtons.setMinimumSize(new java.awt.Dimension(100, 10));
        jPanelButtons.setPreferredSize(new java.awt.Dimension(100, 10));
        jButtonNewParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonNewParameter.setText("New");
        jButtonNewParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonNewParameter);
        jButtonNewParameter.setBounds(4, 5, 92, 22);

        jButtonModifyParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonModifyParameter.setText("Modify");
        jButtonModifyParameter.setEnabled(false);
        jButtonModifyParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonModifyParameter);
        jButtonModifyParameter.setBounds(4, 30, 92, 22);

        jButtonDeleteParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jButtonDeleteParameter.setText("Delete");
        jButtonDeleteParameter.setEnabled(false);
        jButtonDeleteParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteParameterActionPerformed(evt);
            }
        });

        jPanelButtons.add(jButtonDeleteParameter);
        jButtonDeleteParameter.setBounds(4, 56, 92, 22);

        jPanelParameters.add(jPanelButtons, java.awt.BorderLayout.EAST);

        jTabbedPane.addTab("Parameters", jPanelParameters);

        getContentPane().add(jTabbedPane, java.awt.BorderLayout.CENTER);

        pack();
    }
    // </editor-fold>//GEN-END:initComponents
    private void jScrollPane1MouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jScrollPane1MouseClicked
    {

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jPopupMenuParameters.show(jScrollPane1, evt.getPoint().x, 
                                      evt.getPoint().y);
        }
    }//GEN-LAST:event_jScrollPane1MouseClicked

    private void jPopupMenuParametersPopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt)//GEN-FIRST:event_jPopupMenuParametersPopupMenuWillBecomeVisible
    {

        if (getClipboardParameters().size() > 0)
        {
            jMenuItemPaste2.setEnabled(true);
        }
        else
        {
            jMenuItemPaste2.setEnabled(false);
        }

        if (jTableParameters.getSelectedRowCount() > 0)
        {
            jMenuItemCut2.setEnabled(true);
            jMenuItemCopy2.setEnabled(true);
            jMenuItemDelete2.setEnabled(true);
            jMenuItemDuplicate2.setEnabled(true);
        }
        else
        {
            jMenuItemCut2.setEnabled(false);
            jMenuItemCopy2.setEnabled(false);
            jMenuItemDelete2.setEnabled(false);
            jMenuItemDuplicate2.setEnabled(false);
        }
    }//GEN-LAST:event_jPopupMenuParametersPopupMenuWillBecomeVisible

    private void jMenuItemDuplicate2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDuplicate2ActionPerformed
    {

        Vector selectedParameters = new Vector();
        jTableParameters.getSelectedRows();

        int[] rows = jTableParameters.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            selectedParameters.add(((JRParameter) jTableParameters.getValueAt(
                                            rows[ i ], 0)).cloneMe());
        }

        duplicateParameters(selectedParameters);
    }//GEN-LAST:event_jMenuItemDuplicate2ActionPerformed

    private void jMenuItemDelete2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDelete2ActionPerformed
    {
        jButtonDeleteParameterActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemDelete2ActionPerformed

    private void jMenuItemPaste2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemPaste2ActionPerformed
    {
        duplicateParameters(getClipboardParameters());
    }//GEN-LAST:event_jMenuItemPaste2ActionPerformed

    private void jMenuItemCopy2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCopy2ActionPerformed
    {
        jTableParameters.getSelectedRows();

        int[] rows = jTableParameters.getSelectedRows();
        getClipboardParameters().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            JRParameter parameter = ((JRParameter) jTableParameters.getValueAt(
                                             rows[ i ], 0)).cloneMe();

            if (!parameter.isBuiltin())
            {
                getClipboardParameters().add(parameter);
            }
        }
    }//GEN-LAST:event_jMenuItemCopy2ActionPerformed

    private void jMenuItemCut2ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCut2ActionPerformed
    {

        // Put selected elements in clipboard and call delete...
        jTableParameters.getSelectedRows();

        int[] rows = jTableParameters.getSelectedRows();
        getClipboardParameters().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            JRParameter parameter = ((JRParameter) jTableParameters.getValueAt(
                                             rows[ i ], 0)).cloneMe();

            if (!parameter.isBuiltin())
            {
                getClipboardParameters().add(parameter);
            }
        }

        jButtonDeleteParameterActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemCut2ActionPerformed

    private void jPopupMenuVariablesPopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt)//GEN-FIRST:event_jPopupMenuVariablesPopupMenuWillBecomeVisible
    {

        if (getClipboardVariables().size() > 0)
        {
            jMenuItemPaste1.setEnabled(true);
        }
        else
        {
            jMenuItemPaste1.setEnabled(false);
        }

        if (jTableVariables.getSelectedRowCount() > 0)
        {
            jMenuItemCut1.setEnabled(true);
            jMenuItemCopy1.setEnabled(true);
            jMenuItemDelete1.setEnabled(true);
            jMenuItemDuplicate1.setEnabled(true);
        }
        else
        {
            jMenuItemCut1.setEnabled(false);
            jMenuItemCopy1.setEnabled(false);
            jMenuItemDelete1.setEnabled(false);
            jMenuItemDuplicate1.setEnabled(false);
        }
    }//GEN-LAST:event_jPopupMenuVariablesPopupMenuWillBecomeVisible

    private void jScrollPane2MouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jScrollPane2MouseClicked
    {

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jPopupMenuVariables.show(jScrollPane2, evt.getPoint().x, 
                                     evt.getPoint().y);
        }
    }//GEN-LAST:event_jScrollPane2MouseClicked

    private void jMenuItemDuplicate1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDuplicate1ActionPerformed
    {

        Vector selectedVariables = new Vector();
        jTableVariables.getSelectedRows();

        int[] rows = jTableVariables.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            selectedVariables.add(((JRVariable) jTableVariables.getValueAt(
                                           rows[ i ], 0)).cloneMe());
        }

        duplicateVariables(selectedVariables);
    }//GEN-LAST:event_jMenuItemDuplicate1ActionPerformed

    private void jMenuItemDelete1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDelete1ActionPerformed
    {
        jButtonDeleteVariableActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemDelete1ActionPerformed

    private void jMenuItemPaste1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemPaste1ActionPerformed
    {
        duplicateVariables(getClipboardVariables());
    }//GEN-LAST:event_jMenuItemPaste1ActionPerformed

    private void jMenuItemCopy1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCopy1ActionPerformed
    {
        jTableVariables.getSelectedRows();

        int[] rows = jTableVariables.getSelectedRows();
        getClipboardVariables().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            JRVariable variable = ((JRVariable) jTableVariables.getValueAt(
                                           rows[ i ], 0)).cloneMe();

            if (!variable.isBuiltin())
            {
                getClipboardVariables().add(variable);
            }
        }
    }//GEN-LAST:event_jMenuItemCopy1ActionPerformed

    private void jPopupMenuVariablesPopupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt)//GEN-FIRST:event_jPopupMenuVariablesPopupMenuWillBecomeInvisible
    {
    }//GEN-LAST:event_jPopupMenuVariablesPopupMenuWillBecomeInvisible

    private void jMenuItemCut1ActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCut1ActionPerformed
    {

        // Put selected elements in clipboard and call delete...
        jTableVariables.getSelectedRows();

        int[] rows = jTableVariables.getSelectedRows();
        getClipboardVariables().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            JRVariable variable = ((JRVariable) jTableVariables.getValueAt(
                                           rows[ i ], 0)).cloneMe();

            if (!variable.isBuiltin())
            {
                getClipboardVariables().add(variable);
            }
        }

        jButtonDeleteVariableActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemCut1ActionPerformed

    private void jMenuItemDuplicateActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDuplicateActionPerformed
    {

        Vector selectedFields = new Vector();
        jTableFields.getSelectedRows();

        int[] rows = jTableFields.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            selectedFields.add(((JRField) jTableFields.getValueAt(rows[ i ], 0)).cloneMe());
        }

        duplicateFields(selectedFields);
    }//GEN-LAST:event_jMenuItemDuplicateActionPerformed

    private void jMenuItemDeleteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemDeleteActionPerformed
    {
        jButtonDeleteFieldActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemDeleteActionPerformed

    private void jMenuItemPasteActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemPasteActionPerformed
    {
        duplicateFields(getClipboardFields());
    }//GEN-LAST:event_jMenuItemPasteActionPerformed

    private void jMenuItemCopyActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCopyActionPerformed
    {
        jTableFields.getSelectedRows();

        int[] rows = jTableFields.getSelectedRows();
        getClipboardFields().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            getClipboardFields().add(((JRField) jTableFields.getValueAt(
                                              rows[ i ], 0)).cloneMe());
        }
    }//GEN-LAST:event_jMenuItemCopyActionPerformed

    private void jScrollPane3MouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jScrollPane3MouseClicked
    {

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jPopupMenuFields.show(jScrollPane3, evt.getPoint().x, 
                                  evt.getPoint().y);
        }
    }//GEN-LAST:event_jScrollPane3MouseClicked

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt)//GEN-FIRST:event_jPopupMenuFieldsPopupMenuWillBecomeVisible
    {

        if (getClipboardFields().size() > 0)
        {
            jMenuItemPaste.setEnabled(true);
        }
        else
        {
            jMenuItemPaste.setEnabled(false);
        }

        if (jTableFields.getSelectedRowCount() > 0)
        {
            jMenuItemCut.setEnabled(true);
            jMenuItemCopy.setEnabled(true);
            jMenuItemDelete.setEnabled(true);
            jMenuItemDuplicate.setEnabled(true);
        }
        else
        {
            jMenuItemCut.setEnabled(false);
            jMenuItemCopy.setEnabled(false);
            jMenuItemDelete.setEnabled(false);
            jMenuItemDuplicate.setEnabled(false);
        }
    }//GEN-LAST:event_jPopupMenuFieldsPopupMenuWillBecomeVisible

    private void jMenuItemCutActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jMenuItemCutActionPerformed
    {

        // Put selected elements in clipboard and call delete...
        jTableFields.getSelectedRows();

        int[] rows = jTableFields.getSelectedRows();
        getClipboardFields().removeAllElements();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            getClipboardFields().add(((JRField) jTableFields.getValueAt(
                                              rows[ i ], 0)).cloneMe());
        }

        jButtonDeleteFieldActionPerformed(evt);
    }//GEN-LAST:event_jMenuItemCutActionPerformed

    private void jTableParametersMouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jTableParametersMouseClicked
    {

        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 && 
            jTableParameters.getSelectedRow() >= 0)
        {
            jButtonModifyParameterActionPerformed(new java.awt.event.ActionEvent(
                                                          jButtonModifyParameter, 
                                                          0, ""));
        }

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jScrollPane1MouseClicked(evt);
        }
    }//GEN-LAST:event_jTableParametersMouseClicked

    private void jTableVariablesMouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jTableVariablesMouseClicked
    {

        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 && 
            jTableVariables.getSelectedRow() >= 0)
        {
            jButtonModifyVariableActionPerformed(new java.awt.event.ActionEvent(
                                                         jButtonModifyVariable, 
                                                         0, ""));
        }

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jScrollPane2MouseClicked(evt);
        }
    }//GEN-LAST:event_jTableVariablesMouseClicked

    private void jTableFieldsMouseClicked(java.awt.event.MouseEvent evt)//GEN-FIRST:event_jTableFieldsMouseClicked
    {

        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1 && 
            jTableFields.getSelectedRow() >= 0)
        {
            jButtonModifyFieldActionPerformed(new java.awt.event.ActionEvent(
                                                      jButtonModifyField, 0, 
                                                      ""));
        }

        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jScrollPane3MouseClicked(evt);
        }
    }//GEN-LAST:event_jTableFieldsMouseClicked

    private void jButtonDeleteFieldActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonDeleteFieldActionPerformed
    {
        jTableFields.getSelectedRows();

        int[] rows = jTableFields.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {
            this.getJReportFrame().getReport().removeField(
                    (JRField) jTableFields.getValueAt(rows[ i ], 0));
        }

    }//GEN-LAST:event_jButtonDeleteFieldActionPerformed

    private void jButtonModifyFieldActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonModifyFieldActionPerformed
    {

        JRField field = (JRField) jTableFields.getValueAt(jTableFields.getSelectedRow(), 
                                                          0);
        modifyField(field);
    }//GEN-LAST:event_jButtonModifyFieldActionPerformed

    /**
     * DOCUMENT ME!
     * 
     * @param field DOCUMENT ME!
     */
    public void modifyField(JRField field)
    {

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.setField(field);
        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            field.setName(jrpd.getField().getName());
            field.setClassType(jrpd.getField().getClassType());

            field.setDescription(jrpd.getField().getDescription());

            this.getJReportFrame().getReport().fireReportObjectChangedListenerValueChanged(new it.businesslogic.ireport.gui.event.ReportObjectChangedEvent(this.getJReportFrame().getReport(), 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.FIELD, 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.MODIFIED, 
                                                                                                                                                           field, 
                                                                                                                                                           field));
        }
    }

    private void jButtonNewFieldActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonNewFieldActionPerformed
    {
        newField();
    }//GEN-LAST:event_jButtonNewFieldActionPerformed

    /**
     * DOCUMENT ME!
     */
    public void newField()
    {

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRFieldDialog jrpd = new JRFieldDialog(parent, true);
        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {

            JRField field = jrpd.getField();
            this.getJReportFrame().getReport().addField(field);
        }
    }

    private void jButtonDeleteVariableActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonDeleteVariableActionPerformed
    {
        jTableVariables.getSelectedRows();

        int[] rows = jTableVariables.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            if (!((JRVariable) jTableVariables.getValueAt(rows[ i ], 0)).isBuiltin())
            {
                this.getJReportFrame().getReport().removeVariable(
                        (JRVariable) jTableVariables.getValueAt(rows[ i ], 0));
            }

            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
    }//GEN-LAST:event_jButtonDeleteVariableActionPerformed

    private void jButtonModifyVariableActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonModifyVariableActionPerformed
    {

        JRVariable variable = (JRVariable) jTableVariables.getValueAt(jTableVariables.getSelectedRow(), 
                                                                      0);

        modifyVariable(variable);
    }//GEN-LAST:event_jButtonModifyVariableActionPerformed

    /**
     * DOCUMENT ME!
     * 
     * @param variable DOCUMENT ME!
     */
    public void modifyVariable(JRVariable variable)
    {

        if (variable.isBuiltin())
        {
            javax.swing.JOptionPane.showMessageDialog(this, 
                                                      "You can't modify or delete builtin variables!", 
                                                      "Invalid operation!", 
                                                      javax.swing.JOptionPane.WARNING_MESSAGE);

            return;
        }

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(getJReportFrame().getReport(), 
                                                     parent, true);
        jrpd.setVariable(variable);
        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            this.getJReportFrame().getReport().getKeywordLookup().removeKeyword(
                    "$V{" + variable.getName() + "}");
            variable.setName(jrpd.getVariable().getName());
            this.getJReportFrame().getReport().getKeywordLookup().addKeyword(
                    "$V{" + variable.getName() + "}");
            variable.setClassType(jrpd.getVariable().getClassType());
            variable.setCalculation(jrpd.getVariable().getCalculation());
            variable.setResetType(jrpd.getVariable().getResetType());
            variable.setResetGroup(jrpd.getVariable().getResetGroup());
            variable.setExpression(jrpd.getVariable().getExpression());
            variable.setInitialValueExpression(jrpd.getVariable().getInitialValueExpression());
            variable.setIncrementerFactoryClass(jrpd.getVariable().getIncrementerFactoryClass());
            variable.setIncrementType(jrpd.getVariable().getIncrementType());
            variable.setIncrementGroup(jrpd.getVariable().getIncrementGroup());

            this.getJReportFrame().getReport().fireReportObjectChangedListenerValueChanged(new it.businesslogic.ireport.gui.event.ReportObjectChangedEvent(this.getJReportFrame().getReport(), 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.VARIABLE, 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.MODIFIED, 
                                                                                                                                                           variable, 
                                                                                                                                                           variable));
        }
    }

    private void jButtonNewVariableActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonNewVariableActionPerformed
    {
        newVariable();
    }//GEN-LAST:event_jButtonNewVariableActionPerformed

    /**
     * DOCUMENT ME!
     */
    public void newVariable()
    {

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRVariableDialog jrpd = new JRVariableDialog(this.getJReportFrame().getReport(), 
                                                     parent, true);
        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {

            JRVariable variable = jrpd.getVariable();
            this.getJReportFrame().getReport().addVariable(variable);
        }
    }

    private void jButtonDeleteParameterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonDeleteParameterActionPerformed
    {
        jTableParameters.getSelectedRows();

        int[] rows = jTableParameters.getSelectedRows();

        for (int i = rows.length - 1; i >= 0; --i)
        {

            JRParameter parameter = (JRParameter) jTableParameters.getValueAt(
                                            rows[ i ], 0);

            if (!parameter.isBuiltin())
            {
                this.getJReportFrame().getReport().removeParameter(parameter);
            }
            else
            {
                javax.swing.JOptionPane.showMessageDialog(this, 
                                                          "You can't modify or delete builtin parameters!", 
                                                          "Invalid operation!", 
                                                          javax.swing.JOptionPane.WARNING_MESSAGE);

                return;
            }

            //this.jTableParameters.removeRowSelectionInterval( rows[i],rows[i]);
        }
    }//GEN-LAST:event_jButtonDeleteParameterActionPerformed

    private void jButtonModifyParameterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonModifyParameterActionPerformed
    {

        JRParameter parameter = (JRParameter) jTableParameters.getValueAt(jTableParameters.getSelectedRow(), 
                                                                          0);

        modifyParameter(parameter);
    }//GEN-LAST:event_jButtonModifyParameterActionPerformed

    /**
     * DOCUMENT ME!
     * 
     * @param parameter DOCUMENT ME!
     */
    public void modifyParameter(JRParameter parameter)
    {

        if (parameter.isBuiltin())
        {
            javax.swing.JOptionPane.showMessageDialog(this, 
                                                      "You can't modify or delete builtin parameters!", 
                                                      "Invalid operation!", 
                                                      javax.swing.JOptionPane.WARNING_MESSAGE);

            return;
        }

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.setParameter(parameter);

        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {
            this.getJReportFrame().getReport().getKeywordLookup().removeKeyword(
                    "$P{" + parameter.getName() + "}");
            parameter.setName(jrpd.getParameter().getName());
            this.getJReportFrame().getReport().getKeywordLookup().addKeyword(
                    "$P{" + parameter.getName() + "}");
            parameter.setClassType(jrpd.getParameter().getClassType());
            parameter.setDescription(jrpd.getParameter().getDescription());
            parameter.setDefaultValueExpression(jrpd.getParameter().getDefaultValueExpression());
            parameter.setIsForPrompting(jrpd.getParameter().isIsForPrompting());

            this.getJReportFrame().getReport().fireReportObjectChangedListenerValueChanged(new it.businesslogic.ireport.gui.event.ReportObjectChangedEvent(this.getJReportFrame().getReport(), 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.PARAMETER, 
                                                                                                                                                           it.businesslogic.ireport.gui.event.ReportObjectChangedEvent.PARAMETER, 
                                                                                                                                                           parameter, 
                                                                                                                                                           parameter));
        }
    }

    private void jButtonNewParameterActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_jButtonNewParameterActionPerformed
    {

        // create a new parameter....
        newParameter();
    }//GEN-LAST:event_jButtonNewParameterActionPerformed

    /**
     * DOCUMENT ME!
     */
    public void newParameter()
    {

        java.awt.Frame parent = Misc.frameFromComponent(this);
        JRParameterDialog jrpd = new JRParameterDialog(parent, true);
        jrpd.show();

        if (jrpd.getDialogResult() == javax.swing.JOptionPane.OK_OPTION)
        {

            JRParameter parameter = jrpd.getParameter();
            this.getJReportFrame().getReport().addParameter(parameter);
        }
    }

    /**
     * Closes the dialog
     * @param evt DOCUMENT ME!
     */
    private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
    {
        setVisible(false);
    }//GEN-LAST:event_closeDialog

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args)
    {
        new ValuesDialog(new javax.swing.JFrame(), true).show();
    }

    /**
     * Getter for property jReportFrame.
     * 
     * @return Value of property jReportFrame.
     */
    public it.businesslogic.ireport.gui.JReportFrame getJReportFrame()
    {

        return jReportFrame;
    }

    /**
     * Setter for property jReportFrame.
     * 
     * @param jReportFrame New value of property jReportFrame.
     */
    public void setJReportFrame(it.businesslogic.ireport.gui.JReportFrame jReportFrame)
    {
        this.jReportFrame = jReportFrame;

        // Update all...
        if (jReportFrame == null)
        {
            setVisible(false);
        }
        else if (isVisible())
        {
            this.setTitle(jReportFrame.getReport().getName() + " values...");
            updateParameters();
            updateFields();
            updateVariables();
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateFields()
    {

        DefaultTableModel dtm = (DefaultTableModel) jTableFields.getModel();
        dtm.setRowCount(0);

        Enumeration e = sortFieldsByName(jReportFrame.getReport().getFields()).elements();

        while (e.hasMoreElements())
        {

            it.businesslogic.ireport.JRField field = (it.businesslogic.ireport.JRField) e.nextElement();
            Vector row = new Vector();
            row.addElement(field);
            row.addElement(field.getClassType());

            dtm.addRow(row);
        }

    }

    /**
     * DOCUMENT ME!
     */
    public void updateVariables()
    {

        DefaultTableModel dtm = (DefaultTableModel) jTableVariables.getModel();
        dtm.setRowCount(0);

        Enumeration e = sortVariablesByName(jReportFrame.getReport().getVariables())
            .elements();

        while (e.hasMoreElements())
        {

            it.businesslogic.ireport.JRVariable variable = (it.businesslogic.ireport.JRVariable) e.nextElement();
            Vector row = new Vector();
            row.addElement(variable);
            row.addElement((variable.isBuiltin()
                                ? "yes"
                                : "no"));

            dtm.addRow(row);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void updateParameters()
    {

        DefaultTableModel dtm = (DefaultTableModel) jTableParameters.getModel();
        dtm.setRowCount(0);

        //Enumeration e = sortParametersByName( jReportFrame.getReport().getParameters().elements() );
        Enumeration e = sortParametersByName(jReportFrame.getReport().getParameters())
            .elements();

        while (e.hasMoreElements())
        {

            it.businesslogic.ireport.JRParameter parameter = 
                    (it.businesslogic.ireport.JRParameter) e.nextElement();
            Vector row = new Vector();
            row.addElement(parameter);
            row.addElement(parameter.getClassType());
            row.addElement(
                    (parameter.isIsForPrompting()
                         ? "yes"
                         : "no"));
            row.addElement((parameter.isBuiltin()
                                ? "yes"
                                : "no"));

            dtm.addRow(row);
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void applyI18n()
    {
        jButtonNewField.setText(it.businesslogic.ireport.util.I18n.getString(
                                        "new", "New"));
        jButtonModifyField.setText(it.businesslogic.ireport.util.I18n.getString(
                                           "modify", "Modify"));
        jButtonDeleteField.setText(it.businesslogic.ireport.util.I18n.getString(
                                           "delete", "Delete"));
        jButtonNewVariable.setText(it.businesslogic.ireport.util.I18n.getString(
                                           "new", "New"));
        jButtonModifyVariable.setText(it.businesslogic.ireport.util.I18n.getString(
                                              "modify", "Modify"));
        jButtonDeleteVariable.setText(it.businesslogic.ireport.util.I18n.getString(
                                              "delete", "Delete"));
        jButtonNewParameter.setText(it.businesslogic.ireport.util.I18n.getString(
                                            "new", "New"));
        jButtonModifyParameter.setText(it.businesslogic.ireport.util.I18n.getString(
                                               "modify", "Modify"));
        jButtonDeleteParameter.setText(it.businesslogic.ireport.util.I18n.getString(
                                               "delete", "Delete"));

        jMenuItemCut.setText(it.businesslogic.ireport.util.I18n.getString(
                                     "cut", "Cut"));
        jMenuItemCopy.setText(it.businesslogic.ireport.util.I18n.getString(
                                      "copy", "Copy"));
        jMenuItemPaste.setText(it.businesslogic.ireport.util.I18n.getString(
                                       "paste", "Paste"));
        jMenuItemDelete.setText(it.businesslogic.ireport.util.I18n.getString(
                                        "delete", "Delete"));
        jMenuItemDuplicate.setText(it.businesslogic.ireport.util.I18n.getString(
                                           "duplicate", "Duplicate"));

        jMenuItemCut1.setText(it.businesslogic.ireport.util.I18n.getString(
                                      "cut", "Cut"));
        jMenuItemCopy1.setText(it.businesslogic.ireport.util.I18n.getString(
                                       "copy", "Copy"));
        jMenuItemPaste1.setText(it.businesslogic.ireport.util.I18n.getString(
                                        "paste", "Paste"));
        jMenuItemDelete1.setText(it.businesslogic.ireport.util.I18n.getString(
                                         "delete", "Delete"));
        jMenuItemDuplicate1.setText(it.businesslogic.ireport.util.I18n.getString(
                                            "duplicate", "Duplicate"));

        jMenuItemCut2.setText(it.businesslogic.ireport.util.I18n.getString(
                                      "cut", "Cut"));
        jMenuItemCopy2.setText(it.businesslogic.ireport.util.I18n.getString(
                                       "copy", "Copy"));
        jMenuItemPaste2.setText(it.businesslogic.ireport.util.I18n.getString(
                                        "paste", "Paste"));
        jMenuItemDelete2.setText(it.businesslogic.ireport.util.I18n.getString(
                                         "delete", "Delete"));
        jMenuItemDuplicate2.setText(it.businesslogic.ireport.util.I18n.getString(
                                            "duplicate", "Duplicate"));
    }

    /**
     * DOCUMENT ME!
     * 
     * @param evt DOCUMENT ME!
     */
    public void languageChanged(LanguageChangedEvent evt)
    {
        this.applyI18n();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonDeleteField;
    private javax.swing.JButton jButtonDeleteParameter;
    private javax.swing.JButton jButtonDeleteVariable;
    private javax.swing.JButton jButtonModifyField;
    private javax.swing.JButton jButtonModifyParameter;
    private javax.swing.JButton jButtonModifyVariable;
    private javax.swing.JButton jButtonNewField;
    private javax.swing.JButton jButtonNewParameter;
    private javax.swing.JButton jButtonNewVariable;
    private javax.swing.JMenuItem jMenuItemCopy;
    private javax.swing.JMenuItem jMenuItemCopy1;
    private javax.swing.JMenuItem jMenuItemCopy2;
    private javax.swing.JMenuItem jMenuItemCut;
    private javax.swing.JMenuItem jMenuItemCut1;
    private javax.swing.JMenuItem jMenuItemCut2;
    private javax.swing.JMenuItem jMenuItemDelete;
    private javax.swing.JMenuItem jMenuItemDelete1;
    private javax.swing.JMenuItem jMenuItemDelete2;
    private javax.swing.JMenuItem jMenuItemDuplicate;
    private javax.swing.JMenuItem jMenuItemDuplicate1;
    private javax.swing.JMenuItem jMenuItemDuplicate2;
    private javax.swing.JMenuItem jMenuItemPaste;
    private javax.swing.JMenuItem jMenuItemPaste1;
    private javax.swing.JMenuItem jMenuItemPaste2;
    private javax.swing.JPanel jPanelButtons;
    private javax.swing.JPanel jPanelButtons1;
    private javax.swing.JPanel jPanelButtons2;
    private javax.swing.JPanel jPanelFields;
    private javax.swing.JPanel jPanelParameters;
    private javax.swing.JPanel jPanelVariables;
    private javax.swing.JPopupMenu jPopupMenuFields;
    private javax.swing.JPopupMenu jPopupMenuParameters;
    private javax.swing.JPopupMenu jPopupMenuVariables;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane3;
    private javax.swing.JTabbedPane jTabbedPane;
    private it.businesslogic.ireport.gui.JDragTable jTableFields;
    private it.businesslogic.ireport.gui.JDragTable jTableParameters;
    private it.businesslogic.ireport.gui.JDragTable jTableVariables;
    // End of variables declaration//GEN-END:variables
    private JReportFrame jReportFrame;

    /**
     * DOCUMENT ME!
     * 
     * @param visible DOCUMENT ME!
     */
    public void setVisible(boolean visible)
    {

        if (visible == isVisible())
        {

            return;
        }

        super.setVisible(visible);

        if (visible == true)
        {
            this.setJReportFrame(jReportFrame);
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param p DOCUMENT ME!
     */
    public void modifyErrorParameter(it.businesslogic.ireport.JRParameter p)
    {

        // 1. Switch to parameters panel.
        this.jTabbedPane.setSelectedComponent(jPanelParameters);

        // 2. Fine the parameter and select it
        DefaultTableModel dtm = (DefaultTableModel) jTableParameters.getModel();

        for (int i = 0; i < dtm.getRowCount(); ++i)
        {

            if (dtm.getValueAt(i, 0) == p)
            {
                jTableParameters.setRowSelectionInterval(i, i);
                this.jButtonModifyParameterActionPerformed(new java.awt.event.ActionEvent(
                                                                   jButtonModifyParameter, 
                                                                   0, 
                                                                   jButtonModifyParameter.getName()));

                return;
            }
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param tab DOCUMENT ME!
     */
    public void gotoTab(String tab)
    {

        if (tab.equals("Parameters"))
        {
            this.jTabbedPane.setSelectedIndex(2);
        }
        else if (tab.equals("Fields"))
        {
            this.jTabbedPane.setSelectedIndex(0);
        }
        else if (tab.equals("Variables"))
        {
            this.jTabbedPane.setSelectedIndex(1);
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @return DOCUMENT ME! 
     */
    public Vector getClipboardFields()
    {

        return clipboardFields;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param clipboardFields DOCUMENT ME!
     */
    public void setClipboardFields(Vector clipboardFields)
    {
        this.clipboardFields = clipboardFields;
    }

    /**
     * DOCUMENT ME!
     * 
     * @return DOCUMENT ME! 
     */
    public Vector getClipboardVariables()
    {

        return clipboardVariables;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param clipboardVariables DOCUMENT ME!
     */
    public void setClipboardVariables(Vector clipboardVariables)
    {
        this.clipboardVariables = clipboardVariables;
    }

    /**
     * DOCUMENT ME!
     * 
     * @return DOCUMENT ME! 
     */
    public Vector getClipboardParameters()
    {

        return clipboardParameters;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param clipboardParameters DOCUMENT ME!
     */
    public void setClipboardParameters(Vector clipboardParameters)
    {
        this.clipboardParameters = clipboardParameters;
    }

    /**
     * DOCUMENT ME!
     * 
     * @param fieldsToDuplicate DOCUMENT ME!
     */
    public void duplicateFields(Vector fieldsToDuplicate)
    {

        for (int i = 0; i < fieldsToDuplicate.size(); ++i)
        {

            JRField field = ((JRField) fieldsToDuplicate.elementAt(i)).cloneMe();
            String base_name = field.getName();
            Vector fields = this.getJReportFrame().getReport().getFields();

            for (int j = 0;; ++j)
            {

                boolean found = false;

                for (int k = 0; k < fields.size(); ++k)
                {

                    JRField field1 = (JRField) fields.elementAt(k);

                    if (j == 0)
                    {

                        if (field1.getName().equals(base_name))
                        {
                            found = true;

                            break;
                        }
                    }
                    else
                    {

                        if (field1.getName().equals(base_name + "_" + j))
                        {
                            found = true;

                            break;
                        }
                    }
                }

                if (!found)
                {
                    field.setName(base_name + 
                                  ((j == 0)
                                       ? ""
                                       : "_" + j));

                    break;
                }
            }

            this.getJReportFrame().getReport().addField(field);
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param variablesToDuplicate DOCUMENT ME!
     */
    public void duplicateVariables(Vector variablesToDuplicate)
    {

        for (int i = 0; i < variablesToDuplicate.size(); ++i)
        {

            JRVariable variable = ((JRVariable) variablesToDuplicate.elementAt(
                                           i)).cloneMe();
            String base_name = variable.getName();
            Vector variables = this.getJReportFrame().getReport().getVariables();

            for (int j = 0;; ++j)
            {

                boolean found = false;

                for (int k = 0; k < variables.size(); ++k)
                {

                    JRVariable variable1 = (JRVariable) variables.elementAt(k);

                    if (j == 0)
                    {

                        if (variable1.getName().equals(base_name))
                        {
                            found = true;

                            break;
                        }
                    }
                    else
                    {

                        if (variable1.getName().equals(base_name + "_" + j))
                        {
                            found = true;

                            break;
                        }
                    }
                }

                if (!found)
                {
                    variable.setName(base_name + 
                                     ((j == 0)
                                          ? ""
                                          : "_" + j));

                    break;
                }
            }

            if (variable.isBuiltin())
            {
                JOptionPane.showMessageDialog(this, 
                                              "It's not possible duplicate built-in variables!");
            }
            else
            {
                this.getJReportFrame().getReport().addVariable(variable);
            }
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param parametersToDuplicate DOCUMENT ME!
     */
    public void duplicateParameters(Vector parametersToDuplicate)
    {

        boolean msg_disp = false;

        for (int i = 0; i < parametersToDuplicate.size(); ++i)
        {

            JRParameter parameter = ((JRParameter) parametersToDuplicate.elementAt(
                                             i)).cloneMe();
            String base_name = parameter.getName();
            Vector parameters = this.getJReportFrame().getReport().getParameters();

            for (int j = 0;; ++j)
            {

                boolean found = false;

                for (int k = 0; k < parameters.size(); ++k)
                {

                    JRParameter parameter1 = (JRParameter) parameters.elementAt(
                                                     k);

                    if (j == 0)
                    {

                        if (parameter1.getName().equals(base_name))
                        {
                            found = true;

                            break;
                        }
                    }
                    else
                    {

                        if (parameter1.getName().equals(base_name + "_" + j))
                        {
                            found = true;

                            break;
                        }
                    }
                }

                if (!found)
                {
                    parameter.setName(base_name + 
                                      ((j == 0)
                                           ? ""
                                           : "_" + j));

                    break;
                }
            }

            if (parameter.isBuiltin())
            {

                if (!msg_disp)
                {
                    JOptionPane.showMessageDialog(this, 
                                                  "It's not possible duplicate built-in parameters!");
                    msg_disp = true;
                }
            }
            else
            {
                this.getJReportFrame().getReport().addParameter(parameter);
            }
        }
    }

    /**
     * DOCUMENT ME!
     * 
     * @param evt DOCUMENT ME!
     */
    public void reportObjectChanged(ReportObjectChangedEvent evt)
    {

        if (evt.getType() == evt.PARAMETER)
        {
            updateParameters();
        }
        else if (evt.getType() == evt.VARIABLE)
        {
            updateVariables();
        }
        else if (evt.getType() == evt.FIELD)
        {
            updateFields();
        }
    }

    private Vector sortFieldsByName(Vector vector)
    {

        Vector myElements = new Vector();
        boolean inserted;

        Enumeration enum2 = vector.elements();

        while (enum2.hasMoreElements())
        {

            JRField elem = (JRField) enum2.nextElement();

            // insert this element in the right position...
            if (myElements.size() == 0)
            {
                myElements.add(elem);
            }
            else
            {
                inserted = false;

                for (int i = 0; i < myElements.size(); ++i)
                {

                    JRField elem2 = (JRField) myElements.elementAt(i);

                    if (elem.getName().compareTo(elem2.getName()) < 0)
                    {
                        myElements.insertElementAt(elem, i);
                        inserted = true;

                        break;
                    }

                }

                if (!inserted)
                {
                    myElements.addElement(elem);
                }
            }
        }

        return myElements;
    }

    private Vector sortVariablesByName(Vector vector)
    {

        Vector myElements = new Vector();
        boolean inserted;
        JRVariable elem2;

        Enumeration enum2 = vector.elements();

        while (enum2.hasMoreElements())
        {

            JRVariable elem = (JRVariable) enum2.nextElement();

            // insert this element in the right position...
            if (myElements.size() == 0)
            {
                myElements.add(elem);
            }
            else
            {
                inserted = false;

                for (int i = 0; i < myElements.size(); ++i)
                {
                    elem2 = (JRVariable) myElements.elementAt(i);

                    // list builtin parameters first and then the others
                    if (elem.isBuiltin())
                    {

                        if (elem.isBuiltin() == elem2.isBuiltin())
                        {

                            if (elem.getName().compareTo(elem2.getName()) < 0)
                            {
                                myElements.insertElementAt(elem, i);
                                inserted = true;

                                break;
                            }

                        }

                    }
                    else
                    {

                        if (elem.isBuiltin() == elem2.isBuiltin())
                        {

                            if (elem.getName().compareTo(elem2.getName()) < 0)
                            {
                                myElements.insertElementAt(elem, i);
                                inserted = true;

                                break;
                            }

                        }

                    }
                }

                if (!inserted)
                {
                    myElements.addElement(elem);
                }

            }
        }

        return myElements;
    }

    private Vector sortParametersByName(Vector vector)
    {

        Vector myElements = new Vector();
        boolean inserted;
        JRParameter elem2;
        Enumeration enum2 = vector.elements();

        while (enum2.hasMoreElements())
        {

            JRParameter elem = (JRParameter) enum2.nextElement();

            // insert this element in the right position...
            if (myElements.size() == 0)
            {
                myElements.add(elem);
            }
            else
            {
                inserted = false;

                for (int i = 0; i < myElements.size(); ++i)
                {
                    elem2 = (JRParameter) myElements.elementAt(i);

                    // list builtin parameters first and then the others
                    if (elem.isBuiltin())
                    {

                        if (elem.isBuiltin() == elem2.isBuiltin())
                        {

                            if (elem.getName().compareTo(elem2.getName()) < 0)
                            {
                                myElements.insertElementAt(elem, i);
                                inserted = true;

                                break;
                            }

                        }

                    }
                    else
                    {

                        if (elem.isBuiltin() == elem2.isBuiltin())
                        {

                            if (elem.getName().compareTo(elem2.getName()) < 0)
                            {
                                myElements.insertElementAt(elem, i);
                                inserted = true;

                                break;
                            }

                        }

                    }
                }

                if (!inserted)
                {
                    myElements.addElement(elem);
                }
            }
        }

        return myElements;
    }
}
