/*
 * LibraryPanel.java
 *
 * Created on 14 settembre 2004, 23.49
 */

package it.businesslogic.ireport.gui.library;
import it.businesslogic.ireport.gui.library.objects.*;
import it.businesslogic.ireport.gui.*;
import it.businesslogic.ireport.*;
import javax.swing.*;
import javax.swing.tree.*;
import java.util.*;
import java.awt.event.ActionEvent;

/**
 *
 * @author  Administrator
 */
public class LibraryPanel extends javax.swing.JPanel implements it.businesslogic.ireport.util.LanguageChangedListener, it.businesslogic.ireport.gui.event.ReportObjectChangedListener {
    
    DefaultMutableTreeNode fieldsNode = null;
    DefaultMutableTreeNode variablesNode = null;
    DefaultMutableTreeNode parametersNode = null; 
    DefaultMutableTreeNode systemObjectsNode = null; 
    
    JReportFrame jrf;

    
    /** Creates new form LibraryPanel */
    public LibraryPanel() {
        
        initComponents();
        
        jLibraryTree.setCellRenderer( new LibraryTreeCellRenderer());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Libs");
        
        DefaultTreeModel dtm = new DefaultTreeModel(root);
        
        jLibraryTree.setModel( dtm );
        jLibraryTree.setDragEnabled(true);
        jLibraryTree.setRootVisible( false );
        jLibraryTree.setTransferHandler(new TreeTransfertHandler());
        
        jLibraryTree.expandPath( new TreePath(root));

        fieldsNode = new DefaultMutableTreeNode("Fields",true);
        root.add( fieldsNode );
        
        variablesNode = new DefaultMutableTreeNode("Variables",true);
        root.add( variablesNode );
        
        parametersNode = new DefaultMutableTreeNode("Parameters",true);
        root.add( parametersNode );
        
        this.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(
       	 KeyStroke.getKeyStroke("F5"), "refresh");
         this.getActionMap().put("refresh",
            new AbstractAction("refresh") {
              public void actionPerformed(ActionEvent evt) {
                setJReportFrame(jrf);
              }
        });
/*        
        systemObjectsNode = new DefaultMutableTreeNode("Custom",true);
        root.add( systemObjectsNode );
*/      
        it.businesslogic.ireport.util.I18n.addOnLanguageChangedListener( this );
        
        loadSystemObjects();
        loadCustomObjects();
        
        updateReportObjects();
        this.languageChanged(null);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jPopupMenuFields = new javax.swing.JPopupMenu();
        jMenuItemEdit = new javax.swing.JMenuItem();
        jMenuAdd = new javax.swing.JMenu();
        jMenuItemNewField = new javax.swing.JMenuItem();
        jMenuItemNewVariable = new javax.swing.JMenuItem();
        jMenuItemParameter = new javax.swing.JMenuItem();
        jSeparator1 = new javax.swing.JSeparator();
        jMenuItemCut = new javax.swing.JMenuItem();
        jMenuItemCopy = new javax.swing.JMenuItem();
        jMenuItemPaste = new javax.swing.JMenuItem();
        jMenuItemDelete = new javax.swing.JMenuItem();
        jSeparator2 = new javax.swing.JSeparator();
        jMenuItemRefresh = new javax.swing.JMenuItem();
        jScrollPane1 = new javax.swing.JScrollPane();
        jLibraryTree = new javax.swing.JTree();

        jPopupMenuFields.addPopupMenuListener(new javax.swing.event.PopupMenuListener() {
            public void popupMenuCanceled(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeInvisible(javax.swing.event.PopupMenuEvent evt) {
            }
            public void popupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {
                jPopupMenuFieldsPopupMenuWillBecomeVisible(evt);
            }
        });

        jMenuItemEdit.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemEdit.setIcon(new javax.swing.ImageIcon(""));
        jMenuItemEdit.setText("Edit");
        jMenuItemEdit.setEnabled(false);
        jMenuItemEdit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemEditActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemEdit);

        jMenuAdd.setText("Add...");
        jMenuAdd.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewField.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewField.setIcon(new javax.swing.ImageIcon(""));
        jMenuItemNewField.setText("Field");
        jMenuItemNewField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNewFieldActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemNewField);

        jMenuItemNewVariable.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemNewVariable.setIcon(new javax.swing.ImageIcon(""));
        jMenuItemNewVariable.setText("Variable");
        jMenuItemNewVariable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemNewVariableActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemNewVariable);

        jMenuItemParameter.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemParameter.setIcon(new javax.swing.ImageIcon(""));
        jMenuItemParameter.setText("Parameter");
        jMenuItemParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemParameterActionPerformed(evt);
            }
        });

        jMenuAdd.add(jMenuItemParameter);

        jPopupMenuFields.add(jMenuAdd);

        jPopupMenuFields.add(jSeparator1);

        jMenuItemCut.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/cut.gif")));
        jMenuItemCut.setText("Cut");
        jMenuItemCut.setEnabled(false);
        jMenuItemCut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCutActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemCut);

        jMenuItemCopy.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemCopy.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/copy.gif")));
        jMenuItemCopy.setText("Copy");
        jMenuItemCopy.setEnabled(false);
        jMenuItemCopy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemCopyActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemCopy);

        jMenuItemPaste.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemPaste.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/paste.gif")));
        jMenuItemPaste.setText("Paste");
        jMenuItemPaste.setEnabled(false);
        jMenuItemPaste.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemPasteActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemPaste);

        jMenuItemDelete.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemDelete.setIcon(new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/menu/delete.gif")));
        jMenuItemDelete.setText("Delete");
        jMenuItemDelete.setEnabled(false);
        jMenuItemDelete.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemDeleteActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemDelete);

        jPopupMenuFields.add(jSeparator2);

        jMenuItemRefresh.setFont(new java.awt.Font("Dialog", 0, 11));
        jMenuItemRefresh.setText("Refresh");
        jMenuItemRefresh.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItemRefreshActionPerformed(evt);
            }
        });

        jPopupMenuFields.add(jMenuItemRefresh);

        setLayout(new java.awt.BorderLayout());

        jScrollPane1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jScrollPane1MouseClicked(evt);
            }
        });

        jLibraryTree.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLibraryTreeMouseClicked(evt);
            }
        });

        jScrollPane1.setViewportView(jLibraryTree);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    private void jMenuItemPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemPasteActionPerformed
        TreePath[] paths = jLibraryTree.getSelectionPaths();
        
        if (paths.length == 1)
        {
           if (paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode)
           {
               ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
               DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.fields","Fields")) || dmn.getUserObject() instanceof JRField) && jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0)
               {
                   vd.duplicateFields( vd.getClipboardFields() );
               }
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.variables","Variables")) || dmn.getUserObject() instanceof JRVariable) && jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0)
               {
                   vd.duplicateVariables( vd.getClipboardVariables() );
               }
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.parameters","Parameters")) || dmn.getUserObject() instanceof JRParameter) && jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0)
               {
                   vd.duplicateParameters( vd.getClipboardParameters() );
               }
           }
        }
        
    }//GEN-LAST:event_jMenuItemPasteActionPerformed

    private void jMenuItemCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCopyActionPerformed
       TreePath[] paths = jLibraryTree.getSelectionPaths();
        
       boolean clearedVariablesClipboard = false;
       boolean clearedParametersClipboard = false;
       boolean clearedFieldsClipboard = false;
       
        for (int i=0; i<paths.length && jrf != null; ++i)
        {
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = jrf.getReport();
            if (paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)
            {
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable )
                { 
                        if (!clearedVariablesClipboard)
                        {
                            clearedVariablesClipboard = true;
                            vd.getClipboardVariables().removeAllElements();
                        }
                        vd.getClipboardVariables().add( ((JRVariable)obj).cloneMe() );
                }
                if (obj instanceof JRField )
                { 
                        if (!clearedFieldsClipboard)
                        {
                            clearedFieldsClipboard = true;
                            vd.getClipboardFields().removeAllElements();
                        }
                        vd.getClipboardFields().add( ((JRField)obj).cloneMe() );
                }
                if (obj instanceof JRParameter )
                { 
                        if (!clearedParametersClipboard)
                        {
                            clearedParametersClipboard = true;
                            vd.getClipboardParameters().removeAllElements();
                        }
                        vd.getClipboardParameters().add( ((JRParameter)obj).cloneMe() );
                }
            }
        }      
    }//GEN-LAST:event_jMenuItemCopyActionPerformed

    private void jMenuItemCutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemCutActionPerformed
        TreePath[] paths = jLibraryTree.getSelectionPaths();
        
       boolean clearedVariablesClipboard = false;
       boolean clearedParametersClipboard = false;
       boolean clearedFieldsClipboard = false;
       
        for (int i=0; i<paths.length && jrf != null; ++i)
        {
            ValuesDialog vd = MainFrame.getMainInstance().getValuesDialog();
            Report report = jrf.getReport();
            if (paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)
            {
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable )
                { 
                        if (!clearedVariablesClipboard)
                        {
                            clearedVariablesClipboard = true;
                            vd.getClipboardVariables().removeAllElements();
                        }
                        vd.getClipboardVariables().add( ((JRVariable)obj).cloneMe() );
                        jrf.getReport().removeVariable((JRVariable)obj);
                }
                if (obj instanceof JRField )
                { 
                        if (!clearedFieldsClipboard)
                        {
                            clearedFieldsClipboard = true;
                            vd.getClipboardFields().removeAllElements();
                        }
                        vd.getClipboardFields().add( ((JRField)obj).cloneMe() );
                        jrf.getReport().removeField((JRField)obj);
                }
                if (obj instanceof JRParameter )
                { 
                        if (!clearedParametersClipboard)
                        {
                            clearedParametersClipboard = true;
                            vd.getClipboardParameters().removeAllElements();
                        }
                        vd.getClipboardParameters().add( ((JRParameter)obj).cloneMe() );
                        jrf.getReport().removeParameter((JRParameter)obj);
                }
            }
        }      
    }//GEN-LAST:event_jMenuItemCutActionPerformed

    private void jMenuItemDeleteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemDeleteActionPerformed
        
        TreePath[] paths = jLibraryTree.getSelectionPaths();
        
        for (int i=0; i<paths.length && jrf != null; ++i)
        {
            Report report = jrf.getReport();
            if (paths[i].getLastPathComponent() instanceof DefaultMutableTreeNode)
            {
                Object obj = ((DefaultMutableTreeNode)paths[i].getLastPathComponent()).getUserObject();
                if (obj instanceof JRVariable ) { report.removeVariable((JRVariable)obj ); }
                if (obj instanceof JRField ) {  report.removeField((JRField)obj ); }
                if (obj instanceof JRParameter ) {  report.removeParameter((JRParameter)obj ); }
            }
        }        
    }//GEN-LAST:event_jMenuItemDeleteActionPerformed

    private void jMenuItemParameterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemParameterActionPerformed
         MainFrame.getMainInstance().getValuesDialog().newParameter();
    }//GEN-LAST:event_jMenuItemParameterActionPerformed

    private void jMenuItemNewFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewFieldActionPerformed
         MainFrame.getMainInstance().getValuesDialog().newField();
    }//GEN-LAST:event_jMenuItemNewFieldActionPerformed

    private void jMenuItemNewVariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemNewVariableActionPerformed
        
        // We have to use the same method used by ValuesDialog...
        MainFrame.getMainInstance().getValuesDialog().newVariable();
    }//GEN-LAST:event_jMenuItemNewVariableActionPerformed

    private void jScrollPane1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jScrollPane1MouseClicked
       jLibraryTreeMouseClicked(evt);
    }//GEN-LAST:event_jScrollPane1MouseClicked

    private void jMenuItemRefreshActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemRefreshActionPerformed
        updateReportObjects();
    }//GEN-LAST:event_jMenuItemRefreshActionPerformed

    private void jMenuItemEditActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItemEditActionPerformed

        // We have to see what type of item we have selected...
        TreePath[] paths = jLibraryTree.getSelectionPaths();
        
        if (paths == null || paths.length == 0)
        {
            return;
        }
        
        if (paths.length == 1 && paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode)
        {
            Object obj = ((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject();
            if (obj instanceof JRVariable ) { MainFrame.getMainInstance().getValuesDialog().modifyVariable((JRVariable)obj ); }
            if (obj instanceof JRField ) { MainFrame.getMainInstance().getValuesDialog().modifyField((JRField)obj ); }
            if (obj instanceof JRParameter ) { MainFrame.getMainInstance().getValuesDialog().modifyParameter((JRParameter)obj ); }
        }      
    }//GEN-LAST:event_jMenuItemEditActionPerformed

    private void jPopupMenuFieldsPopupMenuWillBecomeVisible(javax.swing.event.PopupMenuEvent evt) {//GEN-FIRST:event_jPopupMenuFieldsPopupMenuWillBecomeVisible
        
        if (this.jrf != null)
        {
            jMenuAdd.setEnabled( true ); 
            jMenuItemRefresh.setEnabled( true ); 
        }
        else
        {
            jMenuItemCut.setEnabled(false);
            jMenuItemCopy.setEnabled(false);
            jMenuItemDelete.setEnabled(false);
            jMenuItemPaste.setEnabled(false);
            jMenuItemEdit.setEnabled(false);
            jMenuItemRefresh.setEnabled(false);
            jMenuAdd.setEnabled( false );
            return;
        }
        
        // Edit is able only if a single valid object is selected...
        TreePath[] paths = jLibraryTree.getSelectionPaths();
        
        if (paths == null || paths.length == 0)
        {
            jMenuItemCut.setEnabled(false);
            jMenuItemCopy.setEnabled(false);
            jMenuItemDelete.setEnabled(false);
            jMenuItemPaste.setEnabled(false);
            jMenuItemEdit.setEnabled(false);
            return;
        }
        
        if (paths.length == 1 &&
            paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode &&
            ( (((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRField ) ||
              (((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRVariable ) ||
              (((DefaultMutableTreeNode)paths[0].getLastPathComponent()).getUserObject() instanceof JRParameter ) ) )
        {
                  jMenuItemEdit.setEnabled(true);
        }     
        else
        {
                  jMenuItemEdit.setEnabled( false );
        }
        
         if (paths.length > 0)
         {
             jMenuItemCut.setEnabled(true);
             jMenuItemCopy.setEnabled(true);
             jMenuItemDelete.setEnabled(true);
         }
         else
         {
             jMenuItemCut.setEnabled(false);
             jMenuItemCopy.setEnabled(false);
             jMenuItemDelete.setEnabled(false);
         }
         
        jMenuItemPaste.setEnabled(false);
        
         // If the only selection is the node "parameters"...
        if (paths.length == 1)
        {
           if (paths[0].getLastPathComponent() instanceof DefaultMutableTreeNode)
           {
               DefaultMutableTreeNode dmn = (DefaultMutableTreeNode)paths[0].getLastPathComponent();
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.fields","Fields")) || dmn.getUserObject() instanceof JRField) && jrf.getMainFrame().getValuesDialog().getClipboardFields().size() > 0)
               {
                   jMenuItemPaste.setEnabled(true);
               }
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.variables","Variables")) || dmn.getUserObject() instanceof JRVariable) && jrf.getMainFrame().getValuesDialog().getClipboardVariables().size() > 0)
               {
                   jMenuItemPaste.setEnabled(true);
               }
               if ((dmn.getUserObject().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.parameters","Parameters")) || dmn.getUserObject() instanceof JRParameter) && jrf.getMainFrame().getValuesDialog().getClipboardParameters().size() > 0)
               {
                   jMenuItemPaste.setEnabled(true);
               }
           }
        }
    }//GEN-LAST:event_jPopupMenuFieldsPopupMenuWillBecomeVisible

    private void jLibraryTreeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLibraryTreeMouseClicked
        
        if (evt.getClickCount() == 1 && evt.getButton() == evt.BUTTON3)
        {
            jPopupMenuFields.show(this, evt.getPoint().x, evt.getPoint().y);
        }
        if (evt.getClickCount() == 2 && evt.getButton() == evt.BUTTON1)
        {
            jMenuItemEditActionPerformed(new java.awt.event.ActionEvent(this,0,""));
        }
    }//GEN-LAST:event_jLibraryTreeMouseClicked

    public void languageChanged(it.businesslogic.ireport.util.LanguageChangedEvent evt) {
        
        fieldsNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.fields","Fields"));
        variablesNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.variables","Variables"));
        parametersNode.setUserObject(  it.businesslogic.ireport.util.I18n.getString("gui.library.parameters","Parameters"));
        jLibraryTree.updateUI();
    }
    
    public void setJReportFrame(JReportFrame jrf)
    {
       this.jrf = jrf;
       updateReportObjects();
    }
    
    private void loadCustomObjects()
    {
                
    }
    private void loadSystemObjects()
    {
          DefaultMutableTreeNode root = (DefaultMutableTreeNode)jLibraryTree.getModel().getRoot();
          root.add(new DefaultMutableTreeNode(new PageNumberObject() ));
          root.add(new DefaultMutableTreeNode(new TotalPagesObject() ));
          root.add(new DefaultMutableTreeNode(new PageXYObject() ));
          root.add(new DefaultMutableTreeNode(new TotalObject() ));
    }
    
    private void addLibraryObject(String folder, AbstractLibraryObject obj)
    {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)jLibraryTree.getModel().getRoot();
        if (folder == null || folder.length() == 0)
        {
            root.add(new DefaultMutableTreeNode(new PageNumberObject() ));       
        }
        else
        {
            // Look for folder...
            Enumeration enum_childrens = root.children();
            while (enum_childrens.hasMoreElements())
            {
                DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)enum_childrens.nextElement();
                if ( (""+dmtn.getUserObject()).equalsIgnoreCase(folder ) )
                {
                    dmtn.add(new DefaultMutableTreeNode( obj ));
                }
            }
        }
    }
    
    public void updateReportObjects()
    {
        this.fieldsNode.removeAllChildren();
       this.parametersNode.removeAllChildren();
       this.variablesNode.removeAllChildren();
       
       
       if (jrf == null) {
           
           jLibraryTree.updateUI();
           return;
       }
       
       java.util.Enumeration e = jrf.getReport().getFields().elements();
       while (e.hasMoreElements())
       {
             fieldsNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
        e = jrf.getReport().getParameters().elements();
       while (e.hasMoreElements())
       {
             parametersNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
       
        e = jrf.getReport().getVariables().elements();
       while (e.hasMoreElements())
       {
             variablesNode.add(new DefaultMutableTreeNode(e.nextElement()));
       }
        
       jLibraryTree.updateUI();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTree jLibraryTree;
    private javax.swing.JMenu jMenuAdd;
    private javax.swing.JMenuItem jMenuItemCopy;
    private javax.swing.JMenuItem jMenuItemCut;
    private javax.swing.JMenuItem jMenuItemDelete;
    private javax.swing.JMenuItem jMenuItemEdit;
    private javax.swing.JMenuItem jMenuItemNewField;
    private javax.swing.JMenuItem jMenuItemNewVariable;
    private javax.swing.JMenuItem jMenuItemParameter;
    private javax.swing.JMenuItem jMenuItemPaste;
    private javax.swing.JMenuItem jMenuItemRefresh;
    private javax.swing.JPopupMenu jPopupMenuFields;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator2;
    // End of variables declaration//GEN-END:variables
    
     public void reportObjectChanged(it.businesslogic.ireport.gui.event.ReportObjectChangedEvent evt)
     {
         this.updateReportObjects();
         
     }
}
