/*
 * ProjectExplorerTreeCellRenderer.java
 *
 *  iReport  --  Visual designer for generating JasperReports Documents
 *  Copyright (C) 2002-2003  Giulio Toffoli gt@businesslogic.it
 *
 *  This program is free software; you can redistribute  and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Giulio Toffoli
 *  Via T.Aspetti, 233
 *  35100 Padova ITALY
 *  gt@businesslogic.it
 *
 *
 * Created on 1 giugno 2003, 16.04
 */

package it.businesslogic.ireport.gui.library;
import it.businesslogic.ireport.*;
import  javax.swing.tree.*;
import  javax.swing.*;
import  java.awt.*;
/**
 *
 * @author  Administrator
 */
public class LibraryTreeCellRenderer extends DefaultTreeCellRenderer {

    static ImageIcon objectIcon;
    static ImageIcon typeIcon;
    
    static ImageIcon folderClosedIcon;
    static ImageIcon folderOpenedIcon;
    
    static ImageIcon folderFieldsIcon;
    static ImageIcon folderVariablesIcon;
    static ImageIcon folderParametersIcon;
    
    static ImageIcon fieldsIcon;
    static ImageIcon variablesIcon;
    static ImageIcon parametersIcon;
    static ImageIcon expressionIcon;
    
    public LibraryTreeCellRenderer() {
        super();
        if (objectIcon == null) objectIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/javabean/object.png"));
        if (typeIcon == null) typeIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/javabean/type.png"));
       if (folderClosedIcon == null) 
            folderClosedIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/folderClosed.gif"));
        if (folderOpenedIcon == null) 
            folderOpenedIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/folderOpened.gif"));
        
        if (expressionIcon == null) 
            expressionIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/elements/exp.png"));
        
        
        if (folderFieldsIcon == null) folderFieldsIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/fieldsfolder.gif"));
        if (folderVariablesIcon == null) folderVariablesIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/variablesfolder.gif"));
        if (folderParametersIcon == null) folderParametersIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/parametersfolder.gif"));
       
        if (fieldsIcon == null) fieldsIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/field.png"));
        if (variablesIcon == null) variablesIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/variable.png"));
        if (parametersIcon == null) parametersIcon = new javax.swing.ImageIcon(getClass().getResource("/it/businesslogic/ireport/icons/tree/editor/parameter.png"));
     
        /*
        this.setOpenIcon(folderOpenedIcon);
        this.setClosedIcon(folderClosedIcon);
        this.setLeafIcon(documentIcon);
         */
    }

    public Component getTreeCellRendererComponent(
                        JTree tree,
                        Object value,
                        boolean sel,
                        boolean expanded,
                        boolean leaf,
                        int row,
                        boolean hasFocus) {

        super.getTreeCellRendererComponent(
                        tree, value, sel,
                        expanded, leaf, row,
                        hasFocus);
            this.setForeground( Color.BLACK);
            ImageIcon icon = getElementIcon(value);
            if (icon != null) setIcon(icon);
            else
            {
                if ( expanded)
                {
                     setIcon(folderOpenedIcon);
                     setToolTipText(null); //no tool tip
                }
                else 
                {
                     setIcon(folderClosedIcon);
                     setToolTipText(null); //no tool tip
                } 
            }

            setToolTipText(null);

        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        DefaultMutableTreeNode node =
                (DefaultMutableTreeNode)value;
        this.setForeground( Color.BLACK);
           
        if (node.getUserObject() != null && node.getUserObject() instanceof AbstractLibraryObject ) 
        {
            return ((AbstractLibraryObject)node.getUserObject()).getIcon();
        }
        
        if (node.getUserObject() != null && node.getUserObject() instanceof JRField )  return fieldsIcon;
        if (node.getUserObject() != null && node.getUserObject() instanceof JRVariable )  return variablesIcon;
        if (node.getUserObject() != null && node.getUserObject() instanceof JRParameter )  return parametersIcon;
        if (node.getUserObject() != null && node.getUserObject() instanceof CustomExpression)  return expressionIcon;
        
        if (node.getUserObject().toString().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.fields","Fields"))) return folderFieldsIcon;
        if (node.getUserObject().toString().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.variables","Variables"))) return folderVariablesIcon;
        if (node.getUserObject().toString().equals(it.businesslogic.ireport.util.I18n.getString("gui.library.parameters","Parameters"))) return folderParametersIcon;
        
        return null;
        
       
        //return objectIcon;
    }
    
    
}

