/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import net.sf.jasperreports.compilers.JRGroovyGenerator;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRAbstractJavaCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.JRSaver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class JRGroovyCompiler
extends JRAbstractJavaCompiler {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$jasperreports$compilers$JRGroovyCompiler == null ? (class$net$sf$jasperreports$compilers$JRGroovyCompiler = JRGroovyCompiler.class$("net.sf.jasperreports.compilers.JRGroovyCompiler")) : class$net$sf$jasperreports$compilers$JRGroovyCompiler));
    public static final String LANGUAGE_GROOVY = "groovy";
    static /* synthetic */ Class class$net$sf$jasperreports$compilers$JRGroovyCompiler;

    public JasperReport compileReport(JasperDesign jasperDesign) throws JRException {
        String classpath;
        JasperReport jasperReport = null;
        if (!LANGUAGE_GROOVY.equals(jasperDesign.getLanguage())) {
            throw new JRException("Language \"" + jasperDesign.getLanguage() + "\" not supported by this report compiler.\n" + "Expecting \"groovy\" or \"java\" instead.");
        }
        Collection brokenRules = JRVerifier.verifyDesign((JasperDesign)jasperDesign);
        if (brokenRules != null && brokenRules.size() > 0) {
            StringBuffer sbuffer = new StringBuffer();
            sbuffer.append("Report design not valid : ");
            int i = 1;
            Iterator it = brokenRules.iterator();
            while (it.hasNext()) {
                sbuffer.append("\n\t " + i + ". " + (String)it.next());
                ++i;
            }
            throw new JRException(sbuffer.toString());
        }
        String sourceCode = JRGroovyGenerator.generateClass(jasperDesign);
        boolean isKeepJavaFile = Boolean.valueOf(System.getProperty("jasper.reports.compile.keep.java.file"));
        if (isKeepJavaFile) {
            File tempDirFile;
            String tempDirStr = System.getProperty("jasper.reports.compile.temp");
            if (tempDirStr == null || tempDirStr.length() == 0) {
                tempDirStr = System.getProperty("user.dir");
            }
            if (!(tempDirFile = new File(tempDirStr)).exists() || !tempDirFile.isDirectory()) {
                throw new JRException("Temporary directory not found : " + tempDirStr);
            }
            File javaFile = new File(tempDirFile, jasperDesign.getName() + ".groovy");
            JRSaver.saveClassSource((String)sourceCode, (File)javaFile);
        }
        if ((classpath = System.getProperty("jasper.reports.compile.class.path")) == null || classpath.length() == 0) {
            classpath = System.getProperty("java.class.path");
        }
        CompilerConfiguration config = new CompilerConfiguration();
        config.setClasspath(classpath);
        CompilationUnit unit = new CompilationUnit(config);
        unit.addSource("calculator", (InputStream)new ByteArrayInputStream(sourceCode.getBytes()));
        ClassCollector collector = new ClassCollector();
        unit.setClassgenCallback((CompilationUnit.ClassgenCallback)collector);
        try {
            unit.compile(7);
        }
        catch (CompilationFailedException e) {
            throw new JRException("Errors were encountered when compiling report expressions class file:\n" + e.toString());
        }
        if (collector.classCount == 0) {
            throw new JRException("No groovy class were generated.");
        }
        if (collector.classCount > 1) {
            throw new JRException("More than one groovy class were generated.\nPlease make sure that you don't use Groovy features such as closures that are not supported by this report compiler.\n");
        }
        jasperReport = new JasperReport((JRReport)jasperDesign, ((Object)((Object)this)).getClass().getName(), (Object)collector.bytes);
        return jasperReport;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClassCollector
    extends CompilationUnit.ClassgenCallback {
        public byte[] bytes;
        public int classCount;

        private ClassCollector() {
        }

        public void call(ClassVisitor writer, ClassNode node) throws CompilationFailedException {
            ++this.classCount;
            if (this.bytes == null) {
                this.bytes = ((ClassWriter)writer).toByteArray();
            }
        }
    }
}

