/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Trace;

class User {
    private boolean bAdministrator;
    private Hashtable hRight = new Hashtable();
    private String sName;
    private String sPassword;
    private User uPublic;

    User(String string, String string2, boolean bl, User user) {
        this.sName = string;
        this.setPassword(string2);
        this.bAdministrator = bl;
        this.uPublic = user;
    }

    String getName() {
        return this.sName;
    }

    String getPassword() {
        return this.sPassword;
    }

    Hashtable getRights() {
        return this.hRight;
    }

    void setPassword(String string) {
        this.sPassword = string;
    }

    void checkPassword(String string) throws SQLException {
        Trace.check(string.equals(this.sPassword), 31);
    }

    void grant(String string, int n) {
        Integer n2 = (Integer)this.hRight.get(string);
        n2 = n2 == null ? new Integer(n) : new Integer(n2 | n);
        this.hRight.put(string, n2);
    }

    void revoke(String string, int n) {
        Integer n2 = (Integer)this.hRight.get(string);
        n2 = n2 == null ? new Integer(n) : new Integer(n2 & 15 - n);
        this.hRight.put(string, n2);
    }

    void revokeAll() {
        this.hRight = null;
        this.bAdministrator = false;
    }

    void check(String string, int n) throws SQLException {
        if (this.bAdministrator) {
            return;
        }
        Integer n2 = (Integer)this.hRight.get(string);
        if (n2 != null && (n2 & n) != 0) {
            return;
        }
        if (this.uPublic != null && (n2 = (Integer)this.uPublic.hRight.get(string)) != null && (n2 & n) != 0) {
            return;
        }
        throw Trace.error(31);
    }

    void checkAdmin() throws SQLException {
        Trace.check(this.isAdmin(), 31);
    }

    boolean isAdmin() {
        return this.bAdministrator;
    }
}

